# 画面設計書: 補助サイドバー

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 4 |
| 画面名 | 補助サイドバー |
| 画面パス | `src/vs/workbench/browser/parts/auxiliarybar/auxiliaryBarPart.ts` |
| 概要 | プライマリサイドバーの反対側に配置されるセカンダリサイドバー。追加のビューコンテナを表示し、画面領域を効率的に活用する |

## 2. 画面構成

### 2.1 レイアウト概要

```
+-----------------------------------+
|     タイトル / アクション          |
+-----------------------------------+
|                                   |
|                                   |
|         ビューコンテナ             |
|      (チャット、アウトライン等)     |
|                                   |
|                                   |
+-----------------------------------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| headerArea | ヘッダーエリア | はい | 常時 |
| titleLabel | ビューコンテナ名 | はい | 常時 |
| titleActionsContainer | アクションボタンエリア | はい | 常時 |
| content | コンテンツエリア | はい | 常時 |
| compositeBar | コンポジットバー | いいえ | 設定依存 |
| paneComposite | ビューコンテナの実体 | はい | 常時 |

## 3. 機能仕様

### 3.1 ビューコンテナ管理

- **AuxiliaryBarPart**: サイドバーと同様の構造
- **ビューの配置**: サイドバーからのビュー移動が可能
- **独立した表示**: サイドバーとは独立して表示/非表示

### 3.2 配置位置

- **サイドバーの反対側**: サイドバーが左なら右、右なら左
- **動的切り替え**: サイドバー位置変更に追従

### 3.3 最大化機能

- **最大化モード**: 補助サイドバーを画面いっぱいに拡大
- **エディタ領域の非表示**: 最大化時にエディタを隠す
- **トグル操作**: コマンドで切り替え

### 3.4 サイズ調整

- **幅の変更**: ドラッグでサイズ変更
- **最小幅/最大幅**: 制限値あり
- **状態保存**: ワークスペースごとにサイズを記憶

## 4. データフロー

```
[ユーザー操作: ビュー選択]
         |
         v
[PaneCompositeService.openPaneComposite(ViewContainerLocation.AuxiliaryBar)]
         |
         v
[AuxiliaryBarPart.openComposite()]
         |
         v
[ビューコンテナの表示]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidPaneCompositeOpen | コンポジットが開いた | コンテナの表示処理 |
| onDidPaneCompositeClose | コンポジットが閉じた | コンテナの非表示処理 |
| onDidChangeVisibility | 表示状態変更 | レイアウト更新 |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.sideBar.location` | サイドバー位置（補助は反対側） | `left` |
| `workbench.panel.defaultLocation` | パネル位置との関係 | `bottom` |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `auxiliaryBarPart.ts` の `AuxiliaryBarPart` クラス
2. **基底クラス**: `AbstractPaneCompositePart` を継承（サイドバーと共通）
3. **位置計算**: `getAuxiliaryBarPosition()` でサイドバー反対側を計算

### 7.2 プログラム呼び出し階層図

```
AuxiliaryBarPart
  |
  +-- AbstractPaneCompositePart (extends)
  |     |
  |     +-- openComposite()
  |     +-- hideActiveComposite()
  |     |
  |     +-- PaneCompositeBar
  |           +-- アクティビティバー機能（オプション）
  |
  +-- ViewContainerModel
  |     +-- ビューの管理
  |
  +-- PaneComposite (children)
        +-- ViewPane (multiple)
```

### 7.3 データフロー図

```
[ビュー移動: サイドバー -> 補助サイドバー]
         |
         v
[ViewDescriptorService.moveViewToLocation]
         |
         v
[ViewContainerModel更新]
         |
         v
[AuxiliaryBarPart.openComposite]
         |
         v
[PaneComposite.setVisible(true)]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/parts/auxiliarybar/auxiliaryBarPart.ts` | 補助サイドバーパーツ本体 |
| `src/vs/workbench/browser/parts/paneCompositePart.ts` | 基底クラス（サイドバーと共通） |
| `src/vs/workbench/browser/panecomposite.ts` | ビューコンテナ基底 |
| `src/vs/workbench/common/views.ts` | ビュー定義とViewContainerLocation |
| `src/vs/workbench/services/panecomposite/browser/panecomposite.ts` | サービス定義 |

### 7.5 重要なコードスニペット

**AuxiliaryBarPartクラスの構造（auxiliaryBarPart.ts）**
```typescript
export class AuxiliaryBarPart extends AbstractPaneCompositePart {
  static readonly activePanelSettingsKey = 'workbench.auxiliarybar.activepanelid';
  static readonly pinnedPanelsKey = 'workbench.auxiliarybar.pinnedPanels';

  readonly minimumWidth: number = 170;
  readonly maximumWidth: number = Number.POSITIVE_INFINITY;
  readonly minimumHeight: number = 0;
  readonly maximumHeight: number = Number.POSITIVE_INFINITY;

  constructor(
    @INotificationService notificationService: INotificationService,
    @IStorageService storageService: IStorageService,
    // ... 他の依存関係
  ) {
    super(
      Parts.AUXILIARYBAR_PART,
      { hasTitle: true, borderWidth: () => ... },
      // ...
    );
  }

  get preferredWidth(): number | undefined {
    // 幅の優先設定を取得
  }
}
```

**位置取得ロジック**
```typescript
private getAuxiliaryBarPosition(): Position {
  // サイドバーの反対側を返す
  return this.layoutService.getSideBarPosition() === Position.LEFT
    ? Position.RIGHT
    : Position.LEFT;
}
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| アクティビティバー | アイコンクリック | ビューコンテナの切り替え |
| コマンドパレット | コマンド実行 | 表示/非表示の切り替え |
| サイドバー | ビューの移動 | ドラッグ&ドロップ |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| 各種ビュー | 選択操作 | ビューコンテンツの表示 |
| サイドバー | ビューの移動 | ドラッグ&ドロップで戻す |

## 9. スタイリング

### 9.1 テーマカラー

| カラーID | 説明 |
|----------|------|
| `sideBar.background` | 背景色（サイドバーと共有） |
| `sideBar.foreground` | 前景色（サイドバーと共有） |
| `sideBar.border` | ボーダー色（サイドバーと共有） |

### 9.2 CSSクラス

| クラス名 | 説明 |
|----------|------|
| `.part.auxiliarybar` | 補助サイドバーコンテナ |
| `.composite.title` | タイトルエリア |
| `.content` | コンテンツエリア |

## 10. サイドバーとの違い

| 項目 | サイドバー | 補助サイドバー |
|------|------------|----------------|
| 位置 | 左または右（設定） | サイドバーの反対側 |
| 識別子 | Parts.SIDEBAR_PART | Parts.AUXILIARYBAR_PART |
| デフォルト表示 | 常時 | 非表示 |
| ビューコンテナ | エクスプローラ等 | チャット等 |

## 11. アクセシビリティ

- **キーボードナビゲーション**: Tab/矢印キーでビュー間移動
- **フォーカス管理**: `workbench.action.focusAuxiliaryBar`コマンド
- **ARIAロール**: tree, treeitemの適切な設定
- **スクリーンリーダー**: ビュー名とコンテンツの読み上げ
