# 画面設計書 40-逆アセンブリビュー

## 概要

本ドキュメントは、VS Codeの逆アセンブリビュー（Disassembly View）画面の設計仕様を定義する。デバッグセッション中にマシンコード/アセンブリ命令を表示し、低レベルデバッグを可能にするエディタペインである。

### 本画面の処理概要

逆アセンブリビューは、デバッグアダプタから取得した逆アセンブル命令をテーブル形式で表示し、命令レベルでのブレークポイント設定やステップ実行を可能にする。

**業務上の目的・背景**：システムプログラミングや最適化作業において、ソースコードレベルではなくマシンコードレベルでの動作を確認する必要がある。このビューにより、開発者はCPUが実際に実行する命令を確認し、命令単位でのデバッグが可能になる。

**画面へのアクセス方法**：
- コマンドパレット「Debug: Open Disassembly View」
- 命令ブレークポイントのコンテキストからジャンプ
- デバッガが逆アセンブリをサポートしている場合のみ利用可能

**主要な操作・処理内容**：
1. 命令表示：アドレス、オペコード、オペランドの表示
2. 命令ブレークポイント：命令にブレークポイントを設定
3. ソースコード表示：対応するソースコード行を表示（オプション）
4. スクロールロード：スクロールに応じて追加命令を読み込み
5. アドレスへジャンプ：指定アドレスへ移動
6. 現在のフレームへジャンプ：実行中の命令位置へ移動

**画面遷移**：
- 遷移元：コマンドパレット、ブレークポイントビュー
- 遷移先：なし（エディタペイン）

**権限による表示制御**：デバッガがdisassembleリクエストをサポートしている場合のみ表示可能（CONTEXT_LANGUAGE_SUPPORTS_DISASSEMBLE_REQUEST）。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | デバッグ | 主機能 | 逆アセンブリ命令の表示・デバッグ |
| 65 | デバッグ拡張API | API連携 | Debug Adapter経由の逆アセンブリ取得 |

## 画面種別

エディタペイン（WorkbenchTableベース）

## URL/ルーティング

- ビューID: `workbench.debug.disassemblyView`（DISASSEMBLY_VIEW_ID）
- 入力: `DisassemblyViewInput`
- コンテキストキー: `CONTEXT_LANGUAGE_SUPPORTS_DISASSEMBLE_REQUEST`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|----------|------|------|
| 命令参照 | 入力 | string | 必須 | instructionPointerReference |
| オフセット | 入力 | number | - | 命令からのオフセット |
| 命令エントリ | 出力 | IDisassembledInstructionEntry[] | - | 逆アセンブル結果 |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| ブレークポイント列 | BreakpointRenderer | 命令ブレークポイントの表示・設定 |
| 命令列 | InstructionRenderer | アドレス、命令、オペランドの表示 |
| ソース行 | string | 対応するソースコード（オプション） |
| 現在位置マーカー | Color | 現在のスタックフレーム位置の強調 |
| フォーカス位置マーカー | Color | フォーカスされたスタックフレーム位置の強調 |

## イベント仕様

### 1-逆アセンブリの読み込み

1. reloadDisassembly(reference, offset)呼び出し
2. debugSession.disassemble()でDA呼び出し
3. 命令リストを取得
4. WorkbenchTableに設定

### 2-スクロールによる追加読み込み

1. onDidScrollイベント
2. 上方向スクロール: scrollUp_LoadDisassembledInstructions()
3. 下方向スクロール: scrollDown_LoadDisassembledInstructions()
4. NUM_INSTRUCTIONS_TO_LOAD = 50命令ずつ読み込み
5. _loadingLockで重複読み込み防止

### 3-命令ブレークポイント設定

1. ブレークポイント列をクリック
2. BreakpointRenderer.onClick処理
3. allowBreakpointフラグを確認
4. debugService.addInstructionBreakpoint()呼び出し
5. 表示更新

### 4-スタックフレーム変更

1. onDidFocusStackFrameイベント
2. goToInstructionAndOffset()で該当アドレスへ移動
3. _onDidChangeStackFrame発火

### 5-ソースコード表示切替

1. debug.disassemblyView.showSourceCode設定変更
2. _enableSourceCodeRenderフラグ更新
3. テーブルを再レンダリング

## データベース更新仕様

### 操作別データベース影響一覧

本画面は直接的なストレージ更新を行わない。命令ブレークポイントはデバッグモデル経由で管理される。

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| instructionNotAvailable | 情報 | 逆アセンブリ不可 | Disassembly not available. |
| disassemblyTableColumnLabel | ラベル | テーブルヘッダ | instructions |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 逆アセンブリ未サポート | disassemblyNotAvailableプレースホルダを表示 |
| アドレス範囲外 | スクロール位置を維持 |

## 備考

- EditorPaneを継承したエディタペイン
- NUM_INSTRUCTIONS_TO_LOAD = 50命令（1回のロード単位）
- エディタのフォント設定（fontInfo）を使用
- _referenceToMemoryAddressでアドレスマッピングを管理
- editorBackground色をリスト背景に使用
- ソースコード表示時は行の高さが動的に変化

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

逆アセンブル命令のエントリ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | IDisassembledInstructionEntryインターフェース |

**読解のコツ**: instructionReference、instructionOffset、addressの関係を理解する。

#### Step 2: エントリーポイントを理解する

DisassemblyViewクラスの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | DisassemblyViewクラス（EditorPaneを継承） |

**主要処理フロー**:
1. **87行目**: `class DisassemblyView extends EditorPane` - EditorPaneを継承
2. **89行目**: NUM_INSTRUCTIONS_TO_LOAD = 50
3. **204-368行目**: `createEditor` - UI構築、テーブル作成
4. **374-384行目**: `goToInstructionAndOffset` - アドレスへの移動

#### Step 3: レンダラーを理解する

命令とブレークポイントのレンダリングを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | BreakpointRenderer, InstructionRenderer |

**主要処理フロー**:
- **226行目**: InstructionRenderer作成
- **249行目**: BreakpointRenderer作成
- テーブル列の定義（ブレークポイント列、命令列）

#### Step 4: スクロールとロードを理解する

動的な命令読み込みを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | onDidScroll, scrollUp_LoadDisassembledInstructions, scrollDown_LoadDisassembledInstructions |

**主要処理フロー**:
- **272-292行目**: onDidScrollハンドラ
- _loadingLockで重複防止
- loadDisassembledInstructionsでDA呼び出し

### プログラム呼び出し階層図

```
DisassemblyView (EditorPane)
    │
    ├─ createEditor()
    │      ├─ ITableVirtualDelegate (高さ計算)
    │      └─ WorkbenchTable 作成
    │             ├─ BreakpointRenderer (ブレークポイント列)
    │             └─ InstructionRenderer (命令列)
    │
    ├─ reloadDisassembly()
    │      └─ loadDisassembledInstructions()
    │             └─ debugSession.disassemble()
    │
    ├─ onDidScroll()
    │      ├─ scrollUp_LoadDisassembledInstructions()
    │      └─ scrollDown_LoadDisassembledInstructions()
    │
    ├─ goToInstructionAndOffset()
    │      └─ goToAddress()
    │             └─ table.reveal()
    │
    └─ onDidFocusStackFrame()
           └─ goToInstructionAndOffset()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

スタックフレーム ────▶ focusedInstructionReference ▶ reloadDisassembly
    │                        │
    ▼                        ▼
instructionPointer    loadDisassembledInstructions
Reference                    │
                            ▼
                    debugSession.disassemble()
                            │
                            ▼
                    IDisassembledInstructionEntry[]
                            │
                            ▼
                    WorkbenchTable.splice()
                            │
                            ▼
                    テーブル表示

スクロール ─────────▶ onDidScroll ────────────▶ 追加命令読み込み
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| disassemblyView.ts | `src/vs/workbench/contrib/debug/browser/disassemblyView.ts` | ソース | メインのDisassemblyViewクラス |
| disassemblyViewInput.ts | `src/vs/workbench/contrib/debug/common/disassemblyViewInput.ts` | ソース | エディタ入力クラス |
| debugModel.ts | `src/vs/workbench/contrib/debug/common/debugModel.ts` | ソース | InstructionBreakpointモデル |
| debug.ts | `src/vs/workbench/contrib/debug/common/debug.ts` | ソース | DISASSEMBLY_VIEW_ID等 |
| debugCommands.ts | `src/vs/workbench/contrib/debug/browser/debugCommands.ts` | ソース | COPY_ADDRESS_IDコマンド |
| callStackEditorContribution.ts | `src/vs/workbench/contrib/debug/browser/callStackEditorContribution.ts` | ソース | topStackFrameColor, focusedStackFrameColor |
| debugIcons.ts | `src/vs/workbench/contrib/debug/browser/debugIcons.ts` | ソース | アイコン定義 |
| editorPane.ts | `src/vs/workbench/browser/parts/editor/editorPane.ts` | ソース | EditorPaneベースクラス |
