# 画面設計書 41-SCMリポジトリビュー

## 概要

本ドキュメントは、VSCodeのSCMリポジトリビュー画面の設計を記載したものです。SCMリポジトリビューは、複数のソース管理リポジトリを一覧表示し、管理するための画面コンポーネントです。

### 本画面の処理概要

SCMリポジトリビューは、Visual Studio Codeのソース管理機能において、ワークスペース内の複数のGitリポジトリや他のSCMプロバイダーを一元管理するためのビューペインです。

**業務上の目的・背景**：
現代のソフトウェア開発では、モノレポ構成や複数プロジェクトを同時に扱うことが増加しています。SCMリポジトリビューは、複数のリポジトリを同時に表示し、それぞれの状態を把握しながら効率的にバージョン管理作業を行うことを可能にします。ユーザーは表示するリポジトリを選択し、フォーカスを切り替えながら作業できます。

**画面へのアクセス方法**：
- サイドバーの「ソース管理」ビュー内の「ソース管理リポジトリ」セクションを展開
- コマンドパレットから「View: Show Source Control Repositories」を実行
- 設定 `scm.repositories.visible` で表示リポジトリ数を制御可能

**主要な操作・処理内容**：
1. リポジトリ一覧の表示：ワークスペース内の全SCMリポジトリをツリー形式で表示
2. リポジトリの選択：クリックでリポジトリにフォーカスを移動し、詳細情報をソース管理ビューに表示
3. アーティファクト（成果物）グループの展開：リポジトリを展開してアーティファクト（タグ、ブランチなど）を表示
4. コンテキストメニュー操作：右クリックでリポジトリ固有のアクション（フェッチ、プル、プッシュなど）を実行
5. 複数選択モード：設定 `scm.repositories.selectionMode` で複数リポジトリの同時選択が可能

**画面遷移**：
- アクティビティバー → サイドバー（ソース管理）→ SCMリポジトリビュー
- リポジトリ選択 → ソース管理ビュー（変更ファイル一覧）
- アーティファクト選択 → 差分エディタまたはファイル表示

**権限による表示制御**：
- リポジトリの読み取り権限がない場合、リポジトリは表示されるがアクションが制限される
- SCMプロバイダーの拡張機能がインストールされていない場合、該当リポジトリは表示されない

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | ソース管理 | 主機能 | 複数リポジトリの管理 |
| 74 | Git統合 | 補助機能 | Gitリポジトリの操作連携 |

## 画面種別

一覧（ツリービュー）

## URL/ルーティング

ビューID: `workbench.scm.views.repositories`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| リポジトリ一覧 | 出力 | ISCMRepository[] | Yes | 表示するリポジトリの配列 |
| 選択リポジトリ | 入力/出力 | ISCMRepository[] | No | 現在選択されているリポジトリ |
| アーティファクトグループ | 出力 | SCMArtifactGroupTreeElement[] | No | リポジトリ配下のアーティファクトグループ |
| ビュー状態 | 入力/出力 | IAsyncDataTreeViewState | No | 展開/折りたたみ状態の永続化 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| リポジトリアイコン | 行左部 | SCMプロバイダーのアイコン（Git、SVNなど） |
| リポジトリ名 | 行中央 | プロバイダーが提供するリポジトリ名 |
| アクションバー | 行右部（ホバー時） | インラインアクションボタン |
| アーティファクトアイコン | 子行左部 | アーティファクトの種別アイコン |
| アーティファクト名 | 子行中央 | アーティファクト名と説明 |
| タイムスタンプ | 子行右部 | アーティファクトの作成日時（相対表示） |

## イベント仕様

### 1-リポジトリ選択

リポジトリをクリックすると、以下の処理が実行されます：
1. `onTreeSelectionChange` イベントが発火
2. `scmViewService.visibleRepositories` が更新される
3. 関連するソース管理ビューが選択されたリポジトリの内容を表示
4. スクロール位置が維持される

### 2-リポジトリ展開

リポジトリのツイストアイコンをクリックすると：
1. `tree.expand()` でリポジトリノードを展開
2. `RepositoryTreeDataSource.getChildren()` でアーティファクトグループを取得
3. アーティファクトプロバイダーの `provideArtifactGroups()` が呼び出される
4. 取得したアーティファクトグループがツリーに追加表示

### 3-コンテキストメニュー表示

右クリックで：
1. `onTreeContextMenu` イベントが発火
2. `scmViewService.menus.getRepositoryMenus()` でメニュー定義を取得
3. `collectContextMenuActions()` でアクション一覧を構築
4. コンテキストメニューを表示

### 4-アーティファクトオープン

アーティファクトをダブルクリックすると：
1. `onTreeDidOpen` イベントが発火
2. アーティファクトに関連付けられた `command` が取得される
3. `commandService.executeCommand()` でコマンドを実行
4. 通常は差分エディタまたはファイルエディタが開く

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ビュー状態保存 | Storage (workspace) | UPDATE | ツリーの展開/折りたたみ状態を永続化 |
| リポジトリ選択 | Memory (transient) | UPDATE | 可視リポジトリの選択状態を更新 |

### テーブル別更新項目詳細

#### Storage (workspace)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | scm.repositoriesViewState | JSON形式の展開状態 | `IAsyncDataTreeViewState` |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| scm | 情報 | "Source Control Repositories" | Aria Label |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| リポジトリ取得失敗 | エラーをログ出力し、空リストを表示 | なし（静かに失敗） |
| アーティファクト取得失敗 | Promise.resolve([])を返却 | なし |
| 無効なツリー要素 | Error をスロー | "Invalid tree element" |

## 備考

- `scm.repositories.visible` 設定により、表示するリポジトリ数の上限を制御可能（デフォルト: 10）
- `scm.providerCountBadge` 設定で変更数バッジの表示を制御可能（hidden/auto/visible）
- エクスプローラーモード（`scm.repositories.explorer`）が有効な場合、リポジトリを展開してアーティファクトを表示可能
- ビュー状態は `StorageScope.WORKSPACE` に保存され、ワークスペースごとに独立

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SCMリポジトリビューで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ISCMRepository, ISCMService, ISCMViewServiceインターフェースの定義 |
| 1-2 | artifact.ts | `src/vs/workbench/contrib/scm/common/artifact.ts` | SCMArtifactGroupTreeElement, SCMArtifactTreeElementの型定義 |

**読解のコツ**: TypeScriptのインターフェース定義に注目し、リポジトリとアーティファクトの関係性を把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるビューペインクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scmRepositoriesViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts` | SCMRepositoriesViewPaneクラスがビューのメインコンポーネント |

**主要処理フロー**:
1. **L429-469**: コンストラクタで依存サービスを注入、設定値のObservableを初期化
2. **L471-542**: `renderBody()`でツリービューを構築、イベントリスナーを登録
3. **L554-629**: `createTree()`でWorkbenchCompressibleAsyncDataTreeを生成

#### Step 3: ツリーデータソースを理解する

ツリーに表示するデータの取得ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scmRepositoriesViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts` | RepositoryTreeDataSourceクラス（L271-401） |

**主要処理フロー**:
- **L276-372**: `getChildren()`でツリー要素の子ノードを非同期取得
- **L374-400**: `hasChildren()`で子ノードの存在をチェック

#### Step 4: レンダラーを理解する

ツリー要素の描画処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | scmRepositoryRenderer.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts` | RepositoryRendererクラスによるリポジトリ行の描画 |
| 4-2 | scmRepositoriesViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts` | ArtifactGroupRenderer, ArtifactRendererクラス（L80-269） |

### プログラム呼び出し階層図

```
SCMRepositoriesViewPane
    │
    ├─ renderBody()
    │      ├─ createTree()
    │      │      ├─ ListDelegate
    │      │      ├─ RepositoriesTreeCompressionDelegate
    │      │      ├─ RepositoryRenderer
    │      │      ├─ ArtifactGroupRenderer
    │      │      └─ ArtifactRenderer
    │      │
    │      └─ RepositoryTreeDataSource
    │             ├─ getChildren()
    │             │      └─ ISCMRepository.provider.artifactProvider
    │             │             └─ provideArtifactGroups()
    │             │             └─ provideArtifacts()
    │             └─ hasChildren()
    │
    ├─ onTreeSelectionChange()
    │      └─ scmViewService.visibleRepositories
    │
    └─ onTreeContextMenu()
           └─ scmViewService.menus.getRepositoryMenus()
                  └─ collectContextMenuActions()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ISCMService        ───▶ SCMRepositoriesViewPane ───▶ ツリービュー表示
  └─ repositories        │
                         ├─ RepositoryTreeDataSource
                         │      └─ getChildren()
                         │
ISCMViewService    ───▶ ├─ 選択状態管理
  └─ visibleRepos        │      └─ onTreeSelectionChange
                         │
StorageService     ◀──▶ └─ 状態永続化
                              └─ loadTreeViewState()
                              └─ storeTreeViewState()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scmRepositoriesViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts` | ソース | メインビューペインコンポーネント |
| scmRepositoryRenderer.ts | `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts` | ソース | リポジトリ行のレンダラー |
| scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ソース | SCM関連インターフェース定義 |
| artifact.ts | `src/vs/workbench/contrib/scm/common/artifact.ts` | ソース | アーティファクト関連型定義 |
| util.ts | `src/vs/workbench/contrib/scm/browser/util.ts` | ソース | ユーティリティ関数群 |
| scmViewService.ts | `src/vs/workbench/contrib/scm/browser/scmViewService.ts` | ソース | ビューサービス実装 |
| scm.css | `src/vs/workbench/contrib/scm/browser/media/scm.css` | スタイル | SCMビュー用スタイルシート |
