# 画面設計書 42-SCM履歴ビュー

## 概要

本ドキュメントは、VSCodeのSCM履歴ビュー画面の設計を記載したものです。SCM履歴ビューは、Gitコミット履歴をグラフ形式で表示し、履歴の参照・操作を行うための画面コンポーネントです。

### 本画面の処理概要

SCM履歴ビューは、Visual Studio Codeのソース管理機能において、リポジトリのコミット履歴をビジュアルなグラフ表示で閲覧できるビューペインです。ブランチの分岐・マージ関係を視覚的に把握でき、各コミットの詳細情報にアクセスできます。

**業務上の目的・背景**：
ソフトウェア開発において、コミット履歴の把握はコードレビュー、デバッグ、リリース管理などの重要な作業に不可欠です。SCM履歴ビューは、従来のテキストベースのログ表示に代わり、ブランチ関係を視覚的に理解しやすいグラフ形式で履歴を提供します。特にIncoming/Outgoing変更の把握や、特定コミットの変更内容確認に役立ちます。

**画面へのアクセス方法**：
- サイドバーの「ソース管理」ビュー内の「グラフ」または「履歴」セクションを展開
- コマンドパレットから関連コマンドを実行
- ソース管理ビューのツールバーからアクセス

**主要な操作・処理内容**：
1. コミット履歴グラフの表示：ブランチの分岐・マージをSwimlane形式で視覚化
2. リポジトリ/ブランチの切り替え：ピッカーで表示対象を選択
3. 履歴アイテムの参照：コミットID、件名、作者、日時を表示
4. 変更内容の表示：コミットをダブルクリックでマルチ差分エディタを開く
5. リフレッシュ：最新の履歴情報に更新
6. 表示モード切替：リスト表示とツリー表示の切り替え

**画面遷移**：
- アクティビティバー → サイドバー（ソース管理）→ SCM履歴ビュー
- コミット選択 → マルチ差分エディタ（変更ファイル一覧）
- ファイル選択 → 差分エディタまたはファイルエディタ

**権限による表示制御**：
- リポジトリの読み取り権限が必要
- 履歴プロバイダーが有効なSCMプロバイダーのみ対応

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | ソース管理 | 主機能 | Gitコミット履歴のグラフ表示 |
| 74 | Git統合 | 補助機能 | Git履歴の取得 |

## 画面種別

一覧（ツリー/グラフビュー）

## URL/ルーティング

ビューID: `workbench.scm.views.history` (HISTORY_VIEW_PANE_ID)

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| リポジトリ | 入力 | ISCMRepository | Yes | 表示対象のリポジトリ |
| 履歴アイテムフィルター | 入力 | 'all' \| 'auto' \| ISCMHistoryItemRef[] | Yes | 表示するブランチ/タグのフィルター |
| 履歴アイテム一覧 | 出力 | ISCMHistoryItemViewModel[] | Yes | 表示するコミット履歴 |
| 変更ファイル一覧 | 出力 | ISCMHistoryItemChange[] | No | 選択コミットの変更ファイル |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| グラフ表示 | 行左部 | Swimlane形式のブランチグラフ |
| コミット件名 | 行中央 | コミットメッセージの1行目 |
| 作者名 | 行中央（説明） | コミットの作者 |
| コミットバッジ | 件名右側 | HEAD、リモート追跡などのラベル |
| アクションバー | 行右部（ホバー時） | 変更を開くなどのアクション |
| ファイルアイコン | 子行左部 | 変更ファイルの種別アイコン |
| ファイルパス | 子行中央 | 変更されたファイルのパス |

## イベント仕様

### 1-リポジトリピッカー

ツールバーのリポジトリピッカーをクリックすると：
1. `PICK_REPOSITORY_ACTION_ID` アクションが実行
2. `pickRepository()` メソッドが呼び出される
3. クイックピックで利用可能なリポジトリ一覧を表示
4. 選択されたリポジトリで履歴を再描画

### 2-ブランチ/タグピッカー

ツールバーの参照ピッカーをクリックすると：
1. `PICK_HISTORY_ITEM_REFS_ACTION_ID` アクションが実行
2. `pickHistoryItemRef()` メソッドが呼び出される
3. クイックピックでブランチ/タグ一覧を表示
4. 選択に応じて 'all'/'auto'/特定参照でフィルタリング

### 3-コミット展開/変更表示

コミット行をダブルクリックまたはアクションボタンをクリックすると：
1. `workbench.scm.action.graph.viewChanges` アクションが実行
2. 履歴プロバイダーから変更情報を取得
3. `_workbench.openMultiDiffEditor` コマンドでマルチ差分エディタを開く
4. 親コミットとの差分を表示

### 4-ファイルオープン

変更ファイルをダブルクリックすると：
1. `workbench.scm.action.graph.openFile` アクションが実行
2. `editorService.openEditor()` でファイルを開く
3. 該当バージョンのファイル内容を表示

### 5-リフレッシュ

ツールバーのリフレッシュボタンをクリックすると：
1. `workbench.scm.action.graph.refresh` アクションが実行
2. `refresh()` メソッドが呼び出される
3. 履歴プロバイダーから最新データを再取得
4. ツリービューを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 表示モード変更 | Storage (workspace) | UPDATE | リスト/ツリー表示モードを永続化 |
| バッジ設定変更 | Configuration | UPDATE | バッジ表示設定を更新 |

### テーブル別更新項目詳細

#### Storage (workspace)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | scm.graph.viewMode | 'list' \| 'tree' | 表示モード設定 |
| UPDATE | scm.graph.badges | 'all' \| 'filter' | バッジ表示設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| all | 情報 | "All" | 全ブランチ表示時 |
| auto | 情報 | "Auto" | 自動フィルター時 |
| items | 情報 | "{0} Items" | 複数選択時 |
| incomingChanges | 情報 | "Incoming Changes" | Incoming変更表示時 |
| outgoingChanges | 情報 | "Outgoing Changes" | Outgoing変更表示時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| 履歴プロバイダー未対応 | 空の履歴を表示 | なし |
| マージベース取得失敗 | 処理を中止 | なし（静かに失敗） |
| 変更情報取得失敗 | return で処理終了 | なし |

## 備考

- Swimlane幅は`SWIMLANE_WIDTH`定数で定義
- グラフ描画は`renderSCMHistoryItemGraph()`関数で実行
- IncomingとOutgoingの区別は特殊なID（`SCMIncomingHistoryItemId`、`SCMOutgoingHistoryItemId`）で判定
- ホバー時にコミットの詳細情報をツールチップで表示
- バッジ設定（`scm.graph.badges`）で表示ラベルを制御可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、SCM履歴ビューで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | history.ts | `src/vs/workbench/contrib/scm/common/history.ts` | ISCMHistoryItem, ISCMHistoryItemViewModelなどの型定義 |
| 1-2 | scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ISCMHistoryProviderインターフェース |

**読解のコツ**: 履歴アイテムとビューモデルの関係、グラフノードの構造に注目してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるビューペインクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scmHistoryViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts` | SCMHistoryViewPaneクラス（未完全読み込みのため推定） |

**主要処理フロー**:
1. **L163-207**: アクション登録（リポジトリピッカー、参照ピッカー、リフレッシュなど）
2. **L288-365**: viewChangesアクション実装
3. **L367-408**: openFileアクション実装
4. **L410-427**: ListDelegateでテンプレートID決定

#### Step 3: グラフ描画を理解する

履歴グラフの描画ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scmHistory.ts | `src/vs/workbench/contrib/scm/browser/scmHistory.ts` | renderSCMHistoryItemGraph関数、Swimlane描画ロジック |

#### Step 4: レンダラーを理解する

ツリー要素の描画処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | scmHistoryViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts` | HistoryItemRenderer（L439-500+）、HistoryItemChangeRenderer |

**主要処理フロー**:
- **L461-473**: renderTemplateでDOM要素を構築
- **L476-499**: renderElementでコミット情報を表示、バッジを描画

### プログラム呼び出し階層図

```
SCMHistoryViewPane
    │
    ├─ renderBody()
    │      ├─ createTree()
    │      │      ├─ ListDelegate
    │      │      ├─ HistoryItemRenderer
    │      │      │      └─ renderSCMHistoryItemGraph()
    │      │      ├─ HistoryItemChangeRenderer
    │      │      └─ HistoryItemLoadMoreRenderer
    │      │
    │      └─ DataSource
    │             └─ getChildren()
    │                    └─ historyProvider.provideHistoryItems()
    │
    ├─ pickRepository()
    │      └─ quickInputService.pick()
    │
    ├─ pickHistoryItemRef()
    │      └─ quickInputService.pick()
    │
    ├─ refresh()
    │      └─ tree.refresh()
    │
    └─ Actions
           ├─ viewChanges → openMultiDiffEditor
           └─ openFile → editorService.openEditor
```

### データフロー図

```
[入力]                       [処理]                           [出力]

ISCMRepository         ───▶ SCMHistoryViewPane          ───▶ グラフ表示
  └─ historyProvider         │
       └─ historyItems       ├─ HistoryItemRenderer
                             │      └─ renderSCMHistoryItemGraph
                             │
historyItemsFilter     ───▶ ├─ フィルタリング
  ('all'/'auto'/refs)        │
                             │
ユーザー操作           ───▶ └─ アクション実行
  (ダブルクリック)                  └─ openMultiDiffEditor
                                   └─ editorService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scmHistoryViewPane.ts | `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts` | ソース | メインビューペインコンポーネント |
| scmHistory.ts | `src/vs/workbench/contrib/scm/browser/scmHistory.ts` | ソース | グラフ描画ユーティリティ |
| history.ts | `src/vs/workbench/contrib/scm/common/history.ts` | ソース | 履歴関連型定義 |
| scm.ts | `src/vs/workbench/contrib/scm/common/scm.ts` | ソース | SCM共通インターフェース |
| scmMultiDiffSourceResolver.ts | `src/vs/workbench/contrib/multiDiffEditor/browser/scmMultiDiffSourceResolver.ts` | ソース | マルチ差分エディタ連携 |
| scm.css | `src/vs/workbench/contrib/scm/browser/media/scm.css` | スタイル | SCMビュー用スタイルシート |
