# 画面設計書 43-チャットビュー

## 概要

本ドキュメントは、VSCodeのチャットビュー画面の設計を記載したものです。チャットビューは、AIアシスタント（GitHub Copilot等）との対話インターフェースを提供するサイドバービューです。

### 本画面の処理概要

チャットビューは、Visual Studio CodeにおけるAIアシスタントとの対話を行うための主要なUIコンポーネントです。ユーザーはコード生成、質問応答、タスク実行などの指示をAIエージェントに送信し、リアルタイムで応答を受け取ることができます。

**業務上の目的・背景**：
現代のソフトウェア開発において、AIアシスタントの活用は生産性向上の重要な要素となっています。チャットビューは、開発者がコードエディタを離れることなくAIの支援を受けられる統合的なインターフェースを提供します。コード生成、デバッグ支援、ドキュメント作成、コードレビューなど多様なユースケースをサポートします。

**画面へのアクセス方法**：
- アクティビティバーのチャットアイコンをクリック
- コマンドパレットから「Chat: Open Chat」（Ctrl+Alt+I）を実行
- キーボードショートカット `Ctrl+Shift+I`

**主要な操作・処理内容**：
1. プロンプト入力：テキストエリアでAIへの指示を入力
2. メッセージ送信：Enter または送信ボタンでリクエスト送信
3. 応答表示：ストリーミング形式でAIの応答をMarkdown表示
4. コード挿入：応答内のコードブロックをエディタに挿入
5. ファイル添付：コンテキストとしてファイルやシンボルを添付
6. 履歴参照：過去のチャット履歴を参照・継続
7. エージェント選択：異なるAIエージェント（@workspace, @vscode等）を選択

**画面遷移**：
- アクティビティバー → サイドバー（チャット）→ チャットビュー
- チャット応答内リンク → エディタまたはドキュメント
- コード挿入操作 → アクティブエディタへの挿入

**権限による表示制御**：
- GitHub Copilotのサブスクリプションが必要
- 未認証時はサインインプロンプトを表示
- 拡張機能が提供するエージェントは拡張機能のインストールが必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 65 | GitHub Copilot | 主機能 | AI対話インターフェース |
| 66 | コード補完 | 補助機能 | 応答コードの挿入 |

## 画面種別

対話型（チャットインターフェース）

## URL/ルーティング

ビューID: `workbench.panel.chat.view.copilot`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| ユーザープロンプト | 入力 | string | Yes | AIへの指示テキスト |
| 添付ファイル | 入力 | IChatRequestVariableEntry[] | No | コンテキストとして添付するファイル/シンボル |
| エージェント指定 | 入力 | IChatAgentData | No | 使用するAIエージェント |
| モード | 入力 | ChatMode | No | Ask/Agent/Editモード |
| AI応答 | 出力 | IChatResponseContent[] | Yes | AIからの応答内容 |
| コードブロック | 出力 | CodeBlockPart[] | No | 応答内のコード |
| フォローアップ | 出力 | IChatFollowup[] | No | 追加質問候補 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 入力エリア | 下部 | CodeMirrorベースのプロンプト入力欄 |
| 送信ボタン | 入力欄右側 | リクエスト送信ボタン |
| 添付ボタン | 入力欄左側 | ファイル/シンボル添付ボタン |
| メッセージ一覧 | 中央 | ユーザー/AIメッセージの履歴 |
| コードブロック | メッセージ内 | シンタックスハイライト付きコード |
| アクションバー | コードブロック上部 | コピー、挿入、適用などのアクション |
| プログレス | メッセージ下部 | 応答生成中のインジケーター |
| フォローアップ | 応答下部 | 追加質問のサジェスション |

## イベント仕様

### 1-プロンプト送信

Enterキーまたは送信ボタンをクリックすると：
1. `ChatSubmitAction` が実行される
2. `chatService.sendRequest()` が呼び出される
3. 入力テキストと添付ファイルがリクエストに変換
4. エージェントサービスにリクエストが送信
5. ストリーミングで応答を受信・表示

### 2-コード挿入

コードブロックの挿入ボタンをクリックすると：
1. `InsertAtCursorAction` が実行される
2. 現在アクティブなエディタを取得
3. カーソル位置にコードを挿入
4. エディタにフォーカスを移動

### 3-ファイル添付

添付ボタンをクリックすると：
1. `AttachContextAction` が実行される
2. クイックピックでファイル/シンボルを選択
3. `chatAttachmentResolveService` で添付情報を解決
4. 入力モデルに添付として追加

### 4-メッセージコピー

コピーボタンをクリックすると：
1. `CopyAction` が実行される
2. メッセージ内容をテキストに変換
3. クリップボードにコピー
4. 成功通知を表示

### 5-チャットクリア

クリアボタンをクリックすると：
1. `ClearChatEditorAction` が実行される
2. 確認ダイアログを表示（設定による）
3. チャット履歴をクリア
4. 新しいセッションを開始

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| メッセージ送信 | Storage (global) | INSERT | チャット履歴の保存 |
| セッション終了 | Storage (global) | UPDATE | セッション状態の更新 |
| 履歴クリア | Storage (global) | DELETE | チャット履歴の削除 |

### テーブル別更新項目詳細

#### Storage (global)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | chat.sessions | JSON形式のセッションデータ | IChatModel |
| UPDATE | chat.lastSession | 最後のセッションID | セッション復元用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| askPlaceholder | プレースホルダー | "Ask {0} or type / for topics" | Ask モード時 |
| agentPlaceholder | プレースホルダー | "Ask {0} to do something" | Agent モード時 |
| editPlaceholder | プレースホルダー | "Ask {0} to edit..." | Edit モード時 |
| generateCode | 情報 | "Generate code" | 選択なしプレースホルダー |
| modifyCode | 情報 | "Modify selected code" | 選択ありプレースホルダー |
| feedbackThanks | 情報 | "Thank you for your feedback!" | フィードバック送信後 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| 認証エラー | サインインダイアログを表示 | "Sign in to use GitHub Copilot" |
| レート制限 | エラーメッセージを表示 | "Rate limit exceeded" |
| ネットワークエラー | リトライオプション付きエラー表示 | "Connection failed" |
| モデル利用不可 | 代替モデルを提案 | "Model unavailable" |

## 備考

- `ChatWidget` クラスがメインのウィジェット実装
- `ChatListRenderer` でメッセージリストを描画
- `ChatInputPart` で入力エリアを管理
- `ChatAgentService` でエージェントの管理・選択
- `ChatMode` でAsk/Agent/Editの3モードを切替
- テレメトリーは `telemetrySource` で識別
- アクセシビリティ対応（スクリーンリーダー用ラベル、キーボードナビゲーション）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、チャットビューで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | chatModel.ts | `src/vs/workbench/contrib/chat/common/model/chatModel.ts` | ChatModel, IChatRequestModel, IChatResponseModelの定義 |
| 1-2 | chatViewModel.ts | `src/vs/workbench/contrib/chat/common/model/chatViewModel.ts` | ビューモデルの定義、isResponseVMヘルパー |
| 1-3 | chatAgents.ts | `src/vs/workbench/contrib/chat/common/participants/chatAgents.ts` | IChatAgentData, IChatAgentServiceの定義 |

**読解のコツ**: モデルとビューモデルの分離を理解し、リクエスト/レスポンスのライフサイクルを把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるビューペインクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | chatViewPane.ts | `src/vs/workbench/contrib/chat/browser/widgetHosts/viewPane/chatViewPane.ts` | ChatViewPaneクラスがビューのメインコンポーネント |

**主要処理フロー**:
1. **L61-87**: コンストラクタで依存サービスを注入
2. **L89-113**: `renderBody()`でChatWidgetを構築
3. **L115-132**: モデルの設定とフォーカス管理

#### Step 3: ウィジェット実装を理解する

メインのチャットウィジェットを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | chatWidget.ts | `src/vs/workbench/contrib/chat/browser/widget/chatWidget.ts` | ChatWidgetクラスのコア実装 |
| 3-2 | chatInputPart.ts | `src/vs/workbench/contrib/chat/browser/chatInputPart.ts` | 入力エリアの実装 |
| 3-3 | chatListRenderer.ts | `src/vs/workbench/contrib/chat/browser/widget/chatListRenderer.ts` | メッセージリストのレンダリング |

#### Step 4: アクションを理解する

ユーザーアクションの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | chatExecuteActions.ts | `src/vs/workbench/contrib/chat/browser/actions/chatExecuteActions.ts` | ChatSubmitAction, CancelAction |
| 4-2 | chatCodeblockActions.ts | `src/vs/workbench/contrib/chat/browser/actions/chatCodeblockActions.ts` | InsertAtCursorAction, CopyAction |

### プログラム呼び出し階層図

```
ChatViewPane
    │
    ├─ renderBody()
    │      └─ ChatWidget
    │             ├─ ChatInputPart
    │             │      ├─ CodeEditorWidget（入力エディタ）
    │             │      └─ AttachmentWidget（添付表示）
    │             │
    │             ├─ WorkbenchList（メッセージリスト）
    │             │      └─ ChatListRenderer
    │             │             ├─ renderMarkdown()
    │             │             ├─ renderCodeBlock()
    │             │             └─ renderFollowups()
    │             │
    │             └─ setModel()
    │                    └─ ChatModel
    │
    ├─ ChatSubmitAction.run()
    │      └─ chatService.sendRequest()
    │             ├─ chatAgentService.invokeAgent()
    │             └─ responseModel.updateContent()
    │
    └─ ClearChatEditorAction.run()
           └─ chatService.clearSession()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

ユーザープロンプト     ───▶ ChatInputPart              ───▶ メッセージ表示
  └─ 添付ファイル            │
                             ├─ ChatService
                             │      └─ sendRequest()
                             │
IChatAgentService      ───▶ ├─ エージェント選択
  └─ agents                  │      └─ invokeAgent()
                             │
ストリーミング応答     ───▶ └─ ChatListRenderer
                                   ├─ renderMarkdown()
                                   ├─ renderCodeBlock()
                                   └─ renderFollowups()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| chatViewPane.ts | `src/vs/workbench/contrib/chat/browser/widgetHosts/viewPane/chatViewPane.ts` | ソース | ビューペインコンポーネント |
| chatWidget.ts | `src/vs/workbench/contrib/chat/browser/widget/chatWidget.ts` | ソース | メインウィジェット |
| chatInputPart.ts | `src/vs/workbench/contrib/chat/browser/chatInputPart.ts` | ソース | 入力エリア |
| chatListRenderer.ts | `src/vs/workbench/contrib/chat/browser/widget/chatListRenderer.ts` | ソース | メッセージレンダラー |
| chatModel.ts | `src/vs/workbench/contrib/chat/common/model/chatModel.ts` | ソース | データモデル |
| chatService.ts | `src/vs/workbench/contrib/chat/common/chatService/chatService.ts` | ソース | チャットサービス |
| chatAgents.ts | `src/vs/workbench/contrib/chat/common/participants/chatAgents.ts` | ソース | エージェント管理 |
| chatExecuteActions.ts | `src/vs/workbench/contrib/chat/browser/actions/chatExecuteActions.ts` | ソース | 実行アクション |
| chat.css | `src/vs/workbench/contrib/chat/browser/media/chat.css` | スタイル | チャットビュー用スタイル |
