# 画面設計書 45-通知センター

## 概要

本ドキュメントは、VSCodeの通知センター画面の設計を記載したものです。通知センターは、アプリケーション全体の通知メッセージを一覧表示し、管理するためのオーバーレイパネルです。

### 本画面の処理概要

通知センターは、Visual Studio Codeにおける全ての通知メッセージを集約して表示するUIコンポーネントです。情報、警告、エラーなど様々な種類の通知を一箇所で確認・操作できます。

**業務上の目的・背景**：
VSCodeでは、拡張機能やシステムから多数の通知が発生します。通知センターは、これらの通知を見逃さないよう一覧管理し、ユーザーが適切なタイミングで確認・対応できる機能を提供します。また、「Do Not Disturb（おやすみモード）」機能により、作業に集中したい時は通知を抑制できます。

**画面へのアクセス方法**：
- ステータスバー右側の通知アイコン（ベル）をクリック
- コマンドパレットから「Notifications: Show Notifications」を実行
- キーボードショートカット（デフォルトなし、カスタマイズ可能）

**主要な操作・処理内容**：
1. 通知一覧の表示：全ての通知をリスト形式で表示
2. 通知の展開/折りたたみ：長いメッセージを展開して詳細を確認
3. 通知の閉じる：個別の通知を閉じる
4. 全通知のクリア：進行中でない全通知を一括削除
5. Do Not Disturbモード：通知の表示を抑制
6. ソース別フィルター：特定のソースからの通知を抑制

**画面遷移**：
- ステータスバー → 通知センター（オーバーレイ表示）
- 通知のアクションボタン → 関連画面（設定、拡張機能など）
- 通知センター外クリック → 通知センターを閉じる

**権限による表示制御**：
- 全てのユーザーがアクセス可能
- Do Not Disturbモード有効時は通知センターが自動的に非表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 通知 | 主機能 | 通知の一覧表示・管理 |

## 画面種別

オーバーレイ（モーダルパネル）

## URL/ルーティング

コンテキストキー: `notificationsCenterVisible`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| 通知モデル | 入力 | INotificationsModel | Yes | 通知データのモデル |
| 通知一覧 | 出力 | INotificationViewItem[] | Yes | 表示する通知リスト |
| フィルター設定 | 入力 | NotificationsFilter | No | 通知フィルター（OFF/ERROR） |
| ソースフィルター | 入力 | INotificationSourceFilter[] | No | ソース別フィルター設定 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| タイトル | ヘッダー左 | "Notifications" または "No new notifications" |
| 全クリアボタン | ヘッダー右 | 全通知クリアアイコン |
| DNDボタン | ヘッダー右 | Do Not Disturb設定ドロップダウン |
| 閉じるボタン | ヘッダー右 | 通知センターを閉じる |
| 通知リスト | 中央 | 通知アイテムのリスト |
| アイコン | 通知行左 | 重大度アイコン（Info/Warning/Error） |
| メッセージ | 通知行中央 | 通知テキスト |
| アクションボタン | 通知行右 | 通知固有のアクション |
| 展開ボタン | 通知行右 | 詳細の展開/折りたたみ |

## イベント仕様

### 1-通知センター表示

ステータスバーの通知アイコンをクリックすると：
1. `show()` メソッドが呼び出される
2. コンテナがまだ作成されていない場合は `create()` を実行
3. `updateTitle()` でタイトルを設定
4. `notificationsList.show()` でリストを表示
5. `notificationsList.updateNotificationsList()` で通知を描画
6. `notificationsCenterVisibleContextKey.set(true)` でコンテキスト更新
7. `_onDidChangeVisibility.fire()` でイベント発火

### 2-通知のクリア

全クリアボタンをクリックすると：
1. `clearAll()` メソッドが呼び出される
2. `hide()` で通知センターを非表示
3. 進行中でない全通知に対して `notification.close()` を実行
4. `accessibilitySignalService.playSignal(AccessibilitySignal.clear)` でサウンド再生

### 3-通知の個別変更

通知が追加/変更/削除されると：
1. `onDidChangeNotification()` イベントハンドラが実行
2. `NotificationChangeType` に応じて処理を分岐
3. ADD: リストに通知を挿入
4. CHANGE: アクションまたはメッセージの変更を反映
5. EXPAND_COLLAPSE: 通知アイテムを再描画
6. REMOVE: リストから通知を削除
7. 通知が0件になったら `hide()` を実行

### 4-Do Not Disturb設定

DNDボタンをクリックすると：
1. `DropdownMenuActionViewItem` がドロップダウンを表示
2. `ToggleDoNotDisturbAction` で全体のDNDを切替
3. `ToggleDoNotDisturbBySourceAction` でソース別設定を表示
4. `notificationService.setFilter()` でフィルターを適用
5. DNDモード有効時は通知センターが自動的に非表示

### 5-通知センター非表示

閉じるボタンまたは外側クリックで：
1. `hide()` メソッドが呼び出される
2. コンテナから `visible` クラスを削除
3. `notificationsList.hide()` でリストを非表示
4. 全通知の `updateVisibility(false)` を実行
5. `notificationsCenterVisibleContextKey.set(false)` でコンテキスト更新
6. フォーカスをエディタグループに戻す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| DND設定変更 | Configuration | UPDATE | Do Not Disturb設定の永続化 |
| ソースフィルター変更 | Configuration | UPDATE | ソース別フィルターの永続化 |

### テーブル別更新項目詳細

#### Configuration

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | notifications.doNotDisturbMode | boolean | DND有効/無効 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notificationsEmpty | タイトル | "No new notifications" | 通知0件時 |
| notifications | タイトル | "Notifications" | 通知あり時 |
| notificationsToolbar | Aria | "Notification Center Actions" | ツールバーラベル |
| notificationsCenterWidgetAriaLabel | Aria | "Notifications Center" | リストラベル |
| turnOnNotifications | メニュー | "Enable Do Not Disturb Mode" | DND OFF時 |
| turnOffNotifications | メニュー | "Disable Do Not Disturb Mode" | DND ON時 |
| moreSources | メニュー | "More..." | ソース10件超過時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| 通知モデル未初期化 | early return | なし |
| リスト未初期化 | early return | なし |
| エラーフィルター有効 | 通知センターを非表示 | なし |

## 備考

- `NotificationsCenter` クラスが `Themable` を継承（テーマ対応）
- 最大サイズは `MAX_DIMENSIONS` で 450x400px に制限
- ソースフィルターは最大10件まで表示（`MAX_NOTIFICATION_SOURCES`）
- `NotificationActionRunner` でアクション実行を管理
- `ActionBar` でツールバーを構築
- `WorkbenchList` で通知リストを表示
- `NotificationsListDelegate` と `NotificationRenderer` でリストを描画
- `NotificationFocusedContext` でフォーカス状態をコンテキストキーで管理

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知センターで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | notifications.ts | `src/vs/workbench/common/notifications.ts` | INotificationsModel, INotificationViewItem, NotificationChangeType |
| 1-2 | notification.ts | `src/vs/platform/notification/common/notification.ts` | INotificationService, NotificationsFilter |

**読解のコツ**: 通知の状態（展開/折りたたみ、進行中）と変更イベントの種類を把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるメインクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | notificationsCenter.ts | `src/vs/workbench/browser/parts/notifications/notificationsCenter.ts` | NotificationsCenterクラス |

**主要処理フロー**:
1. **L33-70**: コンストラクタで依存サービスを注入、コンテキストキーをバインド
2. **L72-76**: registerListeners()でイベントリスナーを登録
3. **L88-135**: show()で通知センターを表示
4. **L149-232**: create()でDOM構造を構築
5. **L240-292**: onDidChangeNotification()で通知変更を処理
6. **L294-319**: hide()で通知センターを非表示
7. **L373-385**: clearAll()で全通知をクリア

#### Step 3: リスト表示を理解する

通知リストの表示ロジックを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notificationsList.ts | `src/vs/workbench/browser/parts/notifications/notificationsList.ts` | NotificationsListクラス |
| 3-2 | notificationsViewer.ts | `src/vs/workbench/browser/parts/notifications/notificationsViewer.ts` | NotificationsListDelegate, NotificationRenderer |

**主要処理フロー**:
- **L30-46**: コンストラクタでインスタンスサービスを注入
- **L47-59**: show()でリストを表示、必要に応じて作成
- **L61-132**: createNotificationsList()でWorkbenchListを構築
- **L134-184**: updateNotificationsList()で通知を更新

#### Step 4: アクションを理解する

ツールバーアクションの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | notificationsActions.ts | `src/vs/workbench/browser/parts/notifications/notificationsActions.ts` | ClearAllNotificationsAction, ConfigureDoNotDisturbAction, HideNotificationsCenterAction |

### プログラム呼び出し階層図

```
NotificationsCenter
    │
    ├─ show()
    │      ├─ create() [初回のみ]
    │      │      ├─ ActionBar（ツールバー）
    │      │      │      ├─ ClearAllNotificationsAction
    │      │      │      ├─ ConfigureDoNotDisturbAction
    │      │      │      └─ HideNotificationsCenterAction
    │      │      │
    │      │      └─ NotificationsList
    │      │             └─ WorkbenchList
    │      │                    └─ NotificationRenderer
    │      │
    │      ├─ updateTitle()
    │      ├─ notificationsList.show()
    │      ├─ notificationsList.updateNotificationsList()
    │      └─ notificationsCenterVisibleContextKey.set(true)
    │
    ├─ hide()
    │      ├─ notificationsList.hide()
    │      └─ notificationsCenterVisibleContextKey.set(false)
    │
    ├─ onDidChangeNotification()
    │      ├─ NotificationChangeType.ADD → updateNotificationsList()
    │      ├─ NotificationChangeType.CHANGE → updateNotificationsList/Height()
    │      ├─ NotificationChangeType.EXPAND_COLLAPSE → updateNotificationsList()
    │      └─ NotificationChangeType.REMOVE → updateNotificationsList()
    │
    └─ clearAll()
           ├─ hide()
           └─ notification.close() [foreach]
```

### データフロー図

```
[入力]                       [処理]                           [出力]

INotificationsModel    ───▶ NotificationsCenter         ───▶ 通知リスト表示
  └─ notifications           │
       └─ INotificationViewItem  ├─ NotificationsList
                             │      └─ WorkbenchList
                             │             └─ NotificationRenderer
                             │
INotificationService   ───▶ ├─ フィルター管理
  └─ filter                  │      └─ setFilter()
                             │
ユーザー操作           ───▶ └─ アクション実行
  (クリア/DND/閉じる)              ├─ clearAll()
                                   ├─ setFilter()
                                   └─ hide()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| notificationsCenter.ts | `src/vs/workbench/browser/parts/notifications/notificationsCenter.ts` | ソース | メインコンポーネント |
| notificationsList.ts | `src/vs/workbench/browser/parts/notifications/notificationsList.ts` | ソース | 通知リスト |
| notificationsViewer.ts | `src/vs/workbench/browser/parts/notifications/notificationsViewer.ts` | ソース | リストレンダラー |
| notificationsActions.ts | `src/vs/workbench/browser/parts/notifications/notificationsActions.ts` | ソース | アクション定義 |
| notificationsCommands.ts | `src/vs/workbench/browser/parts/notifications/notificationsCommands.ts` | ソース | コマンド定義 |
| notifications.ts | `src/vs/workbench/common/notifications.ts` | ソース | データモデル |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | プラットフォームサービス |
| contextkeys.ts | `src/vs/workbench/common/contextkeys.ts` | ソース | NotificationsCenterVisibleContext定義 |
| notificationsCenter.css | `src/vs/workbench/browser/parts/notifications/media/notificationsCenter.css` | スタイル | スタイルシート |
| notificationsActions.css | `src/vs/workbench/browser/parts/notifications/media/notificationsActions.css` | スタイル | アクションスタイル |
