# 画面設計書 46-ダイアログ

## 概要

本ドキュメントは、VSCodeのダイアログ画面の設計を記載したものです。ダイアログは、ユーザーに確認、入力、選択などを求めるモーダルウィンドウです。

### 本画面の処理概要

ダイアログは、Visual Studio Codeにおいてユーザーとの重要なやり取りを行うためのモーダルUIコンポーネントです。確認ダイアログ、入力ダイアログ、プロンプトダイアログなど複数の種類があり、処理の続行に必要な情報をユーザーから取得します。

**業務上の目的・背景**：
アプリケーションの操作において、破壊的な操作（ファイル削除、上書き保存など）や重要な決定（拡張機能のインストール、設定変更など）を行う前に、ユーザーの明示的な同意を得る必要があります。ダイアログは、このような場面でユーザーに選択肢を提示し、適切な判断を促すためのインターフェースを提供します。

**画面へのアクセス方法**：
- システムやアプリケーションから自動的に表示
- `dialogService.confirm()`, `dialogService.input()`, `dialogService.prompt()` のAPI呼び出し
- ファイル操作、設定変更などのトリガーアクション

**主要な操作・処理内容**：
1. 確認ダイアログ（confirm）：はい/いいえの選択
2. 入力ダイアログ（input）：テキスト入力の取得
3. プロンプトダイアログ（prompt）：カスタムボタンによる選択
4. Aboutダイアログ：アプリケーション情報の表示
5. チェックボックス：追加オプションの選択

**画面遷移**：
- トリガーアクション → ダイアログ表示 → ユーザー選択 → 元の画面に戻る
- ダイアログ外クリック（許可時）→ ダイアログを閉じる

**権限による表示制御**：
- 全てのユーザーがアクセス可能
- 一部のダイアログは特定の操作権限が必要

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 53 | ダイアログ | 主機能 | 確認・入力・選択ダイアログ |

## 画面種別

モーダル

## URL/ルーティング

API: `IDialogService` インターフェース

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| message | 入力 | string | Yes | ダイアログのメインメッセージ |
| detail | 入力 | string | No | 詳細説明テキスト |
| type | 入力 | DialogType | No | ダイアログの種類（info/warning/error/question） |
| buttons | 入力 | string[] | No | ボタンラベルの配列 |
| checkbox | 入力 | ICheckbox | No | チェックボックスの設定 |
| inputs | 入力 | IInputElement[] | No | 入力フィールドの設定 |
| custom | 入力 | ICustomDialogOptions | No | カスタム表示オプション |
| button | 出力 | number | Yes | 選択されたボタンのインデックス |
| checkboxChecked | 出力 | boolean | No | チェックボックスの状態 |
| values | 出力 | string[] | No | 入力フィールドの値 |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| アイコン | 左側 | 重大度に応じたアイコン（Info/Warning/Error/Question） |
| メッセージ | 中央上部 | メインメッセージテキスト |
| 詳細 | メッセージ下 | 詳細説明（存在する場合） |
| 入力フィールド | 中央 | テキスト入力欄（inputダイアログ時） |
| チェックボックス | 下部 | オプション選択用 |
| ボタン | 下部右 | アクションボタン群 |

## イベント仕様

### 1-確認ダイアログ表示

`dialogService.confirm()` が呼び出されると：
1. `BrowserDialogHandler.confirm()` が実行
2. `getConfirmationButtons()` でボタン配列を構築
3. `doShow()` でダイアログを表示
4. ユーザーが選択するまで待機
5. `{ confirmed: boolean, checkboxChecked?: boolean }` を返却

### 2-入力ダイアログ表示

`dialogService.input()` が呼び出されると：
1. `BrowserDialogHandler.input()` が実行
2. `getInputButtons()` でボタン配列を構築
3. `doShow()` で入力フィールド付きダイアログを表示
4. ユーザーが入力・選択するまで待機
5. `{ confirmed: boolean, checkboxChecked?: boolean, values: string[] }` を返却

### 3-プロンプトダイアログ表示

`dialogService.prompt()` が呼び出されると：
1. `BrowserDialogHandler.prompt()` が実行
2. `getPromptButtons()` でボタン配列を構築
3. `doShow()` でダイアログを表示
4. ユーザーが選択するまで待機
5. `getPromptResult()` で結果を変換して返却

### 4-Aboutダイアログ表示

`dialogService.about()` が呼び出されると：
1. `BrowserDialogHandler.about()` が実行
2. タイトル、詳細、コピー詳細を引数として受け取る
3. 「Copy」「OK」ボタン付きダイアログを表示
4. Copyボタン選択時は `clipboardService.writeText()` でコピー

### 5-ダイアログ閉じる

ボタンクリックまたはEscapeで：
1. 選択されたボタンのインデックスを記録
2. チェックボックスの状態を記録
3. 入力値を記録（inputダイアログ時）
4. Dialogインスタンスを破棄
5. 結果をPromiseで返却

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | - | - | ダイアログ自体はデータを永続化しない |

※ダイアログの結果に基づく操作は呼び出し元で処理される

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| copy | ボタン | "&&Copy" | Aboutダイアログ |
| ok | ボタン | "OK" | 汎用確認 |
| cancel | ボタン | "Cancel" | キャンセル時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| 不正なボタンインデックス | デフォルト値を使用 | なし |
| 入力バリデーションエラー | 入力フィールドにエラー表示 | バリデーションメッセージ |

## 備考

- `BrowserDialogHandler` がブラウザ環境でのダイアログ処理を担当
- `AbstractDialogHandler` を継承し、プラットフォーム共通のロジックを利用
- `ALLOWABLE_COMMANDS` でダイアログ内で許可されるコマンドを制限（copy, cut, selectAll, paste）
- `Dialog` クラス（base/browser/ui/dialog）がDOM構築とイベント処理を担当
- `createWorkbenchDialogOptions()` でワークベンチ固有のオプションを構築
- Markdownレンダリングをサポート（`markdownRendererService`）
- カスタムダイアログでは `renderBody` コールバックで任意のコンテンツを描画可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ダイアログで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | IConfirmation, IInput, IPrompt, IDialogService |
| 1-2 | dialog.ts | `src/vs/base/browser/ui/dialog/dialog.ts` | IDialogOptions, IDialogResult |

**読解のコツ**: 各ダイアログタイプ（confirm/input/prompt）の入出力インターフェースを把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるハンドラークラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | dialogHandler.ts | `src/vs/workbench/browser/parts/dialogs/dialogHandler.ts` | BrowserDialogHandlerクラス |

**主要処理フロー**:
1. **L20-41**: コンストラクタで依存サービスを注入
2. **L43-51**: prompt()でプロンプトダイアログを処理
3. **L53-61**: confirm()で確認ダイアログを処理
4. **L63-71**: input()で入力ダイアログを処理
5. **L73-89**: about()でAboutダイアログを処理
6. **L91-131**: doShow()で実際のダイアログ表示処理

#### Step 3: 基底クラスを理解する

共通ロジックを提供する抽象クラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | AbstractDialogHandler |

**主要処理フロー**:
- getPromptButtons(): プロンプトダイアログのボタン配列を構築
- getConfirmationButtons(): 確認ダイアログのボタン配列を構築
- getInputButtons(): 入力ダイアログのボタン配列を構築
- getPromptResult(): プロンプト結果を変換

#### Step 4: UIコンポーネントを理解する

実際のダイアログUIを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | dialog.ts | `src/vs/base/browser/ui/dialog/dialog.ts` | Dialogクラス |

### プログラム呼び出し階層図

```
IDialogService
    │
    └─ BrowserDialogHandler
           │
           ├─ prompt()
           │      ├─ getPromptButtons()
           │      ├─ doShow()
           │      └─ getPromptResult()
           │
           ├─ confirm()
           │      ├─ getConfirmationButtons()
           │      └─ doShow()
           │
           ├─ input()
           │      ├─ getInputButtons()
           │      └─ doShow()
           │
           ├─ about()
           │      ├─ doShow()
           │      └─ clipboardService.writeText()
           │
           └─ doShow()
                  ├─ renderBody() [カスタム時]
                  │      └─ markdownRendererService.render()
                  │
                  └─ Dialog
                         ├─ createWorkbenchDialogOptions()
                         └─ show()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

IConfirmation          ───▶ BrowserDialogHandler       ───▶ IConfirmationResult
  └─ message                 │                                └─ confirmed
  └─ detail                  ├─ getConfirmationButtons()      └─ checkboxChecked
  └─ checkbox                │
                             └─ doShow()
                                    └─ Dialog.show()

IInput                 ───▶ BrowserDialogHandler       ───▶ IInputResult
  └─ message                 │                                └─ confirmed
  └─ inputs                  ├─ getInputButtons()             └─ values
                             │
                             └─ doShow()

IPrompt<T>             ───▶ BrowserDialogHandler       ───▶ IAsyncPromptResult<T>
  └─ message                 │                                └─ result
  └─ buttons                 ├─ getPromptButtons()
                             │
                             └─ doShow()
                             └─ getPromptResult()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| dialogHandler.ts | `src/vs/workbench/browser/parts/dialogs/dialogHandler.ts` | ソース | ブラウザ用ダイアログハンドラー |
| dialogs.ts | `src/vs/platform/dialogs/common/dialogs.ts` | ソース | ダイアログインターフェース・抽象クラス |
| dialog.ts | `src/vs/base/browser/ui/dialog/dialog.ts` | ソース | ダイアログUIコンポーネント |
| dialog.ts | `src/vs/platform/dialogs/browser/dialog.ts` | ソース | ワークベンチダイアログオプション |
| dialogService.ts | `src/vs/workbench/services/dialogs/browser/dialogService.ts` | ソース | ダイアログサービス実装 |
| dialog.css | `src/vs/base/browser/ui/dialog/dialog.css` | スタイル | ダイアログスタイルシート |
