# 画面設計書 48-クイックオープン

## 概要

本ドキュメントは、VSCodeのクイックオープン画面の設計を記載したものです。クイックオープンは、ファイル、シンボル、コマンドなどを素早く検索・アクセスできる統合的なクイックアクセスインターフェースです。

### 本画面の処理概要

クイックオープンは、Visual Studio Codeにおける統合的なクイックアクセスシステムのエントリーポイントです。入力されたプレフィックスに応じて、ファイル検索、シンボル検索、コマンドパレット、ビュー切り替えなど、様々なプロバイダーに処理を委譲します。

**業務上の目的・背景**：
大規模なプロジェクトでは、ファイルエクスプローラーを辿ってファイルを開くのは非効率です。クイックオープンは、ファイル名の一部を入力するだけで素早くファイルにアクセスでき、開発者の生産性を大幅に向上させます。また、プレフィックスにより様々な検索モードに切り替えられる柔軟性も提供します。

**画面へのアクセス方法**：
- キーボードショートカット `Ctrl+P`（Windows/Linux）または `Cmd+P`（macOS）
- メニュー「ファイル」→「ファイルを開く...」
- コマンドパレットから「Go to File...」

**主要な操作・処理内容**：
1. ファイル検索：ワークスペース内のファイルをファジー検索
2. プレフィックス切り替え：`>`でコマンド、`#`でシンボル、`@`でエディタシンボルなど
3. ファイルを開く：検索結果からファイルを開く
4. サイドで開く：Alt+Enter でサイドエディタで開く
5. プレビュー：上下キーで選択変更時にプレビュー表示
6. 最近開いたファイル：空入力時に最近のファイルを表示

**画面遷移**：
- ショートカット → クイックオープン（オーバーレイ）
- ファイル選択 → エディタでファイルを開く
- プレフィックス入力 → 対応するクイックアクセスプロバイダーに切り替え

**権限による表示制御**：
- 全てのユーザーがアクセス可能
- ワークスペースが開いていない場合は機能が制限

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | クイックオープン | 主機能 | ファイル・シンボル・コマンド検索 |
| 47 | コマンドパレット | 補助機能 | `>` プレフィックスで切り替え |
| 49 | シンボル検索 | 補助機能 | `#` プレフィックスで切り替え |

## 画面種別

クイックピック（オーバーレイ）

## URL/ルーティング

プレフィックス: なし（デフォルトファイル検索）
サービス: `IQuickInputService.quickAccess`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| 検索クエリ | 入力 | string | No | ファイル名/パスの検索文字列 |
| プレフィックス | 入力 | string | No | 検索モード切替（>, #, @, :等） |
| ファイル一覧 | 出力 | IFileQuickPickItem[] | Yes | 検索結果のファイルリスト |
| 選択ファイル | 出力 | URI | Yes | 開くファイルのURI |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| 検索入力欄 | 上部 | 検索テキスト/プレフィックス入力 |
| プレースホルダー | 入力欄 | "Search files by name" 等のヒント |
| ファイルアイコン | 行左 | ファイルタイプに応じたアイコン |
| ファイル名 | 行中央 | ファイル名（ハイライト付き） |
| ファイルパス | ファイル名右 | 相対パス（グレー表示） |
| 開くボタン | 行右端 | サイドで開くボタン |
| ヘルプ | 下部 | プレフィックス一覧（?入力時） |

## イベント仕様

### 1-クイックオープン起動

`Ctrl+P` を押すと：
1. `quickInputService.quickAccess.show()` が呼び出される
2. プレフィックスなしでクイックアクセスを開く
3. デフォルトのファイル検索プロバイダーがアクティブに
4. 空入力時は最近開いたファイルを表示

### 2-ファイル検索

検索テキストを入力すると：
1. 入力テキストでファイルをファジーフィルタリング
2. `IFileSearchService` でワークスペース内を検索
3. ファジースコアリングで関連度を計算
4. 最近開いたファイルを優先してソート
5. 結果を非同期で更新表示

### 3-ファイルを開く

ファイルを選択（Enter）すると：
1. `accept()` コールバックが実行される
2. `editorService.openEditor()` でファイルを開く
3. 設定に応じてプレビューまたは固定タブで開く
4. クイックピックを閉じる

### 4-サイドで開く

Alt+Enter またはサイドボタンをクリックすると：
1. ファイルをサイドエディタグループで開く
2. `SIDE_GROUP` オプションを指定
3. 元のエディタは維持

### 5-プレフィックス切り替え

プレフィックス（例: `>`）を入力すると：
1. 該当するクイックアクセスプロバイダーに切り替え
2. プレースホルダーとアイコンが変更
3. 新しいプロバイダーの検索結果を表示

### 6-ヘルプ表示

`?` を入力すると：
1. `HelpQuickAccessProvider` がアクティブに
2. 利用可能なプレフィックス一覧を表示
3. 各プレフィックスの説明とコマンドを表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ファイルを開く | Storage (workspace) | UPDATE | 最近開いたファイル履歴 |
| 検索実行 | Storage (workspace) | UPDATE | 検索履歴（設定による） |

### テーブル別更新項目詳細

#### Storage (workspace)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | quickOpen.recentFiles | 最近開いたファイルのリスト | MRU |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| helpQuickAccessPlaceholder | プレースホルダー | "Type '{0}' to get help..." | ヘルプ表示 |
| helpQuickAccess | 説明 | "Show all Quick Access Providers" | ヘルプ一覧 |
| viewQuickAccessPlaceholder | プレースホルダー | "Type the name of a view..." | ビュー検索 |
| viewQuickAccess | 説明 | "Open View" | ビュー検索 |
| commandsQuickAccessPlaceholder | プレースホルダー | "Type the name of a command..." | コマンド検索 |
| gotoLine | 説明 | "Go to Line/Column..." | 行ジャンプ |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| ワークスペース未オープン | 最近のファイルのみ表示 | なし |
| 検索タイムアウト | 部分結果を表示 | なし |
| ファイルが見つからない | エラー通知 | "File not found" |

## 備考

- `HelpQuickAccessProvider` がデフォルトの `?` プレフィックスを処理
- `ViewQuickAccessProvider` が `view ` プレフィックスを処理
- 設定 `workbench.editor.enablePreviewFromQuickOpen` でプレビュー動作を制御
- 設定 `workbench.editor.openSideBySideDirection` でサイド表示の方向を制御
- `quickAccessNavigateNext/Previous` でキーボードナビゲーション
- `inQuickPickContext` コンテキストキーでクイックピック表示中を判定

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クイックオープンで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | quickAccess.ts | `src/vs/platform/quickinput/common/quickAccess.ts` | IQuickAccessProvider, IQuickAccessRegistry |
| 1-2 | quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | IQuickInputService, IQuickPickItem |

**読解のコツ**: プロバイダーの登録と切り替えメカニズム、プレフィックスの役割を把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるサービスとコントリビューションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | quickaccess.ts | `src/vs/workbench/browser/quickaccess.ts` | getQuickNavigateHandler, inQuickPickContext |
| 2-2 | quickAccess.contribution.ts | `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts` | プロバイダー登録 |

**主要処理フロー**:
1. **L21-32**: HelpQuickAccessProviderを登録（`?` プレフィックス）
2. **L34-40**: ViewQuickAccessProviderを登録（`view ` プレフィックス）
3. **L42-48**: CommandsQuickAccessProviderを登録（`>` プレフィックス）

#### Step 3: ビュープロバイダーを理解する

ビュー切り替えのプロバイダーを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | viewQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/viewQuickAccess.ts` | ViewQuickAccessProvider, OpenViewPickerAction |

#### Step 4: ナビゲーションを理解する

クイックピック内のキーボードナビゲーションを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | quickAccess.contribution.ts | `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts` | quickAccessNavigateNext/Previous |

**主要処理フロー**:
- **L120-133**: quickAccessNavigateNextInViewPickerIdを登録
- **L135-146**: quickAccessNavigatePreviousInViewPickerIdを登録

### プログラム呼び出し階層図

```
Ctrl+P
    │
    └─ quickInputService.quickAccess.show()
           │
           └─ QuickAccessController
                  │
                  ├─ プレフィックスなし
                  │      └─ ファイル検索プロバイダー
                  │             └─ IFileSearchService
                  │
                  ├─ プレフィックス "?"
                  │      └─ HelpQuickAccessProvider
                  │             └─ プロバイダー一覧表示
                  │
                  ├─ プレフィックス ">"
                  │      └─ CommandsQuickAccessProvider
                  │             └─ コマンド検索
                  │
                  ├─ プレフィックス "#"
                  │      └─ SymbolsQuickAccessProvider
                  │             └─ ワークスペースシンボル検索
                  │
                  ├─ プレフィックス "@"
                  │      └─ EditorSymbolsQuickAccessProvider
                  │             └─ エディタシンボル検索
                  │
                  ├─ プレフィックス ":"
                  │      └─ GotoLineQuickAccessProvider
                  │             └─ 行ジャンプ
                  │
                  └─ accept()
                         └─ editorService.openEditor()
```

### データフロー図

```
[入力]                       [処理]                           [出力]

Ctrl+P                 ───▶ QuickAccessController       ───▶ クイックピック表示
                             │
検索クエリ             ───▶ ├─ プレフィックス判定
                             │      └─ プロバイダー選択
                             │
IQuickAccessRegistry   ───▶ ├─ プロバイダー取得
  └─ providers               │
                             │
ファイルシステム       ───▶ └─ 検索実行
  └─ ワークスペースファイル        └─ ファジーマッチ
                                   └─ 結果ソート
                                   └─ 表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| quickaccess.ts | `src/vs/workbench/browser/quickaccess.ts` | ソース | ワークベンチ設定・ユーティリティ |
| quickAccess.contribution.ts | `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts` | ソース | プロバイダー登録 |
| viewQuickAccess.ts | `src/vs/workbench/contrib/quickaccess/browser/viewQuickAccess.ts` | ソース | ビュープロバイダー |
| helpQuickAccess.ts | `src/vs/platform/quickinput/browser/helpQuickAccess.ts` | ソース | ヘルププロバイダー |
| quickAccess.ts | `src/vs/platform/quickinput/common/quickAccess.ts` | ソース | プラットフォームインターフェース |
| quickInput.ts | `src/vs/platform/quickinput/common/quickInput.ts` | ソース | クイック入力サービス |
| quickInputService.ts | `src/vs/platform/quickinput/browser/quickInputService.ts` | ソース | サービス実装 |
