# 画面設計書: パネル

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 5 |
| 画面名 | パネル |
| 画面パス | `src/vs/workbench/browser/parts/panel/panelPart.ts` |
| 概要 | ワークベンチの下部、左側、または右側に配置されるパネル領域。ターミナル、出力、問題、デバッグコンソールなどの補助的な機能を表示する |

## 2. 画面構成

### 2.1 レイアウト概要

```
+-------------------------------------------------------------------+
| [タブバー: ターミナル | 出力 | 問題 | デバッグコンソール] [アクション] |
+-------------------------------------------------------------------+
|                                                                   |
|                        パネルコンテンツ                            |
|                    (ターミナル、出力等)                            |
|                                                                   |
+-------------------------------------------------------------------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| titleArea | タイトル/タブエリア | はい | 常時 |
| compositeBar | パネルタブバー | はい | 常時 |
| titleActionsContainer | アクションボタンエリア | はい | 常時 |
| content | コンテンツエリア | はい | 常時 |
| paneComposite | パネルコンテンツの実体 | はい | 常時 |

## 3. 機能仕様

### 3.1 パネルコンテナ管理

- **PanelPart**: パネル全体の管理
- **タブ形式**: 複数パネルをタブで切り替え
- **単一表示**: 一度に1つのパネルのみ表示

### 3.2 組み込みパネル

| パネルID | 名前 | 説明 |
|----------|------|------|
| `terminal` | ターミナル | 統合ターミナル |
| `workbench.panel.output` | 出力 | 拡張機能等の出力 |
| `workbench.panel.markers` | 問題 | エラー/警告一覧 |
| `workbench.panel.repl` | デバッグコンソール | デバッグ出力 |
| `workbench.panel.comments` | コメント | コードレビューコメント |

### 3.3 配置位置

| 位置 | 説明 |
|------|------|
| bottom | ワークベンチ下部（デフォルト） |
| left | ワークベンチ左側 |
| right | ワークベンチ右側 |

### 3.4 配置モード（アラインメント）

| モード | 説明 |
|--------|------|
| center | エディタエリアに対して中央揃え |
| left | 左寄せ |
| right | 右寄せ |
| justify | 両端揃え（フル幅） |

### 3.5 最大化機能

- **最大化モード**: パネルを画面いっぱいに拡大
- **エディタ領域の非表示**: 最大化時にエディタを隠す
- **トグル操作**: ダブルクリックまたはコマンドで切り替え

## 4. データフロー

```
[ユーザー操作: パネルタブクリック]
         |
         v
[PaneCompositeService.openPaneComposite(ViewContainerLocation.Panel)]
         |
         v
[PanelPart.openComposite()]
         |
         v
[パネルコンテンツの表示]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidPaneCompositeOpen | パネルが開いた | コンテンツの表示処理 |
| onDidPaneCompositeClose | パネルが閉じた | コンテンツの非表示処理 |
| onDidChangeVisibility | 表示状態変更 | レイアウト更新 |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.panel.defaultLocation` | パネルのデフォルト位置 | `bottom` |
| `workbench.panel.opensMaximized` | 最大化で開くか | `preserve` |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `panelPart.ts` の `PanelPart` クラス
2. **基底クラス**: `AbstractPaneCompositePart` を継承
3. **位置管理**: `Position` enum と `PanelAlignment` enum

### 7.2 プログラム呼び出し階層図

```
PanelPart
  |
  +-- AbstractPaneCompositePart (extends)
  |     |
  |     +-- openComposite()
  |     +-- hideActiveComposite()
  |     |
  |     +-- PaneCompositeBar
  |           +-- タブバー機能
  |
  +-- ViewContainerModel
  |     +-- パネルの管理
  |
  +-- PaneComposite (children)
        +-- ターミナル、出力等
```

### 7.3 データフロー図

```
[パネルタブクリック / コマンド実行]
         |
         v
[PaneCompositePartService.openPaneComposite]
         |
         v
[PanelPart.openComposite]
         |
         v
[PaneComposite.setVisible(true)]
         |
         v
[パネルコンテンツのrender()]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/parts/panel/panelPart.ts` | パネルパーツ本体 |
| `src/vs/workbench/browser/parts/paneCompositePart.ts` | 基底クラス |
| `src/vs/workbench/browser/panecomposite.ts` | コンポジット基底 |
| `src/vs/workbench/contrib/terminal/browser/terminalView.ts` | ターミナルパネル |
| `src/vs/workbench/contrib/output/browser/outputView.ts` | 出力パネル |
| `src/vs/workbench/contrib/markers/browser/markersView.ts` | 問題パネル |

### 7.5 重要なコードスニペット

**PanelPartクラスの構造（panelPart.ts）**
```typescript
export class PanelPart extends AbstractPaneCompositePart {
  static readonly activePanelSettingsKey = 'workbench.panelpart.activepanelid';

  // サイズ制約（位置によって変動）
  get minimumWidth(): number {
    return this.layoutService.getPanelPosition() === Position.BOTTOM ? 0 : 300;
  }
  get minimumHeight(): number {
    return this.layoutService.getPanelPosition() === Position.BOTTOM ? 77 : 0;
  }

  constructor(
    @INotificationService notificationService: INotificationService,
    @IStorageService storageService: IStorageService,
    // ... 他の依存関係
  ) {
    super(
      Parts.PANEL_PART,
      { hasTitle: true, borderWidth: () => ... },
      // ...
    );
  }
}
```

**位置に応じたサイズ制約**
```typescript
get minimumWidth(): number {
  // 下部配置時は幅制約なし、左右配置時は最小幅300
  return this.layoutService.getPanelPosition() === Position.BOTTOM ? 0 : 300;
}

get minimumHeight(): number {
  // 下部配置時は最小高さ77、左右配置時は高さ制約なし
  return this.layoutService.getPanelPosition() === Position.BOTTOM ? 77 : 0;
}
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| パネルタブ | タブクリック | パネル切り替え |
| コマンドパレット | コマンド実行 | パネル表示/非表示 |
| キーボードショートカット | Ctrl+`等 | ターミナルへ直接遷移 |
| ステータスバー | エラークリック | 問題パネルへ遷移 |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| エディタ | エラー箇所クリック | 問題パネルからエディタへ |
| ターミナル | コマンド実行 | ターミナル出力確認 |

## 9. スタイリング

### 9.1 テーマカラー

| カラーID | 説明 |
|----------|------|
| `panel.background` | 背景色 |
| `panel.border` | ボーダー色 |
| `panelTitle.activeBorder` | アクティブタブのボーダー |
| `panelTitle.activeForeground` | アクティブタブの前景色 |
| `panelTitle.inactiveForeground` | 非アクティブタブの前景色 |
| `panelInput.border` | 入力フィールドのボーダー |

### 9.2 CSSクラス

| クラス名 | 説明 |
|----------|------|
| `.part.panel` | パネルコンテナ |
| `.composite.title` | タイトルエリア |
| `.panel-switcher-container` | タブバーコンテナ |
| `.content` | コンテンツエリア |

## 10. 最大化動作

| 状態 | 動作 |
|------|------|
| 通常表示 | エディタと共存 |
| 最大化 | エディタを隠してフル表示 |
| 復元 | 元のサイズに戻る |

## 11. アクセシビリティ

- **キーボードナビゲーション**: Tab/矢印キーでタブ間移動
- **フォーカス管理**: `workbench.action.focusPanel`コマンド
- **ARIAロール**: tablist, tab, tabpanelの適切な設定
- **スクリーンリーダー**: パネル名とコンテンツの読み上げ

## 12. 拡張ポイント

### 12.1 カスタムパネル

拡張機能から`contributes.viewsContainers`でカスタムパネルを追加可能

```json
{
  "contributes": {
    "viewsContainers": {
      "panel": [
        {
          "id": "myCustomPanel",
          "title": "My Panel",
          "icon": "$(symbol-misc)"
        }
      ]
    }
  }
}
```
