# 画面設計書 50-ウェルカムバナー

## 概要

本ドキュメントは、VSCodeのウェルカムバナー画面の設計を記載したものです。ウェルカムバナーは、アプリケーション起動時やセッション開始時にユーザーへメッセージを表示するバナーコンポーネントです。

### 本画面の処理概要

ウェルカムバナーは、Visual Studio Codeのワークベンチ上部に表示される情報バナーです。主にブラウザ版（vscode.dev、github.dev）やカスタムデプロイメント環境で、ユーザーへの案内メッセージやアクションを提示するために使用されます。

**業務上の目的・背景**：
ウェルカムバナーは、ホスト環境（vscode.dev等）がユーザーに重要な情報を伝えるための標準的な手段を提供します。新機能の紹介、使用条件の通知、セッション情報の表示など、様々なユースケースに対応します。ユーザーが一度閉じたバナーは再表示されないよう、状態が永続化されます。

**画面へのアクセス方法**：
- ホスト環境の設定（`environmentService.options.welcomeBanner`）により自動表示
- プログラムによる `IBannerService.show()` の呼び出し

**主要な操作・処理内容**：
1. バナー表示：ワークベンチ上部にメッセージとアクションを表示
2. アクション実行：バナー内のボタンをクリックしてアクションを実行
3. バナーを閉じる：閉じるボタンで非表示にし、状態を永続化
4. アイコン表示：メッセージに応じたカスタムアイコンを表示

**画面遷移**：
- アプリケーション起動 → バナー表示（条件付き）
- アクションボタンクリック → 指定されたアクションを実行
- 閉じるボタン → バナー非表示、以降表示しない

**権限による表示制御**：
- 全てのユーザーに表示可能
- 既に閉じた場合は再表示されない（ストレージに記録）

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 50 | ウェルカムバナー | 主機能 | 情報バナーの表示 |

## 画面種別

バナー（インフォメーション）

## URL/ルーティング

バナーID: `welcome.banner`
ストレージキー: `workbench.banner.welcome.dismissed`

## 入出力項目

| 項目名 | 入力/出力 | 型 | 必須 | 説明 |
|--------|----------|-----|------|------|
| message | 入力 | string | Yes | バナーに表示するメッセージ |
| icon | 入力 | string \| URI | No | アイコン（ThemeIconまたはURI） |
| actions | 入力 | IAction[] | No | バナーに表示するアクションボタン |
| dismissed | 出力 | boolean | - | バナーが閉じられたかどうか |

## 表示項目

| 項目名 | 表示位置 | 説明 |
|--------|----------|------|
| アイコン | 左端 | ThemeIconまたはカスタム画像 |
| メッセージ | 中央 | バナーのメインテキスト |
| アクションボタン | メッセージ右 | 操作可能なアクションボタン群 |
| 閉じるボタン | 右端 | バナーを閉じる×ボタン |

## イベント仕様

### 1-バナー表示

ワークベンチ起動時に：
1. `WelcomeBannerContribution` がインスタンス化される
2. `environmentService.options.welcomeBanner` を確認
3. welcomeBannerが未定義の場合は処理終了
4. `storageService.getBoolean()` で既に閉じているか確認
5. 閉じていなければ `bannerService.show()` でバナーを表示

### 2-アイコン処理

アイコンの設定に応じて：
1. アイコンが文字列の場合は `ThemeIcon.fromId()` でThemeIconに変換
2. アイコンがオブジェクトの場合は `URI.revive()` でURIに変換
3. アイコンが未定義の場合はデフォルトアイコン

### 3-バナーを閉じる

閉じるボタンをクリックすると：
1. `onClose` コールバックが実行される
2. `storageService.store()` でdismissed状態を保存
3. `StorageScope.PROFILE` と `StorageTarget.MACHINE` で永続化
4. バナーUIが非表示になる

### 4-アクション実行

アクションボタンをクリックすると：
1. 対応する `IAction.run()` が実行される
2. アクション内容はホスト環境が定義

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| バナーを閉じる | Storage (profile) | INSERT/UPDATE | dismissed状態の保存 |

### テーブル別更新項目詳細

#### Storage (profile)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | workbench.banner.welcome.dismissed | true | バナーを閉じた際 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| (動的) | バナー | ホスト環境設定による | welcomeBanner設定時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|-------------|---------|---------------|
| welcomeBanner未定義 | 処理終了（バナー非表示） | なし |
| アイコン変換失敗 | デフォルトアイコンを使用 | なし |

## 備考

- `WelcomeBannerContribution` がワークベンチコントリビューションとして登録
- `LifecyclePhase.Restored` フェーズで初期化
- `IBrowserWorkbenchEnvironmentService` からオプションを取得
- `IBannerService` がバナーの表示/非表示を管理
- `StorageScope.PROFILE` でユーザープロファイルに状態を保存
- `StorageTarget.MACHINE` でマシン固有の状態として保存
- バナーIDは `welcome.banner` 固定
- ストレージキーは `workbench.banner.welcome.dismissed`

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ウェルカムバナーで扱う主要なデータ構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bannerService.ts | `src/vs/workbench/services/banner/browser/bannerService.ts` | IBannerService, IBannerItem |
| 1-2 | environmentService.ts | `src/vs/workbench/services/environment/browser/environmentService.ts` | welcomeBannerオプション |

**読解のコツ**: バナーアイテムの構造（id, message, icon, actions, onClose）を把握してください。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントリビューションクラスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | welcomeBanner.contribution.ts | `src/vs/workbench/contrib/welcomeBanner/browser/welcomeBanner.contribution.ts` | WelcomeBannerContributionクラス |

**主要処理フロー**:
1. **L15-17**: WELCOME_BANNER_DISMISSED_KEYの定義
2. **L19-23**: コンストラクタで依存サービスを注入
3. **L24-27**: welcomeBannerオプションの取得とチェック
4. **L29-31**: storageService.getBoolean()でdismissed状態をチェック
5. **L33-38**: アイコンの変換処理
6. **L40-48**: bannerService.show()でバナーを表示
7. **L45-47**: onCloseでdismissed状態を保存

#### Step 3: バナーサービスを理解する

バナーの表示/管理サービスを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bannerService.ts | `src/vs/workbench/services/banner/browser/bannerService.ts` | IBannerServiceインターフェース |
| 3-2 | banner.ts | `src/vs/workbench/browser/parts/banner/banner.ts` | BannerPart実装 |

#### Step 4: 登録を理解する

コントリビューションの登録を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | welcomeBanner.contribution.ts | `src/vs/workbench/contrib/welcomeBanner/browser/welcomeBanner.contribution.ts` | Registry登録（L52-53） |

**主要処理フロー**:
- **L52-53**: `Registry.as<IWorkbenchContributionsRegistry>().registerWorkbenchContribution()`で登録
- `LifecyclePhase.Restored`フェーズで初期化

### プログラム呼び出し階層図

```
ワークベンチ起動
    │
    └─ LifecyclePhase.Restored
           │
           └─ WelcomeBannerContribution
                  │
                  ├─ environmentService.options.welcomeBanner
                  │      └─ 未定義 → 処理終了
                  │
                  ├─ storageService.getBoolean(DISMISSED_KEY)
                  │      └─ true → 処理終了
                  │
                  ├─ アイコン変換
                  │      ├─ string → ThemeIcon.fromId()
                  │      └─ object → URI.revive()
                  │
                  └─ bannerService.show()
                         ├─ id: 'welcome.banner'
                         ├─ message: welcomeBanner.message
                         ├─ icon: 変換済みアイコン
                         ├─ actions: welcomeBanner.actions
                         └─ onClose:
                                └─ storageService.store(DISMISSED_KEY, true)
```

### データフロー図

```
[入力]                       [処理]                           [出力]

IBrowserWorkbench      ───▶ WelcomeBannerContribution  ───▶ バナー表示
EnvironmentService           │
  └─ welcomeBanner           ├─ オプション取得
                             │
IStorageService        ───▶ ├─ dismissed状態確認
  └─ DISMISSED_KEY           │      └─ true → 処理終了
                             │
ThemeIcon / URI        ───▶ ├─ アイコン変換
                             │
IBannerService         ───▶ └─ show()
                                   │
                                   └─ onClose
                                          └─ storageService.store()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| welcomeBanner.contribution.ts | `src/vs/workbench/contrib/welcomeBanner/browser/welcomeBanner.contribution.ts` | ソース | メインコントリビューション |
| bannerService.ts | `src/vs/workbench/services/banner/browser/bannerService.ts` | ソース | バナーサービスインターフェース |
| banner.ts | `src/vs/workbench/browser/parts/banner/banner.ts` | ソース | バナーUI実装 |
| environmentService.ts | `src/vs/workbench/services/environment/browser/environmentService.ts` | ソース | 環境オプション |
| storage.ts | `src/vs/platform/storage/common/storage.ts` | ソース | ストレージサービス |
| themables.ts | `src/vs/base/common/themables.ts` | ソース | ThemeIcon |
| uri.ts | `src/vs/base/common/uri.ts` | ソース | URI |
