# 画面設計書 51-ウォークスルー

## 概要

本ドキュメントは、VSCodeのウォークスルー（Interactive Editor Playground）画面の設計仕様を記載する。この画面は、ユーザーがVSCodeエディタの機能を対話的に学習するためのインタラクティブチュートリアル画面である。

### 本画面の処理概要

ウォークスルー画面は、VSCodeの新規ユーザーや機能を学びたいユーザーに向けた教育用コンテンツを提供する画面である。Markdownベースのコンテンツと実際に操作可能なコードスニペットを組み合わせることで、ハンズオン形式での学習体験を実現する。

**業務上の目的・背景**：VSCodeは多機能なエディタであり、新規ユーザーが全ての機能を効率的に習得することは困難である。ウォークスルー画面は、主要な編集機能（マルチカーソル、IntelliSense、コードスニペット、Emmetなど）を実際に試しながら学べる環境を提供することで、ユーザーの習熟度向上と製品の定着率向上を目的としている。

**画面へのアクセス方法**：以下の方法でアクセス可能である。
- メニューバー: ヘルプ → Editor Playground
- コマンドパレット: `workbench.action.showInteractivePlayground` コマンドを実行
- コマンドパレットで「Interactive Editor Playground」を検索

**主要な操作・処理内容**：
1. Markdownコンテンツの表示とナビゲーション（スクロール、アンカーリンクによるジャンプ）
2. 埋め込みコードエディタでのコード編集と機能体験
3. キーボードショートカットの動的表示（現在のキーバインド設定を反映）
4. コマンドリンクのクリックによる機能実行（例: Git clone）

**画面遷移**：
- 遷移元: ワークベンチ全般（コマンドパレット、ヘルプメニュー、Getting Started画面）
- 遷移先: エクスプローラービュー、検索ビュー、設定エディタなど（コマンドリンク経由）

**権限による表示制御**：特別な権限制御は行わない。全ユーザーが同一の内容を閲覧・操作可能である。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | エクスプローラー | 遷移先機能 | インタラクティブチュートリアルからのナビゲーション |
| 1 | コード編集 | 主機能 | 埋め込みエディタでのコード編集体験 |
| 3 | コード補完（IntelliSense） | 補助機能 | チュートリアル内でのIntelliSense体験 |
| 7 | マルチカーソル | 補助機能 | マルチカーソル機能の学習 |
| 8 | コードスニペット | 補助機能 | スニペット機能の学習 |

## 画面種別

チュートリアル / インタラクティブ学習

## URL/ルーティング

- URI Scheme: `walkThrough:` + リソースパス
- リソース例: `walkThrough:/vs/workbench/contrib/welcomeWalkthrough/browser/editor/vs_code_editor_walkthrough.md`
- スニペット用Scheme: `walkThroughSnippet:` + リソースパス + フラグメント（スニペット番号.言語）

## 入出力項目

| 項目名 | 型 | 入力/出力 | 説明 |
|--------|-----|----------|------|
| resource | URI | 入力 | ウォークスルーコンテンツのリソースURI |
| telemetryFrom | string | 入力 | テレメトリ用の識別子 |
| onReady | callback | 入力 | コンテンツ準備完了時のコールバック |
| layout | callback | 入力 | レイアウト変更時のコールバック |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| ウォークスルータイトル | テキスト | 「Editor Playground」 |
| Markdownコンテンツ | HTML | Markdownから変換されたHTMLコンテンツ |
| キーボードショートカット | バッジ | 現在のキーバインドを反映したショートカット表示 |
| 埋め込みコードエディタ | CodeEditorWidget | 実際に操作可能なMonacoエディタ |
| コマンドリンク | ボタン/アンカー | クリックでVSCodeコマンドを実行 |

## イベント仕様

### 1-画面表示

WalkThroughPartの`setInput`メソッドが呼び出され、以下の処理が実行される。

1. コンテンツプロバイダからMarkdownまたはHTMLコンテンツを取得
2. `.md`ファイルの場合、`marked`ライブラリでHTMLに変換
3. コードブロックを検出し、各スニペットに対応するCodeEditorWidgetを生成
4. キーボードショートカットのマクロを展開（`kb(command.id)` → 実際のキーバインド）
5. スクロール位置の復元（前回の閲覧位置）

### 2-スニペットエディタの操作

埋め込みCodeEditorWidgetで以下のイベントが処理される。

- `onDidChangeModelContent`: エディタ内容変更時に高さを自動調整
- `onDidChangeCursorPosition`: カーソル位置に応じたスクロール調整
- `onDidChangeConfiguration`: エディタ設定変更の反映

### 3-リンククリック

- アンカーリンク: 同一ドキュメント内のセクションへスクロール
- 外部リンク: `IOpenerService`を通じて外部URLを開く
- コマンドリンク: `command:` スキームでVSCodeコマンドを実行

### 4-キーボードナビゲーション

| キー | アクション | コマンドID |
|-----|----------|-----------|
| ↑ | 上スクロール | workbench.action.interactivePlayground.arrowUp |
| ↓ | 下スクロール | workbench.action.interactivePlayground.arrowDown |
| PageUp | ページ上スクロール | workbench.action.interactivePlayground.pageUp |
| PageDown | ページ下スクロール | workbench.action.interactivePlayground.pageDown |

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。ただし、以下のストレージ操作が行われる。

| 操作（イベント） | 対象ストレージ | 操作種別 | 概要 |
|----------------|---------------|---------|------|
| 画面閉じる | EditorMemento | UPDATE | スクロール位置の保存 |
| 画面表示 | EditorMemento | SELECT | スクロール位置の復元 |

### テーブル別更新項目詳細

#### EditorMemento (walkThroughEditorViewState)

| 操作 | 項目（キー名） | 更新値・取得条件 | 備考 |
|-----|---------------|-----------------|------|
| UPDATE | scrollTop | 現在のスクロール位置（垂直） | ピクセル値 |
| UPDATE | scrollLeft | 現在のスクロール位置（水平） | ピクセル値 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| walkThrough.gitNotFound | 情報 | "It looks like Git is not installed on your system." | Gitがインストールされていない状態でgit.cloneコマンド実行時 |
| walkThrough.unboundCommand | ラベル | "unbound" | キーバインドが未設定のコマンド |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| コンテンツプロバイダ未登録 | エラー「Walkthrough: no provider registered for {moduleId}」をスロー |
| 無効なリソースURI | エラー「Walkthrough: invalid resource」をスロー |
| 拡張機能未ロード（.mdファイル） | 拡張機能のロード完了を待機 |

## 備考

- 本画面は`EditorPane`を継承しており、エディタタブとして表示される
- コンテンツは静的にバンドルされており、ネットワーク接続は不要
- テーマカラーは`walkThrough.embeddedEditorBackground`でカスタマイズ可能
- タッチデバイスではジェスチャーによるスクロールをサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、WalkThroughInputの構造とコンテンツモデルを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | walkThroughInput.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughInput.ts` | WalkThroughInputOptions型、WalkThroughModel内部クラスの構造を確認 |
| 1-2 | walkThroughContentProvider.ts | `src/vs/workbench/contrib/welcomeWalkthrough/common/walkThroughContentProvider.ts` | コンテンツプロバイダレジストリの仕組みを理解 |

**読解のコツ**: TypeScriptのinterfaceとclassの関係に注目。WalkThroughInputOptionsがWalkThroughInputの設定を定義している。

#### Step 2: エントリーポイントを理解する

処理の起点となるcontributionファイルとアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | walkThrough.contribution.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThrough.contribution.ts` | エディタペイン登録、アクション登録、メニュー登録を確認 |
| 2-2 | editorWalkThrough.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/editor/editorWalkThrough.ts` | EditorWalkThroughActionのrun()メソッドで画面起動処理を確認 |

**主要処理フロー**:
1. **20-26行目**: WalkThroughPartをEditorPaneDescriptorで登録
2. **28行目**: EditorWalkThroughActionをアクションとして登録
3. **42-49行目**: ヘルプメニューへの項目追加

#### Step 3: 画面コンポーネントを理解する

メインのエディタペイン実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | EditorPaneを継承したWalkThroughPartクラス |

**主要処理フロー**:
- **89-106行目**: createEditor()でスクロール可能なコンテナを生成
- **273-385行目**: setInput()でコンテンツの読み込みとエディタ生成
- **421-427行目**: expandMacros()でキーバインドマクロを展開
- **243-271行目**: スクロール操作のハンドラ

#### Step 4: ナビゲーションアクションを理解する

キーボードナビゲーションの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | walkThroughActions.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughActions.ts` | 上下スクロール、ページスクロールのキーバインド定義 |

**主要処理フロー**:
- **13-25行目**: WalkThroughArrowUpの定義とハンドラ
- **27-39行目**: WalkThroughArrowDownの定義とハンドラ

### プログラム呼び出し階層図

```
EditorWalkThroughAction.run()
    │
    ├─ IInstantiationService.createInstance(WalkThroughInput)
    │      └─ WalkThroughInputOptions設定
    │
    └─ IEditorService.openEditor(input)
           │
           └─ WalkThroughPart.setInput()
                  │
                  ├─ moduleToContent()
                  │      └─ WalkThroughContentProviderRegistry.getProvider()
                  │
                  ├─ marked.parse() [.mdファイルの場合]
                  │      └─ renderer.code() → スニペットURI生成
                  │
                  ├─ CodeEditorWidget生成 (各スニペット)
                  │      └─ ITextModelService.createModelReference()
                  │
                  └─ decorateContent()
                         └─ IKeybindingService.lookupKeybinding()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

WalkThroughInput ───▶ moduleToContent() ───▶ Markdownコンテンツ
       │                     │
       │                     ▼
       │              marked.parse() ───▶ HTMLコンテンツ
       │                     │
       │                     ▼
       │              CodeEditorWidget生成 ───▶ 埋め込みエディタ
       │                     │
       │                     ▼
       └──────────▶ DomScrollableElement ───▶ スクロール可能なビュー
                            │
                            ▼
                   EditorMemento ───▶ スクロール位置永続化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| walkThrough.contribution.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThrough.contribution.ts` | ソース | モジュール登録とメニュー設定 |
| walkThroughPart.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts` | ソース | メインのエディタペイン実装 |
| walkThroughInput.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughInput.ts` | ソース | エディタ入力とモデル定義 |
| walkThroughActions.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughActions.ts` | ソース | キーボードナビゲーションアクション |
| editorWalkThrough.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/editor/editorWalkThrough.ts` | ソース | デフォルトチュートリアルのアクションとシリアライザ |
| vs_code_editor_walkthrough.ts | `src/vs/workbench/contrib/welcomeWalkthrough/browser/editor/vs_code_editor_walkthrough.ts` | ソース | デフォルトチュートリアルコンテンツ |
| walkThroughContentProvider.ts | `src/vs/workbench/contrib/welcomeWalkthrough/common/walkThroughContentProvider.ts` | ソース | コンテンツプロバイダとスニペットモデル |
| walkThroughUtils.ts | `src/vs/workbench/contrib/welcomeWalkthrough/common/walkThroughUtils.ts` | ソース | テーマカラー定義 |
| walkThroughPart.css | `src/vs/workbench/contrib/welcomeWalkthrough/browser/media/walkThroughPart.css` | スタイル | 画面スタイル定義 |
