# 画面設計書 53-スプラッシュ画面

## 概要

本ドキュメントは、VSCodeのスプラッシュ画面（Parts Splash）の設計仕様を記載する。この画面は、VSCode起動時にワークベンチがロードされるまでの間に表示される初期表示画面であり、ユーザーに視覚的なフィードバックを提供する。

### 本画面の処理概要

スプラッシュ画面は、VSCodeの起動時間を体感的に短縮させるための画面である。前回終了時のレイアウト情報とテーマカラーを保存し、次回起動時にこれらを使用してワークベンチの骨格を素早く描画することで、ユーザーの待機時間を最小化する。

**業務上の目的・背景**：VSCodeは複雑なアプリケーションであり、完全なワークベンチのロードには一定の時間を要する。スプラッシュ画面は、起動中の「真っ白な画面」や「ちらつき」を防ぎ、前回と同じ外観をすぐに表示することで、ユーザー体験を向上させる。また、テーマに応じた適切な背景色を表示することで、ダークテーマユーザーが眩しさを感じることを防ぐ。

**画面へのアクセス方法**：ユーザーが明示的にアクセスする画面ではない。VSCode起動時に自動的に表示され、ワークベンチのロード完了と同時に非表示となる。

**主要な操作・処理内容**：
1. 保存されたスプラッシュデータの読み込み（localStorage）
2. 前回のテーマカラーでワークベンチの骨格（タイトルバー、サイドバー、ステータスバー等）を描画
3. ワークベンチのメインコンテナレイアウト完了時にスプラッシュを非表示化
4. テーマ変更やレイアウト変更時に新しいスプラッシュデータを保存

**画面遷移**：
- 遷移元: OS（アプリケーション起動）
- 遷移先: ワークベンチ（メイン画面）

**権限による表示制御**：特別な権限制御は行わない。全ユーザーに同一の動作を提供する。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 56 | ウィンドウ管理 | 主機能 | 起動時のスプラッシュスクリーン表示 |
| 47 | 設定管理 | 補助機能 | テーマ設定、ズームレベル設定の読み取り |

## 画面種別

スプラッシュ / ロード中表示

## URL/ルーティング

本画面はルーティングを持たない。DOM要素ID `monaco-parts-splash` として直接DOMに挿入される。

## 入出力項目

### 保存データ (IPartsSplash)

| 項目名 | 型 | 説明 |
|--------|-----|------|
| zoomLevel | number | ウィンドウのズームレベル |
| baseTheme | string | ベーステーマ（vs, vs-dark, hc-black, hc-light） |
| colorInfo | object | テーマカラー情報 |
| layoutInfo | object | レイアウト情報（オプション） |

### colorInfo詳細

| 項目名 | 型 | 説明 |
|--------|-----|------|
| foreground | string | 前景色 |
| background | string | 背景色 |
| editorBackground | string | エディタ背景色 |
| titleBarBackground | string | タイトルバー背景色 |
| titleBarBorder | string | タイトルバー境界線色 |
| activityBarBackground | string | アクティビティバー背景色 |
| activityBarBorder | string | アクティビティバー境界線色 |
| sideBarBackground | string | サイドバー背景色 |
| sideBarBorder | string | サイドバー境界線色 |
| statusBarBackground | string | ステータスバー背景色 |
| statusBarBorder | string | ステータスバー境界線色 |
| statusBarNoFolderBackground | string | フォルダ未オープン時のステータスバー背景色 |
| windowBorder | string | ウィンドウ境界線色 |

### layoutInfo詳細

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sideBarSide | string | サイドバーの位置（left/right） |
| editorPartMinWidth | number | エディタ部分の最小幅 |
| titleBarHeight | number | タイトルバーの高さ |
| activityBarWidth | number | アクティビティバーの幅 |
| sideBarWidth | number | サイドバーの幅 |
| auxiliaryBarWidth | number | 補助サイドバーの幅 |
| statusBarHeight | number | ステータスバーの高さ |
| windowBorder | boolean | ウィンドウ境界線の有無 |
| windowBorderRadius | string | ウィンドウ境界線の角丸 |

## 表示項目

スプラッシュ画面自体は視覚的な情報を含まない。前回のレイアウトを模した骨格構造のみを表示する。

| 表示要素 | 内容 |
|---------|------|
| タイトルバー領域 | 背景色のみ（高さ: titleBarHeight） |
| アクティビティバー領域 | 背景色のみ（幅: activityBarWidth） |
| サイドバー領域 | 背景色のみ（幅: sideBarWidth） |
| エディタ領域 | 背景色のみ |
| ステータスバー領域 | 背景色のみ（高さ: statusBarHeight） |

## イベント仕様

### 1-起動時スプラッシュ表示

アプリケーション起動時に、index.htmlまたはbootstrapウィンドウ処理でスプラッシュが表示される。

1. localStorageから `monaco-parts-splash` キーのデータを読み込み
2. 保存されたcolorInfoとlayoutInfoを使用してDOM要素を構築
3. `monaco-parts-splash` IDのdiv要素としてドキュメントに挿入
4. `initialShellColors` クラスのstyle要素で初期色を設定

### 2-スプラッシュ非表示化

PartsSplashコントリビューションの処理で非表示化が行われる。

1. IWorkbenchLayoutService.onDidLayoutMainContainerイベントを監視
2. メインコンテナのレイアウト完了時に_removePartsSplash()を呼び出し
3. `monaco-parts-splash` 要素のdisplayをnoneに設定
4. `initialShellColors` クラスのstyle要素を削除
5. パフォーマンスマーク `code/didRemovePartsSplash` を記録

### 3-スプラッシュデータ保存

以下のタイミングでスプラッシュデータが保存される。

| トリガー | イベント |
|---------|---------|
| フルスクリーン変更 | onDidChangeFullscreen |
| エディタグループレイアウト変更 | editorGroupsService.mainPart.onDidLayout |
| テーマカラー変更 | IThemeService.onDidColorThemeChange |
| タイトルバースタイル変更 | configurationService.onDidChangeConfiguration |

保存処理:
1. 現在のテーマから色情報を取得
2. 現在のレイアウトから位置・サイズ情報を取得
3. ISplashStorageService.saveWindowSplash()でlocalStorageに保存

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。localStorageを使用してスプラッシュデータを永続化する。

| 操作（イベント） | 対象ストレージ | 操作種別 | 概要 |
|----------------|---------------|---------|------|
| 起動時 | localStorage | SELECT | スプラッシュデータの読み込み |
| レイアウト変更時 | localStorage | UPDATE | スプラッシュデータの保存 |
| テーマ変更時 | localStorage | UPDATE | スプラッシュデータの保存 |

### テーブル別更新項目詳細

#### localStorage (monaco-parts-splash)

| 操作 | キー | 更新値 | 備考 |
|-----|------|-------|------|
| UPDATE | monaco-parts-splash | IPartsSplash JSON文字列 | saveWindowSplash()で保存 |

## メッセージ仕様

スプラッシュ画面はユーザーへのメッセージを表示しない。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| localStorage読み込み失敗 | デフォルトの背景色でスプラッシュを表示 |
| JSON解析エラー | デフォルトの背景色でスプラッシュを表示 |
| フルスクリーンモード | layoutInfoを保存しない（_shouldSaveLayoutInfo()がfalseを返す） |
| 拡張機能開発モード | layoutInfoを保存しない |
| タイトルバースタイル変更直後 | layoutInfoを保存しない（_didChangeTitleBarStyle フラグ） |

## 備考

- 本画面はWorkbenchContributionとして実装されており、エディタペインではない
- WorkbenchPhase.BlockStartupフェーズで登録され、起動プロセスの最初期に実行される
- スプラッシュの削除は一度だけ実行される（Event.onceを使用）
- パフォーマンス計測のためにperf.mark()を使用
- ブラウザ版ではSplashStorageServiceがlocalStorageにデータを保存
- Electron版では別の保存メカニズムが使用される可能性がある
- 補助サイドバーが最大化状態の場合、幅としてNumber.MAX_SAFE_INTEGERがマーカーとして保存される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スプラッシュデータの構造とサービスインターフェースを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | splash.ts | `src/vs/workbench/contrib/splash/browser/splash.ts` | ISplashStorageServiceインターフェース定義 |
| 1-2 | themeService.ts | `src/vs/platform/theme/common/themeService.ts` | IPartsSplashインターフェースの定義場所（colorInfo, layoutInfoの型） |

**読解のコツ**: ISplashStorageServiceは最小限のインターフェース（saveWindowSplashのみ）で、実装はcontributionで行われる。

#### Step 2: エントリーポイントを理解する

処理の起点となるcontributionファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | splash.contribution.ts | `src/vs/workbench/contrib/splash/browser/splash.contribution.ts` | SplashStorageServiceの実装とPartsSplashの登録 |

**主要処理フロー**:
1. **12-20行目**: SplashStorageServiceの実装（localStorageへの保存）
2. **23-27行目**: PartsSplashをWorkbenchContributionとして登録（BlockStartupフェーズ）

#### Step 3: メインロジックを理解する

スプラッシュの表示/非表示とデータ保存のロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | partsSplash.ts | `src/vs/workbench/contrib/splash/browser/partsSplash.ts` | PartsSplashクラスの完全な実装 |

**主要処理フロー**:
- **36-44行目**: コンストラクタでの依存性注入
- **45-48行目**: onDidLayoutMainContainerでスプラッシュ削除をスケジュール
- **50-57行目**: LifecyclePhase.Restored後に保存処理をスケジュール
- **59-64行目**: タイトルバースタイル変更の監視
- **71-104行目**: _savePartsSplash()で色情報とレイアウト情報を収集・保存
- **106-108行目**: _shouldSaveLayoutInfo()でレイアウト保存の可否を判定
- **110-121行目**: _removePartsSplash()でスプラッシュ要素を非表示化

#### Step 4: テーマカラーの取得を理解する

テーマサービスからの色情報取得を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | theme.ts | `src/vs/workbench/common/theme.ts` | TITLE_BAR_ACTIVE_BACKGROUND等のカラーキー定義 |

**主要処理フロー**:
- 各Parts（タイトルバー、アクティビティバー、サイドバー等）の背景色・境界線色キーを確認

### プログラム呼び出し階層図

```
[起動時]
index.html / bootstrap
    │
    └─ localStorageから'monaco-parts-splash'読み込み
           │
           └─ DOM要素生成（#monaco-parts-splash）
                  │
                  └─ 初期色スタイル適用（.initialShellColors）

[ワークベンチロード後]
PartsSplash.constructor()
    │
    ├─ Event.once(onDidLayoutMainContainer)
    │      └─ _removePartsSplash()
    │             ├─ #monaco-parts-splash を display:none
    │             ├─ .initialShellColors を削除
    │             └─ perf.mark('code/didRemovePartsSplash')
    │
    └─ lifecycleService.when(Restored)
           │
           └─ イベント監視開始
                  ├─ onDidChangeFullscreen ──▶ savePartsSplashSoon()
                  ├─ editorGroupsService.mainPart.onDidLayout ──▶ savePartsSplashSoon()
                  └─ themeService.onDidColorThemeChange ──▶ savePartsSplashSoon()
                                                              │
                                                              └─ _savePartsSplash()
                                                                     │
                                                                     ├─ IThemeService.getColorTheme()
                                                                     ├─ IWorkbenchLayoutService各種
                                                                     └─ ISplashStorageService.saveWindowSplash()
```

### データフロー図

```
[入力]                       [処理]                          [出力]

起動時:
localStorage ───▶ JSON.parse() ───▶ IPartsSplash ───▶ DOM要素生成
    │                                                      │
    │                                                      ▼
    │                                              #monaco-parts-splash
    │
保存時:
IThemeService ───▶ getColor() ───▶ colorInfo ───┐
                                                 │
IWorkbenchLayoutService ───▶ レイアウト取得 ───▶ layoutInfo ───┼──▶ IPartsSplash
                                                 │
IConfigurationService ───▶ zoomLevel ───────────┘
                                                          │
                                                          ▼
                                              saveWindowSplash()
                                                          │
                                                          ▼
                                              localStorage.setItem()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| splash.ts | `src/vs/workbench/contrib/splash/browser/splash.ts` | ソース | ISplashStorageServiceインターフェース定義 |
| partsSplash.ts | `src/vs/workbench/contrib/splash/browser/partsSplash.ts` | ソース | スプラッシュ表示/非表示/保存のメインロジック |
| splash.contribution.ts | `src/vs/workbench/contrib/splash/browser/splash.contribution.ts` | ソース | ブラウザ版のサービス登録とcontribution登録 |
| splash.contribution.ts | `src/vs/workbench/contrib/splash/electron-browser/splash.contribution.ts` | ソース | Electron版の固有登録 |
| theme.ts | `src/vs/workbench/common/theme.ts` | ソース | ワークベンチのテーマカラーキー定義 |
| colorRegistry.ts | `src/vs/platform/theme/common/colorRegistry.ts` | ソース | エディタ背景色等の基本カラーキー定義 |
| themeService.ts | `src/vs/platform/theme/common/themeService.ts` | ソース | IPartsSplashインターフェースの型定義 |
| layoutService.ts | `src/vs/workbench/services/layout/browser/layoutService.ts` | ソース | IWorkbenchLayoutServiceでレイアウト情報を提供 |
| editor.ts | `src/vs/workbench/browser/parts/editor/editor.ts` | ソース | DEFAULT_EDITOR_MIN_DIMENSIONSの定義 |
