# 画面設計書: ステータスバー

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 6 |
| 画面名 | ステータスバー |
| 画面パス | `src/vs/workbench/browser/parts/statusbar/statusbarPart.ts` |
| 概要 | ワークベンチの最下部に配置されるステータスバー。エディタの状態、Git情報、通知、クイック操作などを表示する |

## 2. 画面構成

### 2.1 レイアウト概要

```
+--------------------------------------------------------------------+
| [左エリア: ブランチ | 同期] [中央エリア] [右エリア: 行列 | 言語 | 通知] |
+--------------------------------------------------------------------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| leftItemsContainer | 左側アイテムコンテナ | はい | 常時 |
| rightItemsContainer | 右側アイテムコンテナ | はい | 常時 |
| statusBarItem | 個別のステータス項目 | はい | 項目による |

## 3. 機能仕様

### 3.1 ステータスアイテム

- **左側エリア**: Git情報、エラー/警告数など
- **右側エリア**: 行/列、言語モード、エンコーディング、通知など
- **優先順位**: priority値で表示順序を制御

### 3.2 組み込みステータス項目

| 項目ID | 位置 | 説明 |
|--------|------|------|
| `status.editor.selection` | 右 | カーソル位置（行:列） |
| `status.editor.indentation` | 右 | インデント設定 |
| `status.editor.encoding` | 右 | ファイルエンコーディング |
| `status.editor.eol` | 右 | 改行コード |
| `status.editor.mode` | 右 | 言語モード |
| `status.scm.branch` | 左 | Gitブランチ |
| `status.problems` | 左 | エラー/警告数 |
| `status.notifications` | 右 | 通知ベル |

### 3.3 インタラクション

- **クリック**: 関連するクイックピックや設定を開く
- **コンテキストメニュー**: 項目の表示/非表示切り替え
- **背景色**: 状態に応じた色変化（エラー時は赤など）

### 3.4 動的更新

- **リアルタイム更新**: エディタ状態変更時に自動更新
- **バッジ表示**: 通知数などのバッジ
- **スピナー表示**: バックグラウンド処理中のインジケータ

## 4. データフロー

```
[エディタ状態変更]
         |
         v
[StatusbarService.updateEntry()]
         |
         v
[StatusbarPart.updateItemStyles()]
         |
         v
[ステータスバー項目の更新]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidChangeEntryVisibility | 項目の表示変更 | 項目の表示/非表示 |
| onDidChangeEntryCommand | コマンドの変更 | クリック動作の更新 |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.statusBar.visible` | ステータスバーの表示 | `true` |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `statusbarPart.ts` の `StatusbarPart` クラス
2. **サービス**: `IStatusbarService` でステータス項目を管理
3. **エントリー登録**: `StatusbarEntryItem` で各項目を表現

### 7.2 プログラム呼び出し階層図

```
StatusbarPart
  |
  +-- Part (extends)
  |
  +-- StatusbarService (implements)
  |     |
  |     +-- createEntry()
  |     +-- updateEntry()
  |     +-- disposeEntry()
  |
  +-- StatusbarEntryItem (multiple)
        +-- render()
        +-- update()
```

### 7.3 データフロー図

```
[拡張機能/コア機能]
         |
         v
[StatusbarService.createEntry()]
         |
         v
[StatusbarPart.addEntry()]
         |
         v
[StatusbarEntryItem.render()]
         |
         v
[DOM要素の追加]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/parts/statusbar/statusbarPart.ts` | ステータスバーパーツ本体 |
| `src/vs/workbench/services/statusbar/browser/statusbar.ts` | ステータスバーサービス |
| `src/vs/platform/statusbar/common/statusbar.ts` | ステータスバーインターフェース |
| `src/vs/workbench/browser/parts/statusbar/statusbarItem.ts` | ステータスバー項目 |
| `src/vs/workbench/browser/parts/statusbar/media/statusbarpart.css` | スタイル定義 |

### 7.5 重要なコードスニペット

**StatusbarPartクラスの構造（statusbarPart.ts）**
```typescript
export class StatusbarPart extends Part implements IStatusbarService {
  readonly minimumWidth: number = 0;
  readonly maximumWidth: number = Number.POSITIVE_INFINITY;
  readonly minimumHeight: number = 22;
  readonly maximumHeight: number = 22;

  private leftItemsContainer: HTMLElement;
  private rightItemsContainer: HTMLElement;

  constructor(
    @IInstantiationService instantiationService: IInstantiationService,
    @IThemeService themeService: IThemeService,
    // ... 他の依存関係
  ) {
    super(Parts.STATUSBAR_PART, { hasTitle: false }, themeService, storageService, layoutService);
  }
}
```

**ステータスエントリの追加**
```typescript
createEntry(id: string, name: string, alignment: StatusbarAlignment, priority: number): IStatusbarEntryAccessor {
  const entry = new StatusbarEntryItem(
    this.instantiationService,
    id,
    name,
    alignment,
    priority
  );

  this.registerEntry(entry);
  return entry;
}
```

**ステータスバー項目のインターフェース**
```typescript
interface IStatusbarEntry {
  text: string;
  tooltip?: string;
  command?: string | Command;
  color?: string | ThemeColor;
  backgroundColor?: string | ThemeColor;
  showBeak?: boolean;
  ariaLabel?: string;
}
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| ワークベンチ | 常時 | ワークベンチの一部として表示 |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| クイックピック | 項目クリック | 言語モード選択など |
| 問題パネル | エラー数クリック | 問題一覧表示 |
| Git操作 | ブランチクリック | ブランチ切り替え |
| 通知センター | 通知ベルクリック | 通知一覧表示 |

## 9. スタイリング

### 9.1 テーマカラー

| カラーID | 説明 |
|----------|------|
| `statusBar.background` | 通常時の背景色 |
| `statusBar.foreground` | 通常時の前景色 |
| `statusBar.border` | ボーダー色 |
| `statusBar.noFolderBackground` | フォルダ未開時の背景 |
| `statusBar.noFolderForeground` | フォルダ未開時の前景 |
| `statusBar.debuggingBackground` | デバッグ中の背景 |
| `statusBar.debuggingForeground` | デバッグ中の前景 |
| `statusBarItem.hoverBackground` | ホバー時の背景 |
| `statusBarItem.activeBackground` | アクティブ時の背景 |
| `statusBarItem.errorBackground` | エラー状態の背景 |
| `statusBarItem.warningBackground` | 警告状態の背景 |

### 9.2 CSSクラス

| クラス名 | 説明 |
|----------|------|
| `.part.statusbar` | ステータスバーコンテナ |
| `.statusbar-item` | 個別項目 |
| `.left-items` | 左側コンテナ |
| `.right-items` | 右側コンテナ |
| `.has-beak` | ビーク（▲）付き項目 |

## 10. ステータスバー項目の配置

### 10.1 StatusbarAlignment

| 値 | 説明 |
|----|------|
| `LEFT` | 左側に配置 |
| `RIGHT` | 右側に配置 |

### 10.2 優先順位（priority）

- **高い値**: より外側（左側なら左端、右側なら右端）に配置
- **低い値**: より内側（中央寄り）に配置

## 11. アクセシビリティ

- **キーボードナビゲーション**: Tab/矢印キーで項目間移動
- **フォーカス管理**: `workbench.action.focusStatusBar`コマンド
- **ARIAラベル**: 各項目にariaLabel設定
- **スクリーンリーダー**: 項目名と値の読み上げ

## 12. 拡張ポイント

### 12.1 ステータスバー項目の追加

拡張機能からStatusbarサービスを使用してカスタム項目を追加可能

```typescript
const statusBarItem = vscode.window.createStatusBarItem(
  vscode.StatusBarAlignment.Left,
  100 // priority
);
statusBarItem.text = 'My Status';
statusBarItem.command = 'myExtension.doSomething';
statusBarItem.show();
```
