# 画面設計書: アクティビティバー

## 1. 基本情報

| 項目 | 内容 |
|------|------|
| 画面ID | 7 |
| 画面名 | アクティビティバー |
| 画面パス | `src/vs/workbench/browser/parts/activitybar/activitybarPart.ts` |
| 概要 | ワークベンチの端に配置されるアイコンバー。サイドバーやパネルのビューコンテナを切り替えるためのアイコンを表示する |

## 2. 画面構成

### 2.1 レイアウト概要

```
+--------+
| [Menu] |  ← コンパクトメニュー（オプション）
+--------+
|  (E)   |  ← エクスプローラ
|  (S)   |  ← 検索
|  (G)   |  ← ソース管理
|  (D)   |  ← デバッグ
|  (X)   |  ← 拡張機能
|  ...   |  ← 追加のビューコンテナ
+--------+
|  (A)   |  ← アカウント
|  (*)   |  ← 設定
+--------+
```

### 2.2 構成要素

| 要素名 | 説明 | 必須 | 可視性 |
|--------|------|------|--------|
| menuBarContainer | コンパクトメニューコンテナ | いいえ | 設定依存 |
| compositeBarContainer | ビューコンテナアイコン | はい | 常時 |
| globalCompositeBar | グローバルアクション（設定等） | いいえ | 設定依存 |

## 3. 機能仕様

### 3.1 ビューコンテナ切り替え

- **アイコンクリック**: 対応するサイドバー/パネルを表示
- **ダブルクリック**: ビューコンテナの表示/非表示をトグル
- **ドラッグ&ドロップ**: アイコンの並べ替え

### 3.2 配置位置

| 位置 | 設定値 | 説明 |
|------|--------|------|
| サイドバー横（デフォルト） | `default` | 従来の左端/右端配置 |
| タイトルバー上部 | `top` | タイトルバーに統合 |
| タイトルバー下部 | `bottom` | タイトルバー下に配置 |
| 非表示 | `hidden` | アクティビティバーを非表示 |

### 3.3 バッジ表示

- **通知バッジ**: 未読通知数など
- **SCMバッジ**: コミット可能な変更数
- **エラーバッジ**: エラー/警告の件数

### 3.4 コンパクトメニュー

- **条件**: メニューバー表示が`compact`の場合
- **機能**: メニューバーをアクティビティバーに統合

### 3.5 グローバルアクション

- **アカウント**: サインイン/サインアウト
- **設定**: 設定メニューへのアクセス
- **位置**: アクティビティバーの下部

## 4. データフロー

```
[アイコンクリック]
         |
         v
[ActivitybarPart.compositeBar.focus()]
         |
         v
[PaneCompositeService.openPaneComposite()]
         |
         v
[対応するビューコンテナの表示]
```

## 5. イベント

| イベント名 | トリガー | 処理内容 |
|------------|----------|----------|
| onDidChangeVisibility | 表示状態変更 | レイアウト更新 |
| onDidCompositeActivate | アイコン選択 | ビューコンテナ切り替え |

## 6. 関連設定

| 設定キー | 説明 | デフォルト値 |
|----------|------|--------------|
| `workbench.activityBar.location` | アクティビティバーの位置 | `default` |
| `window.menuBarVisibility` | メニューバー表示（compact時影響） | `classic` |

## 7. コードリーディングガイド

### 7.1 読解の流れ

1. **エントリーポイント**: `activitybarPart.ts` の `ActivitybarPart` クラス
2. **コンポジットバー**: `ActivityBarCompositeBar` でアイコン管理
3. **グローバルバー**: `GlobalCompositeBar` で設定/アカウント管理

### 7.2 プログラム呼び出し階層図

```
ActivitybarPart
  |
  +-- Part (extends)
  |
  +-- PaneCompositeBar (compositeBar)
  |     |
  |     +-- ActivityBarCompositeBar (extends)
  |           +-- createCompositeBar()
  |           +-- GlobalCompositeBar (optional)
  |           +-- CustomMenubarControl (optional)
  |
  +-- ViewContainer management
        +-- getPinnedPaneCompositeIds()
        +-- getVisiblePaneCompositeIds()
```

### 7.3 データフロー図

```
[ViewDescriptorService.onDidChangeContainer]
         |
         v
[ActivityBarCompositeBar.updateCompositeBar]
         |
         v
[アイコンの追加/削除/並べ替え]
         |
         v
[バッジの更新]
```

### 7.4 関連ファイル一覧

| ファイルパス | 説明 |
|--------------|------|
| `src/vs/workbench/browser/parts/activitybar/activitybarPart.ts` | アクティビティバーパーツ本体（行1-619） |
| `src/vs/workbench/browser/parts/paneCompositeBar.ts` | コンポジットバー基底 |
| `src/vs/workbench/browser/parts/globalCompositeBar.ts` | グローバルアクション |
| `src/vs/workbench/browser/parts/compositeBarActions.ts` | バーアクション定義 |
| `src/vs/workbench/browser/parts/activitybar/media/activitybarpart.css` | スタイル定義 |

### 7.5 重要なコードスニペット

**ActivitybarPartクラスの構造（activitybarPart.ts 行42-70）**
```typescript
export class ActivitybarPart extends Part {
  static readonly ACTION_HEIGHT = 48;

  static readonly pinnedViewContainersKey = 'workbench.activity.pinnedViewlets2';
  static readonly placeholderViewContainersKey = 'workbench.activity.placeholderViewlets';
  static readonly viewContainersWorkspaceStateKey = 'workbench.activity.viewletsWorkspaceState';

  readonly minimumWidth: number = 48;
  readonly maximumWidth: number = 48;
  readonly minimumHeight: number = 0;
  readonly maximumHeight: number = Number.POSITIVE_INFINITY;

  constructor(
    private readonly paneCompositePart: IPaneCompositePart,
    @IInstantiationService private readonly instantiationService: IInstantiationService,
    // ...
  ) {
    super(Parts.ACTIVITYBAR_PART, { hasTitle: false }, themeService, storageService, layoutService);
  }
}
```

**コンポジットバーの作成（activitybarPart.ts 行72-100）**
```typescript
private createCompositeBar(): PaneCompositeBar {
  return this.instantiationService.createInstance(ActivityBarCompositeBar, {
    partContainerClass: 'activitybar',
    pinnedViewContainersKey: ActivitybarPart.pinnedViewContainersKey,
    orientation: ActionsOrientation.VERTICAL,
    icon: true,
    iconSize: 24,
    activityHoverOptions: {
      position: () => this.layoutService.getSideBarPosition() === Position.LEFT
        ? HoverPosition.RIGHT
        : HoverPosition.LEFT,
    },
    compositeSize: 52,
    // ...
  });
}
```

**位置変更アクション（activitybarPart.ts 行386-410）**
```typescript
registerAction2(class extends Action2 {
  constructor() {
    super({
      id: 'workbench.action.activityBarLocation.default',
      title: { ...localize2('positionActivityBarDefault', 'Move Activity Bar to Side') },
      // ...
    });
  }
  run(accessor: ServicesAccessor): void {
    const configurationService = accessor.get(IConfigurationService);
    configurationService.updateValue(LayoutSettings.ACTIVITY_BAR_LOCATION, ActivityBarPosition.DEFAULT);
  }
});
```

## 8. 画面遷移

### 8.1 遷移元

| 遷移元 | 条件 | 説明 |
|--------|------|------|
| ワークベンチ | 常時 | ワークベンチの一部として表示 |
| キーボード | Ctrl+Shift+E等 | 直接ビュー切り替え |

### 8.2 遷移先

| 遷移先 | 条件 | 説明 |
|--------|------|------|
| サイドバー | アイコンクリック | ビューコンテナの表示 |
| 設定画面 | 設定アイコンクリック | 設定を開く |
| アカウント | アカウントアイコンクリック | サインイン/設定同期 |

## 9. スタイリング

### 9.1 テーマカラー

| カラーID | 説明 |
|----------|------|
| `activityBar.background` | 背景色 |
| `activityBar.foreground` | アクティブアイコン色 |
| `activityBar.inactiveForeground` | 非アクティブアイコン色 |
| `activityBar.border` | ボーダー色 |
| `activityBar.activeBorder` | アクティブインジケータ色 |
| `activityBar.activeBackground` | アクティブ背景色 |
| `activityBar.activeFocusBorder` | フォーカス時ボーダー色 |
| `activityBarBadge.background` | バッジ背景色 |
| `activityBarBadge.foreground` | バッジ前景色 |

### 9.2 CSSクラス

| クラス名 | 説明 |
|----------|------|
| `.part.activitybar` | アクティビティバーコンテナ |
| `.content` | コンテンツエリア |
| `.monaco-action-bar` | アクションバー |
| `.action-item` | 各アイコン項目 |
| `.active-item-indicator` | アクティブインジケータ |
| `.badge` | バッジ |

## 10. アクティビティバーの位置

| ActivityBarPosition | 説明 |
|--------------------|------|
| `DEFAULT` | サイドバー横の独立バー |
| `TOP` | タイトルバー上部に統合 |
| `BOTTOM` | タイトルバー下部に統合 |
| `HIDDEN` | 非表示 |

## 11. アクセシビリティ

- **キーボードナビゲーション**: 上下矢印キーでアイコン間移動
- **フォーカス管理**: `workbench.action.focusActivityBar`コマンド
- **ARIAロール**: toolbar, buttonの適切な設定
- **スクリーンリーダー**: アイコン名とバッジ数の読み上げ

## 12. 拡張ポイント

### 12.1 カスタムビューコンテナ

拡張機能から`contributes.viewsContainers`でカスタムアイコンを追加可能

```json
{
  "contributes": {
    "viewsContainers": {
      "activitybar": [
        {
          "id": "myContainer",
          "title": "My Container",
          "icon": "resources/icon.svg"
        }
      ]
    }
  }
}
```
