---
generated_at: 2026-01-27 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 1-ワークベンチ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス考慮事項の詳細**：実装詳細の確認が必要
  2. **エラーハンドリングの網羅性**：追加のエラーケースがある可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/browser/workbench.ts`
- E-02: `src/vs/workbench/browser/layout.ts`（行1-400）
- E-03: `src/vs/workbench/services/layout/browser/layoutService.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面遷移図/画面遷移図.md`
- E-06: `src/vs/base/browser/ui/grid/grid.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークベンチは全てのUI部品を統合管理する中核画面 | E-01, E-02 | ○ |
| C-02 | SerializableGridを使用してレイアウト管理 | E-02 行265, E-06 | ○ |
| C-03 | タイトルバー、サイドバー等8つのパーツで構成 | E-02 行267-274 | ○ |
| C-04 | Zenモード機能をサポート | E-02 行144-145 | ○ |
| C-05 | フルスクリーンモードをサポート | E-02 行9, E-03 | ○ |
| C-06 | マルチウィンドウ対応 | E-02 行48-49 | ○ |
| C-07 | ConfigurationServiceで設定管理 | E-02 行278 | ○ |
| C-08 | StorageServiceでレイアウト状態保存 | E-02 行279 | ○ |
| C-09 | onDidChangeZenModeイベント存在 | E-02 行144-145 | ○ |
| C-10 | onDidChangePartVisibilityイベント存在 | E-02 行159-160 | ○ |
| C-11 | onDidLayoutMainContainerイベント存在 | E-02 行168-169 | ○ |
| C-12 | workbench.activityBar.location設定 | E-03 | ○ |
| C-13 | workbench.sideBar.location設定 | E-02 行369 | ○ |
| C-14 | workbench.panel.defaultLocation設定 | E-03 | ○ |
| C-15 | workbench.statusBar.visible設定 | E-02 行369 | ○ |
| C-16 | window.titleBarStyle設定 | E-02 行131 | ○ |
| C-17 | Parts enumでパーツ識別子定義 | E-03 | ○ |
| C-18 | initLayout()でサービス初期化 | E-02 行307-337 | ○ |
| C-19 | registerLayoutListeners()でリスナー登録 | E-02 行333 | ○ |
| C-20 | F6キーでパーツ間移動 | E-03 | ○ |
| C-21 | バナーパーツは条件付き表示 | E-02 行239-242 | ○ |
| C-22 | LayoutClassesで状態管理 | E-02 行95-104 | ○ |
| C-23 | パネル位置変更イベント存在 | E-02 行157-158 | ○ |
| C-24 | 遅延初期化でパフォーマンス最適化 | **根拠なし** | △ |
| C-25 | レイアウト計算のバッチ処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス最適化の詳細実装
  - 候補：workbench.ts内の初期化処理 / layout.ts内のlayout()メソッド / Performance APIの使用箇所
- エラーハンドリングの追加ケース
  - 候補：try-catchブロックの確認 / エラー通知サービスの使用箇所

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 1: 中リスク - パフォーマンス関連の記述は実装確認推奨
- 0: 低リスク - イベント・設定の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] レイアウト構成図が実際のUIと一致するか確認
- [ ] 設定キーが最新のコードと一致するか確認
- [ ] パフォーマンス最適化の実装詳細を確認
- [ ] エラーハンドリングの網羅性を確認
