---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-テキストエディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Monaco Editor基盤の記載**：製品レベルでの確認推奨
  2. **Language Server Protocol統合**：拡張機能依存のため詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/browser/parts/editor/textEditor.ts` (AbstractTextEditorクラス定義)
- E-02: `src/vs/editor/common/core/selection.ts` (Selectionクラス)
- E-03: `src/vs/workbench/common/editor.ts` (IEditorPaneWithSelection等のインターフェース)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面No.11の定義)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング情報)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (画面遷移情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テキストエディタはMonaco Editorを基盤として構築 | E-01 (49行目 ICodeEditor使用) | ○ |
| C-02 | AbstractTextEditorがテキストエディタの基底クラス | E-01 (49行目) | ○ |
| C-03 | IEditorPaneWithSelection, IEditorPaneWithScrollingを実装 | E-01 (49行目) | ○ |
| C-04 | シンタックスハイライト機能を提供 | E-05 (機能No.2) | ○ |
| C-05 | IntelliSense（コード補完）機能を提供 | E-05 (機能No.3) | ○ |
| C-06 | コードフォールディング機能を提供 | E-05 (機能No.5) | ○ |
| C-07 | マルチカーソル編集機能を提供 | E-05 (機能No.7) | ○ |
| C-08 | 検索・置換機能を提供 | E-05 (機能No.6) | ○ |
| C-09 | 定義へ移動機能を提供 | E-05 (機能No.11) | ○ |
| C-10 | 参照検索機能を提供 | E-05 (機能No.12) | ○ |
| C-11 | createEditorメソッドでエディタコントロール作成 | E-01 (175-183行目) | ○ |
| C-12 | setInputメソッドでエディタ入力設定 | E-01 (240-253行目) | ○ |
| C-13 | registerCodeEditorListenersでイベント登録 | E-01 (185-193行目) | ○ |
| C-14 | onDidChangeCursorPositionイベント処理 | E-01 (190行目) | ○ |
| C-15 | onDidChangeModelContentイベント処理 | E-01 (191行目) | ○ |
| C-16 | TextEditorPaneSelectionクラスで選択管理 | E-01 (350-390行目) | ○ |
| C-17 | エクスプローラーからファイル選択で遷移 | E-06 (Explorer→TextEditor) | ○ |
| C-18 | 検索結果からファイル選択で遷移 | E-06 (Search→TextEditor) | ○ |
| C-19 | 読み取り専用ファイルの編集制御 | E-01 (154-162行目 getReadonlyConfiguration) | ○ |
| C-20 | ビューステートの保存・復元 | E-01 (296-298行目 toEditorViewStateResource) | ○ |
| C-21 | 設定変更時のエディタ更新 | E-01 (98-109行目 handleConfigurationChangeEvent) | ○ |
| C-22 | ARIAラベルの自動計算 | E-01 (134-136行目 computeAriaLabel) | ○ |
| C-23 | スクロール位置の取得・設定 | E-01 (263-286行目 getScrollPosition/setScrollPosition) | ○ |
| C-24 | Language Server Protocolを通じた言語サポート | **根拠なし** | △ |
| C-25 | 拡張機能によるカスタム機能追加 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Language Server Protocolの統合詳細
  - 候補：`src/vs/workbench/api/common/extHostLanguageFeatures.ts` / Language Server関連ファイル
- 拡張機能APIとの連携詳細
  - 候補：`src/vs/workbench/api/` 配下のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なクラス構造と機能マッピングは正確
- 1: 中リスク - LSP統合の詳細は拡張機能に依存するため、コア実装との関連性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] AbstractTextEditorクラスの継承階層が正確か確認
- [ ] 機能マッピング（機能No.1-20）が画面一覧CSVと整合しているか確認
- [ ] イベント仕様がソースコードのイベントハンドラと一致しているか確認
- [ ] 画面遷移がドキュメント記載の通りか確認
