---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：12-差分エディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **3方向マージサポート**：機能詳細の確認推奨
  2. **差分アルゴリズム設定**：設定項目との整合性確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/editor/textDiffEditor.ts` (TextDiffEditorクラス定義)
- E-02: `src/vs/editor/common/diff/diff.ts` (差分データ構造)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面No.12の定義)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング情報)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (画面遷移情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextDiffEditorが差分エディタのメインクラス | E-01 (42行目) | ○ |
| C-02 | AbstractTextEditorを継承 | E-01 (42行目 extends) | ○ |
| C-03 | DiffEditorWidgetを使用して表示 | E-01 (90-135行目) | ○ |
| C-04 | サイドバイサイド表示とインライン表示をサポート | E-01 (renderSideBySide設定) | ○ |
| C-05 | オリジナルと修正の2つのエディタを保持 | E-01 (originalEditor, modifiedEditor) | ○ |
| C-06 | 差分計算にDiffComputerを使用 | E-02 (diffComputer.ts) | ○ |
| C-07 | 差分結果をIDiffResultで表現 | E-02 (IChange, IDiffResult) | ○ |
| C-08 | F7で次の変更へ移動 | E-01 (DiffNavigator連携) | ○ |
| C-09 | Shift+F7で前の変更へ移動 | E-01 (DiffNavigator連携) | ○ |
| C-10 | スクロール同期機能 | E-01 (syncScroll設定) | ○ |
| C-11 | 追加は緑、削除は赤でハイライト | E-01 (デコレーション設定) | ○ |
| C-12 | ソース管理パネルから遷移可能 | E-05 (SCM→DiffEditor) | ○ |
| C-13 | ローカル履歴から比較可能 | E-04 (関連機能) | ○ |
| C-14 | setInputで差分入力を設定 | E-01 (140-200行目) | ○ |
| C-15 | Monaco DiffEditorを基盤として使用 | E-01 (DiffEditorWidget使用) | ○ |
| C-16 | 識別子がworkbench.editor.textDiffEditor | E-01 (静的ID定義) | ○ |
| C-17 | 空白無視オプション | E-01 (ignoreTrimWhitespace設定) | ○ |
| C-18 | 差分オーバービュー表示 | E-01 (renderOverviewRuler設定) | ○ |
| C-19 | 3方向マージ対応 | **根拠なし** | △ |
| C-20 | 差分アルゴリズム設定変更 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 3方向マージ（3-way merge）の実装詳細
  - 候補：`src/vs/workbench/contrib/mergeEditor/` 配下のファイル
- 差分アルゴリズム設定の詳細
  - 候補：`src/vs/editor/common/diff/` 配下のファイル / 設定スキーマ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な差分表示機能は正確に記載
- 1: 中リスク - 3方向マージは別コンポーネント（MergeEditor）の可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] TextDiffEditorクラスの継承階層が正確か確認
- [ ] DiffEditorWidgetとの連携が正しく記載されているか確認
- [ ] 差分ナビゲーション（F7/Shift+F7）の動作確認
- [ ] 3方向マージがMergeEditorとして別実装かどうか確認
