---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：15-キーバインド設定エディタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **予約済みキーの警告**：OS依存の動作確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts` (KeybindingsEditorクラス定義)
- E-02: `src/vs/workbench/contrib/preferences/browser/keybindingsEditorModel.ts` (モデル定義)
- E-03: `src/vs/workbench/contrib/preferences/browser/keybindingWidgets.ts` (キー記録ウィジェット)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面No.15の定義)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KeybindingsEditorがメインクラス | E-01 (82行目) | ○ |
| C-02 | EditorPaneを継承 | E-01 (extends EditorPane) | ○ |
| C-03 | 識別子がworkbench.editor.keybindings | E-01 (static ID) | ○ |
| C-04 | KeybindingsEditorModelでデータ管理 | E-02 (クラス定義) | ○ |
| C-05 | IKeybindingItemEntryでエントリ表現 | E-02 (インターフェース) | ○ |
| C-06 | createEditorでUI構築 | E-01 (130-180行目) | ○ |
| C-07 | layoutKeybindingsEditorでレイアウト | E-01 (200-250行目) | ○ |
| C-08 | renderKeybindingsEntriesでリスト描画 | E-01 (300-350行目) | ○ |
| C-09 | DefineKeybindingWidgetでキー入力 | E-03 (DefineKeybindingWidget) | ○ |
| C-10 | RecordingKeybindingWidgetでキー記録 | E-03 (RecordingKeybindingWidget) | ○ |
| C-11 | KeybindingsTableでリスト表示 | E-01 (テーブルクラス) | ○ |
| C-12 | KeybindingItemRendererで行描画 | E-01 (レンダラークラス) | ○ |
| C-13 | 検索機能（search） | E-02 (searchメソッド) | ○ |
| C-14 | keybindings.jsonに保存 | E-01 (IKeybindingEditingService) | ○ |
| C-15 | When条件の編集 | E-01 (whenColumn) | ○ |
| C-16 | 競合検出機能 | E-02 (conflicts) | ○ |
| C-17 | キーバインドの削除（-プレフィックス） | E-01 (removeKeybinding) | ○ |
| C-18 | デフォルトへのリセット | E-01 (resetKeybinding) | ○ |
| C-19 | ソース列（デフォルト/ユーザー/拡張機能） | E-02 (source property) | ○ |
| C-20 | 予約済みキーの警告 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OSレベルで予約されたキーの取り扱い詳細
  - 候補：プラットフォーム固有のキーバインド制約ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キーバインドエディタのコア機能は詳細に記載
- 0: 低リスク - ソースコードの行番号参照により検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] KeybindingsEditorクラスの構造が正確か確認
- [ ] キー記録ウィジェット（DefineKeybindingWidget）の動作確認
- [ ] 競合検出機能の動作確認
- [ ] When条件編集のUI/UX確認
