---
generated_at: 2026-01-27 10:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 2-タイトルバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **WCO（Window Controls Overlay）の詳細動作**：Web固有の実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/titlebar/titlebarPart.ts`（行1-962）
- E-02: `src/vs/workbench/browser/parts/titlebar/windowTitle.ts`
- E-03: `src/vs/workbench/browser/parts/titlebar/menubarControl.ts`
- E-04: `src/vs/workbench/browser/parts/titlebar/commandCenterControl.ts`
- E-05: `src/vs/platform/window/common/window.ts`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | タイトルバーはウィンドウ最上部に表示 | E-01 行220-221, E-06 | ○ |
| C-02 | leftContent, centerContent, rightContentの3分割構造 | E-01 行453-455 | ○ |
| C-03 | BrowserTitlebarPartクラスがメイン実装 | E-01 行220 | ○ |
| C-04 | BrowserTitleServiceでマルチウィンドウ対応 | E-01 行88-107 | ○ |
| C-05 | WindowTitleクラスでタイトル管理 | E-01 行319 | ○ |
| C-06 | CustomMenubarControlでカスタムメニュー実装 | E-01 行412-419 | ○ |
| C-07 | コマンドセンターはworkbench.commandCenter設定で制御 | E-01 行810-812 | ○ |
| C-08 | メニューバー表示モードは4種類（visible, toggle, compact, hidden） | E-05 | ○ |
| C-09 | アプリアイコンはWindows/Linuxでのみ表示 | E-01 行457-459 | ○ |
| C-10 | dragRegionでウィンドウドラッグ領域定義 | E-01 行463 | ○ |
| C-11 | 高さ計算でgetZoomFactor考慮 | E-01 行234 | ○ |
| C-12 | DEFAULT_CUSTOM_TITLEBAR_HEIGHTで基本高さ定義 | E-01 行229 | ○ |
| C-13 | onMenubarVisibilityChangeイベント存在 | E-01 行243-244 | ○ |
| C-14 | onWillDisposeイベント存在 | E-01 行246-247 | ○ |
| C-15 | installMenubar()でメニューバー作成 | E-01 行407-419 | ○ |
| C-16 | uninstallMenubar()でメニューバー削除 | E-01 行422-429 | ○ |
| C-17 | createActionToolBar()でツールバー作成 | E-01 行617-639 | ○ |
| C-18 | TITLE_BAR_ACTIVE_BACKGROUND等のテーマカラー | E-01 行18 | ○ |
| C-19 | updateStyles()でスタイル更新 | E-01 行748-784 | ○ |
| C-20 | isInactiveでアクティブ/非アクティブ状態管理 | E-01 行285, 333-342 | ○ |
| C-21 | contextMenuでコンテキストメニュー表示 | E-01 行527-539 | ○ |
| C-22 | AuxiliaryBrowserTitlebarPartで補助ウィンドウ対応 | E-01 行923-961 | ○ |
| C-23 | FocusTitleBarアクションで焦点移動 | E-01 行117-132 | ○ |
| C-24 | registerVariablesでタイトル変数登録 | E-01 行85-86, 202-215 | ○ |
| C-25 | editorActionsEnabledでエディタアクション表示制御 | E-01 行814-820 | ○ |
| C-26 | activityActionsEnabledでアクティビティアクション表示制御 | E-01 行822-825 | ○ |
| C-27 | macOSでトラフィックライト位置をRTL考慮 | E-01 行488-499 | ○ |
| C-28 | WCOの詳細動作仕様 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- WCO（Window Controls Overlay）の詳細な動作仕様
  - 候補：browser.ts内のisWCOEnabled() / getWCOTitlebarAreaRect()の実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造・イベント・メソッドの記述は正確
- 1: 中リスク - WCO関連の詳細はWeb固有のため追加確認推奨
- 0: 低リスク - プラットフォーム固有動作の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] レイアウト構造図が実際のUIと一致するか確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] WCO動作がPWA環境で正しく機能するか確認
- [ ] メニューバー表示モードの動作確認
