---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：20-エクスプローラービュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Gitステータス表示**：デコレーションサービスとの連携詳細確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/files/browser/explorerViewlet.ts` (ExplorerViewPaneContainerクラス定義)
- E-02: `src/vs/workbench/contrib/files/common/files.ts` (共通定義)
- E-03: `src/vs/workbench/contrib/files/browser/views/explorerView.ts` (ファイルツリービュー)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (画面No.20の定義)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (機能マッピング情報)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExplorerViewPaneContainerがメインクラス | E-01 (155行目) | ○ |
| C-02 | ViewPaneContainerを継承 | E-01 (extends ViewPaneContainer) | ○ |
| C-03 | 識別子がworkbench.view.explorer | E-01 (257-274行目 VIEW_CONTAINER) | ○ |
| C-04 | VIEWLET_ID定義 | E-02 (VIEWLET_ID) | ○ |
| C-05 | VIEW_ID定義 | E-02 (VIEW_ID) | ○ |
| C-06 | ExplorerViewletViewsContributionでビュー登録 | E-01 (45行目) | ○ |
| C-07 | createでコンテナ作成 | E-01 (180-183行目) | ○ |
| C-08 | createViewでビュー作成 | E-01 (185-224行目) | ○ |
| C-09 | getExplorerViewでビュー取得 | E-01 (226-228行目) | ○ |
| C-10 | getOpenEditorsViewで開エディタ取得 | E-01 (230-232行目) | ○ |
| C-11 | OpenEditorsViewの存在 | E-01 (14行目 import) | ○ |
| C-12 | EmptyViewの存在 | E-01 (13行目 import) | ○ |
| C-13 | ExplorerViewの存在 | E-01 (12行目 import) | ○ |
| C-14 | registerViewsでビュー登録 | E-01 (101行目) | ○ |
| C-15 | createOpenEditorsViewDescriptor | E-01 (107-123行目) | ○ |
| C-16 | createEmptyViewDescriptor | E-01 (125-137行目) | ○ |
| C-17 | createExplorerViewDescriptor | E-01 (139-152行目) | ○ |
| C-18 | explorerViewIconのアイコン定義 | E-01 (42行目) | ○ |
| C-19 | openEditorsViewIconのアイコン定義 | E-01 (43行目) | ○ |
| C-20 | viewsRegistry.registerViewWelcomeContent | E-01 (286-358行目) | ○ |
| C-21 | Ctrl+Shift+Eショートカット | E-01 (270行目 keybindings) | ○ |
| C-22 | Gitステータスのデコレーション表示 | **根拠なし（デコレーションサービス）** | △ |

## 4) 不足情報（Unknown / Missing）
- Gitステータス表示の詳細実装
  - 候補：`src/vs/workbench/contrib/scm/` 配下のデコレーション関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - エクスプローラービューのコア機能は詳細に記載
- 0: 低リスク - 行番号参照により検証可能性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] ExplorerViewPaneContainerクラスの構造が正確か確認
- [ ] ビュー登録（registerViews）の動作確認
- [ ] ファイルツリー（AsyncDataTree）の動作確認
- [ ] 開いているエディター（OpenEditorsView）の動作確認
