---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：21-検索ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **AIセマンティック検索機能**：実験的機能の詳細確認が必要
  2. **ノートブック検索機能**：実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-02: `src/vs/workbench/contrib/search/browser/searchWidget.ts`
- E-03: `src/vs/workbench/contrib/search/browser/search.contribution.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-07: `src/vs/workbench/contrib/search/browser/searchTreeModel/searchTreeCommon.ts`
- E-08: `src/vs/workbench/services/search/common/search.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 検索ビューはViewPane継承クラスである | E-01 (127行目) | ○ |
| C-02 | View IDは`workbench.view.search` | E-03 (68-85行目) | ○ |
| C-03 | キーボードショートカットCtrl+Shift+F | E-03 (79行目) | ○ |
| C-04 | 検索パターン入力機能 | E-01 (96-115行目 ISearchViewStateQuery) | ○ |
| C-05 | 正規表現オプション | E-01 (100行目 regex) | ○ |
| C-06 | 大文字小文字区別オプション | E-01 (101行目 caseSensitive) | ○ |
| C-07 | 単語単位マッチオプション | E-01 (100行目 wholeWords) | ○ |
| C-08 | 包含/除外パターン機能 | E-01 (102-104行目) | ○ |
| C-09 | 開いているエディタのみ検索 | E-01 (105行目 onlyOpenEditors) | ○ |
| C-10 | 検索ウィジェットはSearchWidgetクラス | E-02 (115行目) | ○ |
| C-11 | 置換機能の存在 | E-02 (75-93行目 ReplaceAllAction) | ○ |
| C-12 | 検索履歴機能 | E-01 (303行目, E-02 57-59行目) | ○ |
| C-13 | ワークベンチツリー表示 | E-01 (161行目 WorkbenchCompressibleAsyncDataTree) | ○ |
| C-14 | 検索結果のツリー/リスト切り替え | E-01 (349-364行目 setTreeView) | ○ |
| C-15 | 検索状態のコンテキストキー管理 | E-01 (247-263行目) | ○ |
| C-16 | アクティビティバーから遷移可能 | E-06 (83-88行目) | ○ |
| C-17 | 検索結果からテキストエディタへ遷移 | E-06 (96-97行目) | ○ |
| C-18 | 機能No.22「検索」が主機能 | E-05 (65行目) | ○ |
| C-19 | 機能No.6「検索・置換」が補助機能 | E-05 (66行目) | ○ |
| C-20 | QueryBuilderによるクエリ構築 | E-01 (296行目) | ○ |
| C-21 | 検索サービスとの連携 | E-01 (73行目 ISearchViewModelWorkbenchService) | ○ |
| C-22 | スクロールロック機能 | E-03 (260-268行目) | ○ |
| C-23 | 検索結果最大件数設定 | E-03 (249-253行目) | ○ |
| C-24 | フォルダ未オープン時のメッセージ | E-01 (181行目 searchWithoutFolderMessageElement) | ○ |
| C-25 | 進捗表示機能 | E-01 (418-422行目 progressService) | ○ |
| C-26 | ファイル変更監視 | E-01 (300行目 onDidFilesChange) | ○ |
| C-27 | AIセマンティック検索機能 | **根拠不足** | △ |
| C-28 | ノートブック内検索機能 | E-02 (39-47行目), 実装詳細要確認 | △ |

## 4) 不足情報（Unknown / Missing）
- AIセマンティック検索機能の詳細な仕様
  - 候補：AISearch/aiSearchModel.ts / 設定項目の詳細確認
- ノートブック検索の正確な挙動
  - 候補：notebookSearch/ ディレクトリ内のファイル群

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な検索機能の説明は根拠が十分
- 1: 中リスク - AI検索機能は実験的であり、将来的な変更可能性あり
- 0: 低リスク - UIコンポーネントの説明は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] 検索オプション（正規表現、大文字小文字、単語単位）の動作確認
- [ ] 検索結果から該当ファイルへの遷移確認
- [ ] 置換機能の動作確認
- [ ] AI検索機能の有効化方法と動作確認（実験的機能）
- [ ] ノートブック内検索の動作確認
