---
generated_at: 2026-01-27 12:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-ソース管理ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **AIコミットメッセージ生成機能**：Copilot拡張機能との連携詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/scm/browser/scmViewPane.ts`
- E-02: `src/vs/workbench/contrib/scm/common/scm.ts`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-06: `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソース管理ビューはViewPane継承クラスである | E-01 (10行目 import ViewPane) | ○ |
| C-02 | View IDは`workbench.scm` | E-02 (14行目 VIEW_PANE_ID) | ○ |
| C-03 | キーボードショートカットCtrl+Shift+G | VSCode標準仕様 | ○ |
| C-04 | ISCMRepositoryインターフェース | E-02 | ○ |
| C-05 | ISCMResourceインターフェース | E-02 (14行目) | ○ |
| C-06 | ISCMResourceGroupインターフェース | E-02 (14行目) | ○ |
| C-07 | TreeElement型定義 | E-01 (115行目) | ○ |
| C-08 | ActionButtonRenderer実装 | E-01 (179-233行目) | ○ |
| C-09 | InputRenderer実装 | E-01 (296-400行目) | ○ |
| C-10 | ドラッグ&ドロップ対応 | E-01 (236-287行目 SCMTreeDragAndDrop) | ○ |
| C-11 | コミットメッセージ入力にCodeEditorWidget使用 | E-01 (44-45行目) | ○ |
| C-12 | WorkbenchCompressibleAsyncDataTree使用 | E-01 (28行目) | ○ |
| C-13 | 複数リポジトリ対応 | E-02 (ISCMViewVisibleRepositoryChangeEvent) | ○ |
| C-14 | アクティビティバーから遷移可能 | E-05 (86行目) | ○ |
| C-15 | 変更ファイルから差分エディタへ遷移 | E-05 (99行目) | ○ |
| C-16 | 機能No.23「ソース管理」が主機能 | E-04 (67行目) | ○ |
| C-17 | 機能No.74「Git統合」が補助機能 | E-04 (68行目) | ○ |
| C-18 | RepositoryRenderer実装 | E-01 (69行目 import), E-06 | ○ |
| C-19 | リポジトリ選択モード | E-02 (ISCMRepositorySelectionMode) | ○ |
| C-20 | ViewMode（リスト/ツリー）切り替え | E-02 (ViewMode) | ○ |
| C-21 | SCMActionButton実装 | E-01 (173-178行目) | ○ |
| C-22 | 入力検証機能 | E-02 (IInputValidation, InputValidationType) | ○ |
| C-23 | リソースラベル表示 | E-01 (15行目 ResourceLabels) | ○ |
| C-24 | カウントバッジ表示 | E-01 (16行目 CountBadge) | ○ |
| C-25 | AIコミットメッセージ生成連携 | **根拠不足** - Copilot拡張機能依存 | △ |

## 4) 不足情報（Unknown / Missing）
- AIコミットメッセージ生成機能の詳細な仕様
  - 候補：Copilot拡張機能のソースコード / VSCode APIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なSCM機能の説明は根拠が十分
- 0: 低リスク - UIコンポーネントの説明は実装と整合
- 1: 中リスク - AI連携機能は拡張機能依存であり変更可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] ファイルのステージング/アンステージング動作確認
- [ ] コミットメッセージ入力とコミット実行の動作確認
- [ ] 変更ファイルクリックで差分エディタへの遷移確認
- [ ] 複数リポジトリ環境での動作確認
- [ ] ドラッグ&ドロップによるファイル操作確認
