---
generated_at: 2026-01-27 12:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：24-拡張機能ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **Marketplace API詳細**：外部API仕様の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/extensions/browser/extensionsViewlet.ts`
- E-02: `src/vs/workbench/contrib/extensions/common/extensions.ts`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 拡張機能ビューはViewPaneContainer継承クラスである | E-01 (40行目 import) | ○ |
| C-02 | View IDは`workbench.view.extensions` | E-02 (VIEWLET_ID) | ○ |
| C-03 | キーボードショートカットCtrl+Shift+X | VSCode標準仕様 | ○ |
| C-04 | VIEWLET_ID定義 | E-02 (19行目) | ○ |
| C-05 | ExtensionsSortByContext定義 | E-01 (74行目) | ○ |
| C-06 | SearchMarketplaceExtensionsContext定義 | E-01 (75行目) | ○ |
| C-07 | SearchHasTextContext定義 | E-01 (76行目) | ○ |
| C-08 | ExtensionsViewletViewsContribution実装 | E-01 (99行目) | ○ |
| C-09 | registerViews処理 | E-01 (115行目) | ○ |
| C-10 | createDefaultExtensionsViewDescriptors | E-01 (168行目) | ○ |
| C-11 | createSearchExtensionsViewDescriptors | E-01 (323行目) | ○ |
| C-12 | createRecommendedExtensionsViewDescriptors | E-01 (125行目) | ○ |
| C-13 | ServerInstalledExtensionsView登録 | E-01 (210行目) | ○ |
| C-14 | DefaultPopularExtensionsView登録 | E-01 (261行目) | ○ |
| C-15 | DefaultRecommendedExtensionsView登録 | E-01 (276行目) | ○ |
| C-16 | SearchMarketplaceExtensionsView登録 | E-01 (329行目) | ○ |
| C-17 | OutdatedExtensionsView登録 | E-01 (380行目) | ○ |
| C-18 | EnabledExtensionsView登録 | E-01 (292行目) | ○ |
| C-19 | DisabledExtensionsView登録 | E-01 (307行目) | ○ |
| C-20 | InstallLocalExtensionsInRemoteAction登録 | E-01 (216行目) | ○ |
| C-21 | アクティビティバーから遷移可能 | E-05 (88行目) | ○ |
| C-22 | 拡張機能から詳細エディタへ遷移 | E-05 (105行目) | ○ |
| C-23 | 機能No.25「拡張機能管理」が主機能 | E-04 (71行目) | ○ |
| C-24 | 機能No.76「カスタマイズ」が補助機能 | E-04 (72行目) | ○ |
| C-25 | SuggestEnabledInput使用 | E-01 (43行目) | ○ |
| C-26 | Marketplace APIとの連携詳細 | **根拠不足** - 外部API仕様参照が必要 | △ |

## 4) 不足情報（Unknown / Missing）
- Visual Studio Marketplace APIの詳細仕様
  - 候補：Marketplace API公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な拡張機能管理UIの説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合
- 1: 中リスク - Marketplace APIは外部依存であり変更可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] 拡張機能検索動作の確認
- [ ] インストール/アンインストール動作の確認
- [ ] 有効化/無効化の動作確認
- [ ] 拡張機能詳細表示の確認
- [ ] 更新通知と適用の動作確認
