---
generated_at: 2026-01-27 12:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-テストビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/testing/browser/testingExplorerView.ts`
- E-02: `src/vs/workbench/contrib/testing/common/testTypes.ts`
- E-03: `src/vs/workbench/contrib/testing/common/testService.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テストビューはViewPane継承クラスである | E-01 (54行目 import, 92行目) | ○ |
| C-02 | View IDは`workbench.view.testing` | E-02 (Testing定数) | ○ |
| C-03 | TestingExplorerViewクラス定義 | E-01 (92行目) | ○ |
| C-04 | TestingExplorerFilter実装 | E-01 (85行目 import, 98行目) | ○ |
| C-05 | viewModel.tree使用 | E-01 (93-94行目, 104行目) | ○ |
| C-06 | TestResultState使用 | E-01 (70行目 import) | ○ |
| C-07 | ITestService依存 | E-01 (117行目) | ○ |
| C-08 | ITestProfileService依存 | E-01 (119行目) | ○ |
| C-09 | ITestingContinuousRunService依存 | E-01 (122行目, 133行目) | ○ |
| C-10 | shouldShowWelcomeメソッド | E-01 (144-146行目) | ○ |
| C-11 | focusメソッドのオーバーライド | E-01 (148-155行目) | ○ |
| C-12 | getTreeIncludeExcludeメソッド | E-01 (163-269行目) | ○ |
| C-13 | TreeProjection / ListProjection | E-01 (77-78行目 import) | ○ |
| C-14 | TestingObjectTree使用 | E-01 (79行目 import) | ○ |
| C-15 | テストツリーの階層表示 | E-01 (76行目 ITestTreeProjection) | ○ |
| C-16 | 継続実行機能 | E-01 (133行目 crService.onDidChange) | ○ |
| C-17 | テスト検出進捗表示 | E-01 (97行目 discoveryProgress) | ○ |
| C-18 | アクティビティバーから遷移可能 | E-06 (89行目) | ○ |
| C-19 | テストからエディタへ遷移 | E-06 (106行目) | ○ |
| C-20 | 機能No.26「テスト」が主機能 | E-05 (73行目) | ○ |
| C-21 | 機能No.67「テスト」が補助機能 | E-05 (74行目) | ○ |
| C-22 | TestRunProfileBitset使用 | E-01 (70行目 import) | ○ |
| C-23 | canUseProfileWithTest判定 | E-01 (66行目 import, 178-180行目) | ○ |
| C-24 | RunOnceScheduler使用 | E-01 (19行目 import) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対して根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なテストUI機能の説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合
- 0: 低リスク - テストサービスとの連携は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] テスト検出動作の確認
- [ ] テスト実行と結果表示の確認
- [ ] フィルタリング機能の動作確認
- [ ] 継続実行機能の動作確認
- [ ] テストからエディタへの遷移確認
