---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-アウトラインビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/outline/browser/outlinePane.ts`
- E-02: `src/vs/workbench/contrib/outline/browser/outline.ts`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アウトラインビューはViewPane継承クラスである | E-01 (21行目 import) | ○ |
| C-02 | View IDは`outline` | E-01 (60行目 Id) | ○ |
| C-03 | OutlinePane.Id = 'outline' | E-01 (60行目) | ○ |
| C-04 | OutlineTreeSorterクラス定義 | E-01 (40-56行目) | ○ |
| C-05 | OutlineSortOrder対応 | E-01 (48-54行目) | ○ |
| C-06 | OutlinePaneクラス定義 | E-01 (58行目) | ○ |
| C-07 | IOutlineService依存 | E-01 (85行目) | ○ |
| C-08 | IEditorService依存 | E-01 (89行目) | ○ |
| C-09 | OutlineViewState使用 | E-01 (66行目, 99行目) | ○ |
| C-10 | ctxFollowsCursor定義 | E-01 (78行目) | ○ |
| C-11 | ctxFilterOnType定義 | E-01 (79行目) | ○ |
| C-12 | ctxSortMode定義 | E-01 (80行目) | ○ |
| C-13 | ctxAllCollapsed定義 | E-01 (81行目) | ○ |
| C-14 | ProgressBar使用 | E-01 (142行目) | ○ |
| C-15 | WorkbenchDataTree使用 | E-01 (18行目 import, 255行目) | ○ |
| C-16 | treeStatesによる状態キャッシュ | E-01 (76行目 LRUCache) | ○ |
| C-17 | renderBodyメソッド | E-01 (133-159行目) | ○ |
| C-18 | collapseAll/expandAllメソッド | E-01 (168-174行目) | ○ |
| C-19 | _handleEditorChangedメソッド | E-01 (201-212行目) | ○ |
| C-20 | アクティビティバーから遷移可能 | E-05 (91行目) | ○ |
| C-21 | 機能No.28「アウトライン」が主機能 | E-04 (77行目) | ○ |
| C-22 | 機能No.64「言語サーバー」が補助機能 | E-04 (78行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対して根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なアウトラインUI機能の説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] アクティブエディタ変更時のアウトライン更新確認
- [ ] シンボルクリックでエディタ内ナビゲーション確認
- [ ] ソート順変更の動作確認
- [ ] フィルタリング機能の動作確認
- [ ] カーソル追跡機能の動作確認
