---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-ターミナルビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/terminal/browser/terminalView.ts`
- E-02: `src/vs/workbench/contrib/terminal/browser/terminal.ts`
- E-03: `src/vs/platform/terminal/common/terminal.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ターミナルビューはViewPane継承クラスである | E-01 (19行目 import) | ○ |
| C-02 | View IDは`workbench.panel.terminal` | E-02 | ○ |
| C-03 | TerminalViewPaneクラス定義 | E-01 (57行目) | ○ |
| C-04 | ITerminalService依存 | E-01 (82行目) | ○ |
| C-05 | ITerminalGroupService依存 | E-01 (84行目) | ○ |
| C-06 | ITerminalProfileService依存 | E-01 (91行目) | ○ |
| C-07 | DropdownWithPrimaryActionViewItem使用 | E-01 (36行目 import, 67行目) | ○ |
| C-08 | TerminalTabbedView使用 | E-01 (31行目 import, 59行目) | ○ |
| C-09 | _initializeTerminal メソッド | E-01 (144-186行目) | ○ |
| C-10 | renderBody メソッド | E-01 (189-235行目) | ○ |
| C-11 | シェル統合機能 | E-01 (122-132行目 ShellIntegration) | ○ |
| C-12 | _gutterDecorationsEnabled | E-01 (139-142行目) | ○ |
| C-13 | TerminalContextKeys使用 | E-01 (42行目 import, 115行目) | ○ |
| C-14 | TerminalCommandId使用 | E-01 (25行目 import) | ○ |
| C-15 | TerminalLocation使用 | E-01 (26行目 import, 170行目) | ○ |
| C-16 | フォント設定監視 | E-01 (204-214行目) | ○ |
| C-17 | 可視性変更ハンドラ | E-01 (215-232行目) | ○ |
| C-18 | プロファイル選択アクション | E-01 (289-300行目) | ○ |
| C-19 | SplitアクションViewItem | E-01 (252-274行目) | ○ |
| C-20 | _createTabsViewメソッド | E-01 (237-242行目) | ○ |
| C-21 | layoutBody メソッド | E-01 (245-248行目) | ○ |
| C-22 | パネルから遷移可能 | E-06 (92行目) | ○ |
| C-23 | 機能No.29「ターミナル」が主機能 | E-05 (79行目) | ○ |
| C-24 | 機能No.68「ターミナル」が補助機能 | E-05 (80行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対して根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なターミナルUI機能の説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] 新規ターミナル作成の動作確認
- [ ] ターミナルの分割表示確認
- [ ] プロファイル選択機能の動作確認
- [ ] シェル統合機能（コマンドデコレーション）の確認
- [ ] リンク検出とアクティベートの動作確認
