---
generated_at: 2026-01-27 12:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-出力ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/output/browser/outputView.ts`
- E-02: `src/vs/workbench/services/output/common/output.ts`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力ビューはFilterViewPane継承クラスである | E-01 (23行目 import) | ○ |
| C-02 | View IDは`workbench.panel.output` | E-02 (OUTPUT_VIEW_ID) | ○ |
| C-03 | OutputViewPaneクラス定義 | E-01 (63行目) | ○ |
| C-04 | OutputEditorクラス定義 | E-01 (229行目) | ○ |
| C-05 | IOutputService依存 | E-01 (87行目) | ○ |
| C-06 | scrollLockContextKey使用 | E-01 (69行目) | ○ |
| C-07 | FilterViewPaneから継承 | E-01 (63行目) | ○ |
| C-08 | フィルタオプション設定 | E-01 (92-99行目) | ○ |
| C-09 | Memento使用 | E-01 (47行目 import, 73行目) | ○ |
| C-10 | panelState状態管理 | E-01 (74行目) | ○ |
| C-11 | showChannelメソッド | E-01 (128-135行目) | ○ |
| C-12 | renderBodyメソッド | E-01 (146-173行目) | ○ |
| C-13 | layoutBodyContentメソッド | E-01 (175-177行目) | ○ |
| C-14 | setInputメソッド | E-01 (186-196行目) | ○ |
| C-15 | createInputメソッド | E-01 (209-211行目) | ○ |
| C-16 | saveStateメソッド | E-01 (213-225行目) | ○ |
| C-17 | AbstractTextResourceEditor継承 | E-01 (229行目) | ○ |
| C-18 | getConfigurationOverrides | E-01 (256-289行目) | ○ |
| C-19 | 読み取り専用エディタ設定 | E-01 (269行目 readOnly: true) | ○ |
| C-20 | パネルから遷移可能 | E-05 (93行目) | ○ |
| C-21 | 機能No.30「出力」が主機能 | E-04 (81行目) | ○ |
| C-22 | 機能No.78「ログ」が補助機能 | E-04 (82行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対して根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な出力UI機能の説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] チャンネル切り替えの動作確認
- [ ] ログフィルタリング機能の動作確認
- [ ] スクロールロック機能の動作確認
- [ ] 出力クリア機能の動作確認
- [ ] ログレベルフィルタの動作確認
