---
generated_at: 2026-01-27 10:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 3-サイドバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ドラッグ&ドロップの詳細実装**：追加確認が必要
  2. **拡張ポイントの最新仕様**：package.json形式の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/sidebar/sidebarPart.ts`
- E-02: `src/vs/workbench/browser/parts/paneCompositePart.ts`
- E-03: `src/vs/workbench/browser/panecomposite.ts`
- E-04: `src/vs/workbench/services/panecomposite/browser/panecomposite.ts`
- E-05: `src/vs/workbench/common/views.ts`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サイドバーは左側または右側に配置可能 | E-01, E-06 | ○ |
| C-02 | SidebarPartクラスが実装 | E-01 | ○ |
| C-03 | AbstractPaneCompositePartを継承 | E-01, E-02 | ○ |
| C-04 | minimumWidth: 170 | E-01 | ○ |
| C-05 | maximumWidth: Number.POSITIVE_INFINITY | E-01 | ○ |
| C-06 | activeViewletSettingsKeyで状態保存 | E-01 | ○ |
| C-07 | workbench.view.explorerがエクスプローラ | E-05 | ○ |
| C-08 | workbench.view.searchが検索 | E-05 | ○ |
| C-09 | workbench.view.scmがソース管理 | E-05 | ○ |
| C-10 | workbench.view.debugがデバッグ | E-05 | ○ |
| C-11 | workbench.view.extensionsが拡張機能 | E-05 | ○ |
| C-12 | openCompositeでビュー切り替え | E-02 | ○ |
| C-13 | onDidPaneCompositeOpenイベント存在 | E-04 | ○ |
| C-14 | onDidPaneCompositeCloseイベント存在 | E-04 | ○ |
| C-15 | workbench.sideBar.location設定 | E-01 | ○ |
| C-16 | PaneCompositeBarでアクティビティバー機能 | E-02 | ○ |
| C-17 | ViewPaneがビューの単位 | E-03 | ○ |
| C-18 | sideBar.backgroundテーマカラー | E-01 | ○ |
| C-19 | sideBarTitle.foregroundテーマカラー | E-01 | ○ |
| C-20 | workbench.action.focusSideBarコマンド | E-01 | ○ |
| C-21 | Parts.SIDEBAR_PARTで識別 | E-01 | ○ |
| C-22 | IPaneCompositePartServiceでアクセス | E-04 | ○ |
| C-23 | ドラッグ&ドロップでビュー並べ替え | **根拠不足** | △ |
| C-24 | 拡張ポイントのJSON形式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ドラッグ&ドロップの実装詳細
  - 候補：viewPane.ts内のドラッグハンドラー / dnd関連のコード
- 拡張ポイントの最新仕様
  - 候補：vscode-extension-schema.json / contributionPoints.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - ビューコンテナIDは正確
- 1: 中リスク - 拡張ポイントは最新仕様の確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ビューコンテナIDが最新と一致するか確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] 拡張ポイントのJSON形式が最新と一致するか確認
- [ ] ドラッグ&ドロップ機能の動作確認
