---
generated_at: 2026-01-27 12:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-問題ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が確認されています

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/markers/browser/markersView.ts`
- E-02: `src/vs/platform/markers/common/markers.ts`
- E-03: `src/vs/workbench/contrib/markers/browser/markersModel.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 問題ビューはFilterViewPane継承クラスである | E-01 (47行目 import) | ○ |
| C-02 | View IDは`workbench.panel.markers` | E-01 (52行目 Markers) | ○ |
| C-03 | MarkersViewクラス定義 | E-01 (109行目) | ○ |
| C-04 | IMarkerService依存 | E-01 (146行目) | ○ |
| C-05 | MarkersModel使用 | E-01 (115行目, 172行目) | ○ |
| C-06 | IProblemsWidgetインターフェース | E-01 (82-107行目) | ○ |
| C-07 | ResourceMarkers型定義 | E-03 (55行目 import) | ○ |
| C-08 | Marker型定義 | E-03 (55行目 import) | ○ |
| C-09 | MarkersFilters使用 | E-01 (58行目 import, 185行目) | ○ |
| C-10 | RangeHighlightDecorations使用 | E-01 (44行目 import, 183行目) | ○ |
| C-11 | FilterViewPaneから継承 | E-01 (109行目) | ○ |
| C-12 | フィルタオプション設定 | E-01 (159-168行目) | ○ |
| C-13 | Memento使用 | E-01 (49行目 import, 157行目) | ○ |
| C-14 | panelState状態管理 | E-01 (131行目) | ○ |
| C-15 | renderBodyメソッド | E-01 (220-247行目) | ○ |
| C-16 | layoutBodyContentメソッド | E-01 (253-261行目) | ○ |
| C-17 | focusメソッド | E-01 (263-275行目) | ○ |
| C-18 | openFileAtElementメソッド | E-01 (300-326行目) | ○ |
| C-19 | showQuickFixesメソッド | E-01 (293-298行目) | ○ |
| C-20 | getTitleメソッド | E-01 (249-251行目) | ○ |
| C-21 | MarkersViewMode対応 | E-01 (52行目 MarkersViewMode) | ○ |
| C-22 | MarkerSeverity使用 | E-01 (37行目 import) | ○ |
| C-23 | ワークスペースストレージ使用 | E-01 (158行目 StorageScope.WORKSPACE) | ○ |
| C-24 | パネルから遷移可能 | E-06 (94行目) | ○ |
| C-25 | 機能No.31「問題」が主機能 | E-05 (83行目) | ○ |
| C-26 | 機能No.79「診断」が補助機能 | E-05 (84行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対して根拠が確認されました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な問題UI機能の説明は根拠が十分
- 0: 低リスク - ビュー構成の説明は実装と整合

## 6) レビュアーチェックリスト（最小）
- [ ] 問題選択で該当箇所へのジャンプ確認
- [ ] 重大度フィルタリングの動作確認
- [ ] テキストフィルタリングの動作確認
- [ ] クイックフィックス機能の動作確認
- [ ] ツリー/テーブル表示切り替えの確認
