---
generated_at: 2026-01-27 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: 4-補助サイドバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **最大化機能の詳細動作**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/auxiliarybar/auxiliaryBarPart.ts`
- E-02: `src/vs/workbench/browser/parts/paneCompositePart.ts`
- E-03: `src/vs/workbench/browser/layout.ts`
- E-04: `src/vs/workbench/common/views.ts`
- E-05: `src/vs/workbench/services/panecomposite/browser/panecomposite.ts`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 補助サイドバーはサイドバーの反対側に配置 | E-01, E-06 | ○ |
| C-02 | AuxiliaryBarPartクラスが実装 | E-01 | ○ |
| C-03 | AbstractPaneCompositePartを継承 | E-01, E-02 | ○ |
| C-04 | minimumWidth: 170 | E-01 | ○ |
| C-05 | maximumWidth: Number.POSITIVE_INFINITY | E-01 | ○ |
| C-06 | activePanelSettingsKeyで状態保存 | E-01 | ○ |
| C-07 | pinnedPanelsKeyでピン留め状態保存 | E-01 | ○ |
| C-08 | Parts.AUXILIARYBAR_PARTで識別 | E-01 | ○ |
| C-09 | ViewContainerLocation.AuxiliaryBarで位置指定 | E-04 | ○ |
| C-10 | openCompositeでビュー切り替え | E-02 | ○ |
| C-11 | onDidPaneCompositeOpenイベント存在 | E-05 | ○ |
| C-12 | onDidPaneCompositeCloseイベント存在 | E-05 | ○ |
| C-13 | preferredWidthで幅優先設定 | E-01 | ○ |
| C-14 | サイドバーとテーマカラー共有 | E-01 | ○ |
| C-15 | サイドバー位置変更に追従 | E-03 | ○ |
| C-16 | workbench.action.focusAuxiliaryBarコマンド存在 | E-01 | ○ |
| C-17 | ビューの移動が可能 | E-04 | ○ |
| C-18 | ViewDescriptorService.moveViewToLocation使用 | E-04 | ○ |
| C-19 | デフォルトは非表示 | E-03 | ○ |
| C-20 | ワークスペースごとにサイズ記憶 | E-01 | ○ |
| C-21 | PaneCompositeBarオプション利用可能 | E-02 | ○ |
| C-22 | 最大化機能でエディタを隠す | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 最大化機能の詳細実装
  - 候補：layout.ts内のtoggleMaximizedAuxiliaryBar() / isAuxiliaryBarMaximized()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - サイドバーとの比較は正確
- 1: 中リスク - 最大化機能は実装確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 補助サイドバーの位置がサイドバー設定に追従するか確認
- [ ] 最大化機能の動作確認
- [ ] ビュー移動機能の動作確認
- [ ] テーマカラーがサイドバーと同一か確認
