---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：41-SCMリポジトリビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御の詳細**：具体的な実装コードが未確認
  2. **エラーメッセージの表示仕様**：例外処理のUI表示が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/scm/browser/scmRepositoriesViewPane.ts`（L1-889）
- E-02: `src/vs/workbench/contrib/scm/common/scm.ts`（型定義）
- E-03: `src/vs/workbench/contrib/scm/browser/scmRepositoryRenderer.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行42）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行92）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCMリポジトリビューは複数リポジトリを一覧表示する | E-01 (L271-311) | ○ |
| C-02 | ビューIDは workbench.scm.views.repositories | E-01 (HISTORY_VIEW_PANE_ID参照箇所) | ○ |
| C-03 | scm.repositories.visible設定で表示数を制御 | E-01 (L461) | ○ |
| C-04 | scm.providerCountBadge設定でバッジ表示を制御 | E-01 (L462, L477-481) | ○ |
| C-05 | ツリー要素にはリポジトリ、アーティファクトグループ、アーティファクトがある | E-01 (L51) TreeElement型定義 | ○ |
| C-06 | ListDelegateで行高さ22pxを返す | E-01 (L55-57) | ○ |
| C-07 | RepositoryTreeDataSourceでgetChildrenを実装 | E-01 (L276-372) | ○ |
| C-08 | アーティファクトプロバイダーからartifactGroupsを取得 | E-01 (L312-317) | ○ |
| C-09 | RepositoryTreeIdentityProviderでIDを生成 | E-01 (L403-417) | ○ |
| C-10 | WorkbenchCompressibleAsyncDataTreeを使用 | E-01 (L559-616) | ○ |
| C-11 | onTreeSelectionChangeでvisibleRepositoriesを更新 | E-01 (L719-731) | ○ |
| C-12 | onTreeContextMenuでコンテキストメニューを表示 | E-01 (L676-717) | ○ |
| C-13 | onTreeDidOpenでアーティファクトコマンドを実行 | E-01 (L668-674) | ○ |
| C-14 | loadTreeViewStateで状態を復元 | E-01 (L864-876) | ○ |
| C-15 | storeTreeViewStateで状態を保存 | E-01 (L878-882) | ○ |
| C-16 | StorageScope.WORKSPACEに保存 | E-01 (L865, L881) | ○ |
| C-17 | ArtifactGroupRendererでアーティファクトグループを描画 | E-01 (L80-135) | ○ |
| C-18 | ArtifactRendererでアーティファクトを描画 | E-01 (L147-269) | ○ |
| C-19 | タイムスタンプはfromNow()で相対表示 | E-01 (L196, L229) | ○ |
| C-20 | selectionModeConfigでmultipleSelectionSupportを制御 | E-01 (L595, L618-621) | ○ |
| C-21 | explorerEnabledConfigでエクスプローラーモードを制御 | E-01 (L277, L503-512) | ○ |
| C-22 | Aria Labelは"Source Control Repositories" | E-01 (L611) | ○ |
| C-23 | 関連機能No.23 ソース管理 | E-05 | ○ |
| C-24 | 関連機能No.74 Git統合（補助） | **根拠なし** | △ |
| C-25 | updateChildrenでツリーを更新 | E-01 (L759-769) | ○ |
| C-26 | Throttlerで更新を制御 | E-01 (L435, L760) | ○ |
| C-27 | 権限による表示制御がある | **根拠なし** | △ |
| C-28 | 無効なツリー要素でErrorをスロー | E-01 (L66-68, L413-415) | ○ |

## 4) 不足情報（Unknown / Missing）
- **権限による表示制御**：具体的な実装コードが確認できず。SCMプロバイダー側の実装に依存する可能性
  - 候補：scm.ts / Git拡張機能 / SCMプロバイダーAPI
- **Git統合機能No.74との関連**：画面機能マッピングに該当レコードなし
  - 候補：別ドキュメント確認 / 画面機能マッピングの更新

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - 権限制御の詳細が未確認（実装依存）

## 6) レビュアーチェックリスト（最小）
- [ ] scm.repositories.visible設定のデフォルト値10が正しいか確認
- [ ] 権限制御の実際の動作をUIで確認
- [ ] Git統合（No.74）との関連を画面機能マッピングと照合
- [ ] エラー時の挙動をデバッグモードで確認
