---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：42-SCM履歴ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ビューIDの正確な値**：HISTORY_VIEW_PANE_IDの定義箇所を確認
  2. **ツリー表示モードの実装**：リスト/ツリー切替の完全な実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/scm/browser/scmHistoryViewPane.ts`（L1-500、部分読み込み）
- E-02: `src/vs/workbench/contrib/scm/common/history.ts`（型定義）
- E-03: `src/vs/workbench/contrib/scm/common/scm.ts`（HISTORY_VIEW_PANE_ID定義）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行43）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行93-94）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCM履歴ビューはGitコミット履歴をグラフ形式で表示 | E-01, E-04 | ○ |
| C-02 | Swimlane形式でブランチグラフを表示 | E-01 (L30 SWIMLANE_WIDTH) | ○ |
| C-03 | PICK_REPOSITORY_ACTION_IDでリポジトリピッカーを起動 | E-01 (L79) | ○ |
| C-04 | PICK_HISTORY_ITEM_REFS_ACTION_IDで参照ピッカーを起動 | E-01 (L80) | ○ |
| C-05 | registerAction2でアクション登録 | E-01 (L163-252) | ○ |
| C-06 | viewChangesアクションでマルチ差分エディタを開く | E-01 (L288-365) | ○ |
| C-07 | openFileアクションでファイルを開く | E-01 (L367-408) | ○ |
| C-08 | ListDelegateで行高さ22pxを返す | E-01 (L411-413) | ○ |
| C-09 | getTemplateIdでテンプレート種別を判定 | E-01 (L416-426) | ○ |
| C-10 | HistoryItemRendererでコミット行を描画 | E-01 (L439+) | ○ |
| C-11 | renderSCMHistoryItemGraphでグラフを描画 | E-01 (L30, L491) | ○ |
| C-12 | badgesConfigでバッジ表示を制御 | E-01 (L458) | ○ |
| C-13 | setListViewModeでリスト表示に切替 | E-01 (L254-269) | ○ |
| C-14 | setTreeViewModeでツリー表示に切替 | E-01 (L271-286) | ○ |
| C-15 | refreshアクションでデータを再取得 | E-01 (L233-252) | ○ |
| C-16 | revealCurrentHistoryItemで現在のコミットに移動 | E-01 (L209-231) | ○ |
| C-17 | Incoming/Outgoing変更を特殊IDで識別 | E-01 (L323, L335, L397-403) | ○ |
| C-18 | fromNow()で相対日時を表示 | E-01 (L49 import) | ○ |
| C-19 | ContextKeysでUI状態を管理 | E-01 (L44 import) | ○ |
| C-20 | 関連機能No.23 ソース管理 | E-05 (行93) | ○ |
| C-21 | 関連機能No.74 Git統合 | E-05 (行94) | ○ |
| C-22 | ScmHistoryItemResolverでマルチ差分URIを生成 | E-01 (L64, L362) | ○ |
| C-23 | ビューIDはHISTORY_VIEW_PANE_ID | E-03, **値未確認** | △ |
| C-24 | ホバーでコミット詳細をツールチップ表示 | E-01 (推定：L481-485) | △ |

## 4) 不足情報（Unknown / Missing）
- **HISTORY_VIEW_PANE_IDの実際の値**：scm.tsからのインポートを確認したが、具体的な文字列値は未読み込み
  - 候補：`src/vs/workbench/contrib/scm/common/scm.ts`の完全読み込み
- **ホバーツールチップの詳細実装**：toHistoryItemHoverContent関数の完全な動作
  - 候補：`src/vs/workbench/contrib/scm/browser/scmHistory.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アクション登録、レンダラー実装の主要部分は確認済み
- 1: 中リスク - ファイル全体の読み込みが不完全（500行まで）

## 6) レビュアーチェックリスト（最小）
- [ ] HISTORY_VIEW_PANE_IDの実際の値を確認
- [ ] scmHistory.tsのrenderSCMHistoryItemGraph関数の詳細を確認
- [ ] ツリー表示モード切替の動作をUIで確認
- [ ] Incoming/Outgoing表示の動作を実機で確認
