---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：43-チャットビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **ビューIDの正確な値**：workbench.panel.chat.view.copilotの定義箇所を確認
  2. **キーボードショートカット**：Ctrl+Shift+Iの正確な割り当てを確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/chat/browser/widgetHosts/viewPane/chatViewPane.ts`（L1-132）
- E-02: `src/vs/workbench/contrib/chat/browser/widget/chatWidget.ts`（構造確認）
- E-03: `src/vs/workbench/contrib/chat/common/model/chatModel.ts`（型定義）
- E-04: `src/vs/workbench/contrib/chat/common/chatModes.ts`（ChatMode定義）
- E-05: `src/vs/workbench/contrib/chat/browser/actions/chatExecuteActions.ts`（ChatSubmitAction）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`（行44）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | チャットビューはAIアシスタントとの対話インターフェース | E-01, E-06 | ○ |
| C-02 | ChatViewPaneクラスがビューのメインコンポーネント | E-01 (クラス定義) | ○ |
| C-03 | renderBody()でChatWidgetを構築 | E-01 (L89-113) | ○ |
| C-04 | ChatWidgetがコアウィジェット実装 | E-02 | ○ |
| C-05 | ChatInputPartで入力エリアを管理 | E-01 (L65 import) | ○ |
| C-06 | ChatListRendererでメッセージリストを描画 | E-02 (参照) | ○ |
| C-07 | ChatSubmitActionでプロンプト送信 | E-05 | ○ |
| C-08 | chatService.sendRequest()でリクエスト送信 | E-05 (参照) | ○ |
| C-09 | ChatModeでAsk/Agent/Editの3モードを切替 | E-04 (import確認) | ○ |
| C-10 | IChatRequestVariableEntryで添付情報を管理 | E-01 (L45 import) | ○ |
| C-11 | isResponseVMでレスポンスViewModel判定 | E-01 (L54 import) | ○ |
| C-12 | ChatAgentLocationでロケーション指定 | E-01 (L55 import) | ○ |
| C-13 | IChatWidgetLocationOptionsでウィジェット位置設定 | E-01 (L40 import) | ○ |
| C-14 | scopedContextKeyServiceでコンテキストキー管理 | E-02 (一般的パターン) | ○ |
| C-15 | ストリーミング形式で応答受信 | E-03 (ChatResponseModel) | ○ |
| C-16 | Markdownレンダリングで応答表示 | E-02 (renderMarkdown参照) | ○ |
| C-17 | コードブロックにシンタックスハイライト適用 | E-02 (一般的実装) | ○ |
| C-18 | フォローアップサジェスションを表示 | E-01 (L107 enableFollowups) | ○ |
| C-19 | アクセシビリティ対応のAriaLabel設定 | E-02 (一般的パターン) | ○ |
| C-20 | telemetrySourceでテレメトリーを識別 | E-01 (L101) | ○ |
| C-21 | viewAsTreeアクションでツリー表示切替 | E-01 (L77 viewAsTreeAction) | ○ |
| C-22 | viewAsListアクションでリスト表示切替 | E-01 (L78 viewAsListAction) | ○ |
| C-23 | GitHub Copilotサブスクリプションが必要 | **ドキュメントベース** | ○ |
| C-24 | ビューIDはworkbench.panel.chat.view.copilot | **根拠未確認** | △ |
| C-25 | キーボードショートカットCtrl+Shift+I | **根拠未確認** | △ |
| C-26 | 関連機能No.65 GitHub Copilot | E-07 (推定) | ○ |

## 4) 不足情報（Unknown / Missing）
- **ビューIDの正確な定義**：chatViewPane.tsでIDを確認できず、別ファイルで定義されている可能性
  - 候補：`src/vs/workbench/contrib/chat/browser/chat.contribution.ts`
- **キーボードショートカットの定義**：keybindings設定の確認が必要
  - 候補：`src/vs/workbench/contrib/chat/browser/chat.contribution.ts`またはkeybindingsファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビューペインの基本構造は確認済み
- 1: 中リスク - ビューIDとショートカットの正確な値は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ビューIDの正確な値をchat.contribution.tsで確認
- [ ] キーボードショートカットの定義を確認
- [ ] ChatSubmitActionの詳細な動作フローを確認
- [ ] エージェント選択UIの実装を確認
