---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：44-インラインチャット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **ガターアイコンの具体的な表示条件**：マーカー監視の詳細ロジックを確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/inlineChat/browser/inlineChatController.ts`（L1-300）
- E-02: `src/vs/workbench/contrib/inlineChat/browser/inlineChatWidget.ts`（L1-300）
- E-03: `src/vs/workbench/contrib/inlineChat/browser/inlineChat.contribution.ts`（L1-119）
- E-04: `src/vs/workbench/contrib/inlineChat/common/inlineChat.ts`（コンテキストキー定義）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行45）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | インラインチャットはエディタ内にAIチャットを表示 | E-05, E-01 | ○ |
| C-02 | InlineChatControllerがエディタコントリビューション | E-03 (L27) | ○ |
| C-03 | EditorContributionInstantiation.Eagerで即座にインスタンス化 | E-03 (L27) | ○ |
| C-04 | InlineChatController.IDは'editor.contrib.inlineChatController' | E-01 (L102) | ○ |
| C-05 | InlineChatZoneWidgetをLazy初期化 | E-01 (L148-216) | ○ |
| C-06 | ChatAgentLocation.EditorInlineでロケーション識別 | E-01 (L153) | ○ |
| C-07 | InlineChatAffordanceでガターインジケーター表示 | E-01 (L146) | ○ |
| C-08 | CTX_INLINE_CHAT_VISIBLEで表示状態管理 | E-01 (L142) | ○ |
| C-09 | renderModeで'zone'または'hover'モードを選択 | E-01 (L144) | ○ |
| C-10 | _currentSessionでセッション状態を管理 | E-01 (L223-228) | ○ |
| C-11 | StartSessionActionでインラインチャットを起動 | E-03 (L88) | ○ |
| C-12 | FocusInlineChatでフォーカス移動 | E-03 (L89) | ○ |
| C-13 | KeepSessionAction2で変更を適用 | E-03 (L29) | ○ |
| C-14 | UndoAndCloseSessionAction2で変更を破棄 | E-03 (L30) | ○ |
| C-15 | ChatSubmitActionでプロンプト送信 | E-03 (L42-51, L68) | ○ |
| C-16 | CancelActionでリクエストキャンセル | E-03 (L71-84) | ○ |
| C-17 | MENU_INLINE_CHAT_WIDGET_STATUSにメニュー登録 | E-03 (L68, L84) | ○ |
| C-18 | editActionMenuItemで"Edit Code"を表示 | E-03 (L38-51) | ○ |
| C-19 | generateActionMenuItemで"Generate"を表示 | E-03 (L53-66) | ○ |
| C-20 | MenuId.ChatEditorInlineGutterにRefactor登録 | E-03 (L100-108) | ○ |
| C-21 | MenuId.ChatEditorInlineGutterにSourceAction登録 | E-03 (L110-118) | ○ |
| C-22 | InlineChatWidgetでUIを構築 | E-02 (L78-93) | ○ |
| C-23 | ChatWidgetを内部で使用 | E-02 (L136-172) | ○ |
| C-24 | scopedContextKeyServiceでコンテキスト管理 | E-02 (L127-134) | ○ |
| C-25 | CTX_INLINE_CHAT_FOCUSEDでフォーカス状態管理 | E-02 (L231) | ○ |
| C-26 | CTX_INLINE_CHAT_RESPONSE_FOCUSEDで応答フォーカス管理 | E-02 (L226) | ○ |
| C-27 | AccessibilityVerbositySettingId.InlineChatでアクセシビリティ設定 | E-02 (L263-264, L287-291) | ○ |
| C-28 | マーカーがある行にスパークルアイコンを表示 | **詳細ロジック未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **ガターインジケーターの詳細ロジック**：InlineChatAffordanceの実装詳細が未読み込み
  - 候補：`src/vs/workbench/contrib/inlineChat/browser/inlineChatAffordance.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラー、ウィジェット、アクションの主要部分は確認済み
- コントリビューション登録も正確に把握

## 6) レビュアーチェックリスト（最小）
- [ ] InlineChatAffordanceのマーカー監視ロジックを確認
- [ ] inlineChat.mode設定の実際の動作をUIで確認
- [ ] Notebook内でのインラインチャット動作を確認
- [ ] アクセシビリティ機能（スクリーンリーダー対応）を確認
