---
generated_at: 2026-01-27 10:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-通知センター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/browser/parts/notifications/notificationsCenter.ts`（L1-388、完全読み込み）
- E-02: `src/vs/workbench/browser/parts/notifications/notificationsList.ts`（L1-200）
- E-03: `src/vs/workbench/common/notifications.ts`（型定義参照）
- E-04: `src/vs/platform/notification/common/notification.ts`（NotificationsFilter）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行46）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NotificationsCenterクラスがThemableを継承 | E-01 (L33) | ○ |
| C-02 | MAX_DIMENSIONSで450x400pxに制限 | E-01 (L35) | ○ |
| C-03 | MAX_NOTIFICATION_SOURCESで最大10件 | E-01 (L37) | ○ |
| C-04 | _onDidChangeVisibilityでイベント発火 | E-01 (L39-40) | ○ |
| C-05 | notificationsCenterVisibleContextKeyでコンテキスト管理 | E-01 (L48, L67) | ○ |
| C-06 | コンストラクタで依存サービスを注入 | E-01 (L52-64) | ○ |
| C-07 | registerListeners()でイベントリスナー登録 | E-01 (L72-76) | ○ |
| C-08 | onDidChangeFilter()でERRORフィルター時に非表示 | E-01 (L78-82) | ○ |
| C-09 | show()で通知センターを表示 | E-01 (L88-135) | ○ |
| C-10 | create()が未作成時のみ実行 | E-01 (L101-104) | ○ |
| C-11 | updateTitle()でタイトル設定 | E-01 (L137-147) | ○ |
| C-12 | 通知0件時に"No new notifications"表示 | E-01 (L141) | ○ |
| C-13 | 通知あり時に"Notifications"表示 | E-01 (L144) | ○ |
| C-14 | ActionBarでツールバー構築 | E-01 (L169-216) | ○ |
| C-15 | NotificationActionRunnerでアクション実行管理 | E-01 (L166) | ○ |
| C-16 | ClearAllNotificationsAction登録 | E-01 (L218-219) | ○ |
| C-17 | ConfigureDoNotDisturbAction登録 | E-01 (L221-222) | ○ |
| C-18 | HideNotificationsCenterAction登録 | E-01 (L224-225) | ○ |
| C-19 | DropdownMenuActionViewItemでDNDドロップダウン | E-01 (L173-211) | ○ |
| C-20 | ToggleDoNotDisturbActionでDND全体切替 | E-01 (L177-180) | ○ |
| C-21 | sortedFiltersでソース別フィルター取得 | E-01 (L182-197) | ○ |
| C-22 | ToggleDoNotDisturbBySourceActionでMore表示 | E-01 (L199-201) | ○ |
| C-23 | NotificationsListで通知リスト表示 | E-01 (L228-230) | ○ |
| C-24 | onDidChangeNotificationでADD/CHANGE/REMOVE処理 | E-01 (L240-292) | ○ |
| C-25 | 通知0件時にhide()呼び出し | E-01 (L284-286) | ○ |
| C-26 | hide()でvisibleクラス削除 | E-01 (L302-303) | ○ |
| C-27 | editorGroupService.activeGroup.focus()でフォーカス復帰 | E-01 (L316-318) | ○ |
| C-28 | updateStyles()でテーマカラー適用 | E-01 (L321-336) | ○ |
| C-29 | layout()でサイズ計算・適用 | E-01 (L338-370) | ○ |
| C-30 | clearAll()で進行中でない通知をclose | E-01 (L373-385) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、実装が完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テーマカラーの適用が正しいか実機で確認
- [ ] Do Not Disturbモードの動作を実機で確認
- [ ] ソース別フィルターの動作を実機で確認
- [ ] 通知のアクセシビリティ（スクリーンリーダー対応）を確認
