---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-コマンドパレット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/quickaccess/browser/commandsQuickAccess.ts`（L1-332、完全読み込み）
- E-02: `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts`（L1-149、完全読み込み）
- E-03: `src/vs/platform/quickinput/browser/commandsQuickAccess.ts`（CommandsHistory）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行48）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CommandsQuickAccessProviderがAbstractEditorCommandsQuickAccessProviderを継承 | E-01 (L44) | ○ |
| C-02 | AI_RELATED_INFORMATION_MAX_PICKSは5 | E-01 (L46) | ○ |
| C-03 | AI_RELATED_INFORMATION_DEBOUNCEは200ms | E-01 (L47) | ○ |
| C-04 | extensionRegistrationRaceで800ms待機 | E-01 (L91) | ○ |
| C-05 | useAiRelatedInfoでAI検索を制御 | E-01 (L55, L116) | ○ |
| C-06 | defaultFilterValueで入力値の保持を制御 | E-01 (L59-65) | ○ |
| C-07 | preserveInputでDEFAULT_LAST設定 | E-01 (L60-61) | ○ |
| C-08 | configurationでpreserveInput, showAskInChatを取得 | E-01 (L96-104) | ○ |
| C-09 | updateOptionsでsuggestedCommandIdsを設定 | E-01 (L106-117) | ○ |
| C-10 | getCommandPicksでコマンド一覧を取得 | E-01 (L119-142) | ○ |
| C-11 | getCodeEditorCommandPicks()を呼び出し | E-01 (L129) | ○ |
| C-12 | getGlobalCommandPicks()を呼び出し | E-01 (L130) | ○ |
| C-13 | 歯車ボタンでpreferencesService.openGlobalKeybindingSettings | E-01 (L138) | ○ |
| C-14 | TriggerAction.CLOSE_PICKERでピッカーを閉じる | E-01 (L139) | ○ |
| C-15 | hasAdditionalCommandPicksでAI検索有無を判定 | E-01 (L144-155) | ○ |
| C-16 | getAdditionalCommandPicksでAI関連ピックを取得 | E-01 (L157-198) | ○ |
| C-17 | timeout()で200msデバウンス | E-01 (L165) | ○ |
| C-18 | showAskInChatでチャット転送オプションを表示 | E-01 (L172-195) | ○ |
| C-19 | CHAT_OPEN_ACTION_IDまたはASK_QUICK_QUESTION_ACTION_IDを使用 | E-01 (L183) | ○ |
| C-20 | getRelatedInformationPicksでAI提案を取得 | E-01 (L200-224) | ○ |
| C-21 | aiRelatedInformationService.getRelatedInformationを呼び出し | E-01 (L201-205) | ○ |
| C-22 | getGlobalCommandPicksでMenuId.CommandPaletteを使用 | E-01 (L229) | ○ |
| C-23 | MenuItemActionからコマンド情報を抽出 | E-01 (L230-232) | ○ |
| C-24 | カテゴリ付きラベルを構築 | E-01 (L241-243) | ○ |
| C-25 | ShowAllCommandsAction.IDはworkbench.action.showCommands | E-01 (L275) | ○ |
| C-26 | F1キーバインドを設定 | E-01 (L284) | ○ |
| C-27 | Ctrl+Shift+Pキーバインドを設定（Firefox以外） | E-01 (L283) | ○ |
| C-28 | ClearCommandHistoryActionで確認ダイアログ | E-01 (L315-319) | ○ |
| C-29 | CommandsHistory.clearHistoryで履歴削除 | E-01 (L326) | ○ |
| C-30 | quickAccessRegistryにプロバイダーを登録 | E-02 (L42-48) | ○ |
| C-31 | contextKeyは'inCommandsPicker' | E-02 (L45) | ○ |
| C-32 | MenuRegistry.appendMenuItemでメニュー登録 | E-02 (L55-108) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、実装が完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 拡張機能登録待機（800ms）の動作を実機で確認
- [ ] AI関連検索機能（実験的）の動作を確認
- [ ] コマンド履歴の保存・復元動作を確認
- [ ] Firefox環境でのキーバインド（Ctrl+Shift+Pが無効）を確認
