---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：48-クイックオープン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ファイル検索プロバイダーの詳細実装**：具体的な実装ファイルの確認
  2. **最近開いたファイルの表示ロジック**：Storage管理の詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/browser/quickaccess.ts`（L1-53）
- E-02: `src/vs/workbench/contrib/quickaccess/browser/quickAccess.contribution.ts`（L1-149）
- E-03: `src/vs/platform/quickinput/browser/helpQuickAccess.ts`（参照）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行49）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HelpQuickAccessProviderを`?`プレフィックスで登録 | E-02 (L23-32) | ○ |
| C-02 | helpQuickAccessPlaceholderメッセージ | E-02 (L26) | ○ |
| C-03 | ViewQuickAccessProviderを`view `プレフィックスで登録 | E-02 (L34-40) | ○ |
| C-04 | contextKeyは'inViewsPicker' | E-02 (L37) | ○ |
| C-05 | viewQuickAccessPlaceholderメッセージ | E-02 (L38) | ○ |
| C-06 | CommandsQuickAccessProviderを`>`プレフィックスで登録 | E-02 (L42-48) | ○ |
| C-07 | contextKeyは'inCommandsPicker' | E-02 (L45) | ○ |
| C-08 | commandsQuickAccessPlaceholderメッセージ | E-02 (L46) | ○ |
| C-09 | MenuId.MenubarViewMenuにShowAllCommandsActionを登録 | E-02 (L55-62) | ○ |
| C-10 | MenuId.MenubarHelpMenuにShowAllCommandsActionを登録 | E-02 (L64-71) | ○ |
| C-11 | MenuId.MenubarGoMenuにgotoLine登録 | E-02 (L82-89) | ○ |
| C-12 | MenuId.GlobalActivityにコマンドパレット登録 | E-02 (L91-98) | ○ |
| C-13 | MenuId.EditorContextにコマンドパレット登録 | E-02 (L100-108) | ○ |
| C-14 | registerAction2でアクション登録 | E-02 (L115-118) | ○ |
| C-15 | inViewsPickerContextKeyでコンテキスト判定 | E-02 (L120-121) | ○ |
| C-16 | quickAccessNavigateNextInViewPickerIdを登録 | E-02 (L124-133) | ○ |
| C-17 | quickAccessNavigatePreviousInViewPickerIdを登録 | E-02 (L135-146) | ○ |
| C-18 | getQuickNavigateHandlerでナビゲーションハンドラを取得 | E-01 (L15) | ○ |
| C-19 | inQuickPickContextでクイックピック表示中を判定 | E-01 (L37) | ○ |
| C-20 | IWorkbenchQuickAccessConfigurationで設定を定義 | E-01 (L40-52) | ○ |
| C-21 | preserveInputオプション | E-01 (L42) | ○ |
| C-22 | showAskInChatオプション | E-01 (L43) | ○ |
| C-23 | デフォルトファイル検索プロバイダー | **詳細実装未確認** | △ |
| C-24 | 最近開いたファイルの表示ロジック | **詳細実装未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **ファイル検索プロバイダー**：デフォルトのファイル検索プロバイダーの実装詳細
  - 候補：`src/vs/workbench/contrib/search/browser/anythingQuickAccess.ts`
- **最近開いたファイル**：ストレージへの保存・読み込みロジック
  - 候補：`src/vs/workbench/contrib/search/browser/recentlyOpenedQuickAccess.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プロバイダー登録とメニュー登録は確認済み
- 1: 中リスク - デフォルトファイル検索の詳細実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトファイル検索プロバイダーの実装を確認
- [ ] 最近開いたファイルのStorage管理を確認
- [ ] プレフィックス切り替えの動作を実機で確認
- [ ] キーボードナビゲーション（Ctrl+Tab等）の動作を確認
