---
generated_at: 2026-01-27 11:10:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-シンボル検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/search/browser/symbolsQuickAccess.ts`（L1-289、完全読み込み）
- E-02: `src/vs/workbench/contrib/search/common/search.ts`（getWorkspaceSymbols参照）
- E-03: `src/vs/editor/common/languages.ts`（SymbolKind, SymbolTag）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行50）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SymbolsQuickAccessProviderがPickerQuickAccessProviderを継承 | E-01 (L33) | ○ |
| C-02 | PREFIXは'#' | E-01 (L35) | ○ |
| C-03 | TYPING_SEARCH_DELAYは200ms | E-01 (L37) | ○ |
| C-04 | TREAT_AS_GLOBAL_SYMBOL_TYPESでグローバルシンボル定義 | E-01 (L39-47) | ○ |
| C-05 | Class, Enum, File, Interface, Namespace, Package, Moduleがグローバル | E-01 (L40-46) | ○ |
| C-06 | ThrottledDelayerで検索を制御 | E-01 (L49) | ○ |
| C-07 | defaultFilterValueでエディタ選択テキストを取得 | E-01 (L51-59) | ○ |
| C-08 | getSelectionSearchStringでテキスト取得 | E-01 (L56) | ○ |
| C-09 | configurationでopenEditorPinned, openSideBySideDirectionを取得 | E-01 (L77-84) | ○ |
| C-10 | _getPicks()でgetSymbolPicks()を呼び出し | E-01 (L86-88) | ○ |
| C-11 | delayer.trigger()で検索をトリガー | E-01 (L91) | ○ |
| C-12 | doGetSymbolPicks()でメイン検索処理 | E-01 (L100-224) | ○ |
| C-13 | pieceToQuery()でシンボルとコンテナクエリを分割 | E-01 (L103-110) | ○ |
| C-14 | getWorkspaceSymbols()でワークスペースシンボル取得 | E-01 (L113) | ○ |
| C-15 | skipLocalでローカルシンボルをスキップ | E-01 (L127-129) | ○ |
| C-16 | scoreFuzzy2()でファジースコアリング | E-01 (L144, L152) | ○ |
| C-17 | labelService.getUriLabel()でパス取得 | E-01 (L162) | ○ |
| C-18 | containerNameとcontainerPathを結合 | E-01 (L164) | ○ |
| C-19 | SymbolTag.Deprecatedで非推奨判定 | E-01 (L187) | ○ |
| C-20 | strikethroughで非推奨表示 | E-01 (L201) | ○ |
| C-21 | SymbolKinds.toIcon()でアイコン取得 | E-01 (L193) | ○ |
| C-22 | openSideBySideDirectionでボタンアイコン決定 | E-01 (L203-205) | ○ |
| C-23 | trigger()でサイドオープン | E-01 (L208-211) | ○ |
| C-24 | accept()でシンボルを開く | E-01 (L213) | ○ |
| C-25 | skipSortingオプションでソートスキップ | E-01 (L219-221) | ○ |
| C-26 | openSymbol()でシンボルを開く | E-01 (L226-254) | ○ |
| C-27 | resolveWorkspaceSymbol()でシンボル解決 | E-01 (L230-231) | ○ |
| C-28 | HTTP/HTTPSはopenerService.open()で開く | E-01 (L239-240) | ○ |
| C-29 | editorService.openEditor()でエディタを開く | E-01 (L245-252) | ○ |
| C-30 | compareSymbols()でスコア→名前→種別ソート | E-01 (L256-288) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、実装が完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各言語のシンボルプロバイダーが正しく動作するか確認
- [ ] 非推奨シンボルの取り消し線表示を確認
- [ ] スペース区切りのコンテナ検索が正しく動作するか確認
- [ ] HTTP/HTTPSシンボル（外部ドキュメント等）のオープンを確認
