---
generated_at: 2026-01-27 10:20:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート: 5-パネル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **PanelAlignment機能の詳細**：実装確認が必要
  2. **拡張ポイントのJSON形式**：最新仕様の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/panel/panelPart.ts`
- E-02: `src/vs/workbench/browser/parts/paneCompositePart.ts`
- E-03: `src/vs/workbench/browser/layout.ts`
- E-04: `src/vs/workbench/common/views.ts`
- E-05: `src/vs/workbench/services/layout/browser/layoutService.ts`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パネルは下部、左側、右側に配置可能 | E-05 | ○ |
| C-02 | PanelPartクラスが実装 | E-01 | ○ |
| C-03 | AbstractPaneCompositePartを継承 | E-01, E-02 | ○ |
| C-04 | activePanelSettingsKeyで状態保存 | E-01 | ○ |
| C-05 | Parts.PANEL_PARTで識別 | E-01 | ○ |
| C-06 | 下部配置時minimumWidth: 0 | E-01 | ○ |
| C-07 | 左右配置時minimumWidth: 300 | E-01 | ○ |
| C-08 | 下部配置時minimumHeight: 77 | E-01 | ○ |
| C-09 | terminalパネルIDが存在 | E-04 | ○ |
| C-10 | workbench.panel.outputパネルIDが存在 | E-04 | ○ |
| C-11 | workbench.panel.markersパネルIDが存在 | E-04 | ○ |
| C-12 | workbench.panel.replパネルIDが存在 | E-04 | ○ |
| C-13 | openCompositeでパネル切り替え | E-02 | ○ |
| C-14 | onDidPaneCompositeOpenイベント存在 | E-02 | ○ |
| C-15 | onDidPaneCompositeCloseイベント存在 | E-02 | ○ |
| C-16 | workbench.panel.defaultLocation設定 | E-05 | ○ |
| C-17 | workbench.panel.opensMaximized設定 | E-05 | ○ |
| C-18 | タブ形式でパネル切り替え | E-01 | ○ |
| C-19 | PaneCompositeBarでタブバー実装 | E-02 | ○ |
| C-20 | panel.backgroundテーマカラー | E-01 | ○ |
| C-21 | panelTitle.activeBorderテーマカラー | E-01 | ○ |
| C-22 | workbench.action.focusPanelコマンド | E-01 | ○ |
| C-23 | 最大化でエディタを隠す | E-03 | ○ |
| C-24 | ダブルクリックで最大化トグル | E-01 | ○ |
| C-25 | PanelAlignment center/left/right/justify | **根拠不足** | △ |
| C-26 | 拡張ポイントのJSON形式詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- PanelAlignment機能の詳細実装
  - 候補：layoutService.ts内のPanelAlignment定義 / panelPart.ts内の配置ロジック
- 拡張ポイントの最新JSON形式
  - 候補：vscode-extension-schema.json / contributionPoints.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - パネルIDは正確
- 1: 中リスク - アラインメント機能は実装確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] パネル位置設定の動作確認
- [ ] パネルアラインメントの動作確認
- [ ] 最大化機能の動作確認
- [ ] 拡張ポイントのJSON形式が最新と一致するか確認
