---
generated_at: 2026-01-27 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-ウェルカムバナー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/vs/workbench/contrib/welcomeBanner/browser/welcomeBanner.contribution.ts`（L1-54、完全読み込み）
- E-02: `src/vs/workbench/services/banner/browser/bannerService.ts`（IBannerService参照）
- E-03: `src/vs/platform/storage/common/storage.ts`（StorageScope, StorageTarget）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行51）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WELCOME_BANNER_DISMISSED_KEYは'workbench.banner.welcome.dismissed' | E-01 (L17) | ○ |
| C-02 | コンストラクタでIBannerService, IStorageService, IBrowserWorkbenchEnvironmentServiceを注入 | E-01 (L20-22) | ○ |
| C-03 | environmentService.options.welcomeBannerを取得 | E-01 (L24) | ○ |
| C-04 | welcomeBanner未定義時は処理終了 | E-01 (L25-27) | ○ |
| C-05 | storageService.getBoolean()でdismissed状態をチェック | E-01 (L29) | ○ |
| C-06 | StorageScope.PROFILEを使用 | E-01 (L29) | ○ |
| C-07 | dismissed時は処理終了 | E-01 (L30-31) | ○ |
| C-08 | アイコンが文字列の場合はThemeIcon.fromId()で変換 | E-01 (L34-35) | ○ |
| C-09 | アイコンがオブジェクトの場合はURI.revive()で変換 | E-01 (L36-37) | ○ |
| C-10 | bannerService.show()でバナーを表示 | E-01 (L40-48) | ○ |
| C-11 | バナーIDは'welcome.banner' | E-01 (L41) | ○ |
| C-12 | welcomeBanner.messageをメッセージとして使用 | E-01 (L42) | ○ |
| C-13 | 変換済みアイコンを使用 | E-01 (L43) | ○ |
| C-14 | welcomeBanner.actionsをアクションとして使用 | E-01 (L44) | ○ |
| C-15 | onCloseでstorageService.store()を呼び出し | E-01 (L45-47) | ○ |
| C-16 | dismissed状態をtrueで保存 | E-01 (L46) | ○ |
| C-17 | StorageTarget.MACHINEを使用 | E-01 (L46) | ○ |
| C-18 | Registryでワークベンチコントリビューションを登録 | E-01 (L52-53) | ○ |
| C-19 | LifecyclePhase.Restoredフェーズで初期化 | E-01 (L53) | ○ |
| C-20 | WorkbenchExtensions.Workbenchに登録 | E-01 (L52) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張がソースコードで確認できました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、実装が完全に確認済み
- コードが54行と小規模で、全体を完全に把握可能

## 6) レビュアーチェックリスト（最小）
- [ ] vscode.devなどでウェルカムバナーの表示を確認
- [ ] バナーを閉じた後に再表示されないことを確認
- [ ] カスタムアイコン（ThemeIcon、URI）の表示を確認
- [ ] アクションボタンの動作を確認
