---
generated_at: 2026-01-27 12:25:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：52-プロセスエクスプローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **Electronプロセス終了の詳細実装**：electron-browser版のkillProcess実装は追加調査推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/processExplorer/browser/processExplorer.contribution.ts`
- E-02: `src/vs/workbench/contrib/processExplorer/browser/processExplorerEditor.ts`
- E-03: `src/vs/workbench/contrib/processExplorer/browser/processExplorerControl.ts`
- E-04: `src/vs/workbench/contrib/processExplorer/browser/processExplorerEditorInput.ts`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロセスエクスプローラーはリソース使用状況監視ツールである | E-05 (画面一覧: "VSCodeプロセスのリソース使用状況表示") | ○ |
| C-02 | ツリー形式でプロセスを表示 | E-03 (100-141行目: ProcessTreeDataSource実装) | ○ |
| C-03 | ヘルプメニューからアクセス可能 | E-01 (163-171行目: MenubarHelpMenuへの登録) | ○ |
| C-04 | コマンドID: workbench.action.openProcessExplorer | E-01 (91行目: OpenProcessExplorer.ID) | ○ |
| C-05 | process-explorer: スキームを使用 | E-04 (20-23行目: RESOURCE定義) | ○ |
| C-06 | Singletonパターンで実装 | E-04 (25-32行目: static instance, 38行目: Singleton capability) | ○ |
| C-07 | デフォルトウィンドウサイズ800x500 | E-01 (94行目: DEFAULT_STATE) | ○ |
| C-08 | CPU、メモリ、PIDを表示 | E-03 (149-155行目: createRow, 178-183行目: ヘッダーラベル) | ○ |
| C-09 | Auxiliaryウィンドウとして表示 | E-01 (112-123行目: AUX_WINDOW_GROUP, auxiliary options) | ○ |
| C-10 | compact=true, alwaysOnTop=true | E-01 (119-120行目: auxiliary options) | ○ |
| C-11 | 1秒間隔で自動更新 | E-03 (337行目: Delayer(1000), 511行目: trigger) | ○ |
| C-12 | ProcessExplorerEditor.ID = 'workbench.editor.processExplorer' | E-02 (17行目: static readonly ID) | ○ |
| C-13 | EditorPaneを継承 | E-02 (15行目: extends EditorPane) | ○ |
| C-14 | BrowserProcessExplorerControlを使用 | E-02 (32行目: BrowserProcessExplorerControl生成) | ○ |
| C-15 | WorkbenchDataTreeでツリー構築 | E-03 (371-383行目: WorkbenchDataTree生成) | ○ |
| C-16 | Kill ProcessでSIGTERM送信 | E-03 (411行目: 'SIGTERM') | ○ |
| C-17 | Force Kill ProcessでSIGKILL送信 | E-03 (412行目: 'SIGKILL') | ○ |
| C-18 | Alt+Eでプロセス終了 | E-03 (392-398行目: KeyCode.KeyE && event.altKey) | ○ |
| C-19 | コピー機能あり | E-03 (417-435行目: copyアクション) | ○ |
| C-20 | Copy All機能あり | E-03 (437-447行目: copyAllアクション) | ○ |
| C-21 | デバッグアタッチ機能あり | E-03 (449-451行目: debugアクション) | ○ |
| C-22 | debug.startFromConfigコマンドで開始 | E-03 (490行目: executeCommand) | ○ |
| C-23 | --inspectフラグでデバッグ可能判定 | E-03 (37-38行目: DEBUG_FLAGS_PATTERN, 460-468行目: isDebuggable) | ○ |
| C-24 | node コマンドでもデバッグ可能 | E-03 (467行目: indexOf('node ')) | ○ |
| C-25 | Web版リモートなしでは利用不可 | E-01 (83行目: precondition supported) | ○ |
| C-26 | リモート接続でDiagnosticInfo取得 | E-03 (581-589行目: getDiagnosticInfo) | ○ |
| C-27 | ProcessExplorerModelでデータ管理 | E-03 (531-560行目: ProcessExplorerModel) | ○ |
| C-28 | アクセシビリティラベル"Process Explorer" | E-03 (288-290行目: getWidgetAriaLabel) | ○ |
| C-29 | ウィンドウ状態の保存キー | E-01 (93行目: STATE_KEY = 'workbench.processExplorerWindowState') | ○ |
| C-30 | StorageScope.APPLICATION使用 | E-01 (134行目, 157行目: StorageScope.APPLICATION) | ○ |
| C-31 | アイコン: serverProcess | E-04 (14行目: Codicon.serverProcess) | ○ |
| C-32 | electron-browser版でkillProcess実装 | **根拠なし** - electron-browser版の詳細実装は未読込 | △ |

## 4) 不足情報（Unknown / Missing）
- **electron-browser版のkillProcess詳細実装**：browser版ではkillProcessメソッドは抽象メソッドであり、実際の実装はelectron-browser版にある
  - 候補：`src/vs/workbench/contrib/processExplorer/electron-browser/processExplorerControl.ts`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な画面仕様は全てソースコードで確認済み
- 0: 低リスク - コマンドIDとメニュー登録は明確に確認
- 0: 低リスク - データ構造とツリーレンダリングは明確
- 0: 低リスク - デバッグアタッチのロジックは確認済み
- 1: 中リスク - プロセス終了の実際の実装はElectron側で要確認

## 6) レビュアーチェックリスト（最小）
- [x] コマンドID `workbench.action.openProcessExplorer` が正しいか
- [x] メニュー登録が `MenubarHelpMenu` の `5_tools` グループであることを確認
- [x] ProcessExplorerEditorInput.IDが正しいか
- [x] Singletonパターンの実装を確認
- [x] 更新間隔が1000ms（1秒）であることを確認
- [x] デフォルトウィンドウサイズ800x500を確認
- [ ] electron-browser版のkillProcess実装を確認
- [ ] 実際のAuxiliaryウィンドウ動作を確認
