---
generated_at: 2026-01-27 12:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：53-スプラッシュ画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **index.html/bootstrapでのスプラッシュ生成**：partsSplash.tsでは削除処理のみ確認、生成はbootstrap側で要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/workbench/contrib/splash/browser/splash.ts`
- E-02: `src/vs/workbench/contrib/splash/browser/partsSplash.ts`
- E-03: `src/vs/workbench/contrib/splash/browser/splash.contribution.ts`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スプラッシュ画面は起動時に表示される | E-04 (画面一覧: "起動時のスプラッシュスクリーン") | ○ |
| C-02 | 前回のレイアウト情報を使用して骨格を描画 | E-02 (92-102行目: layoutInfo保存) | ○ |
| C-03 | DOM要素ID: monaco-parts-splash | E-02 (30行目: _splashElementId) | ○ |
| C-04 | localStorageに保存 | E-03 (18行目: localStorage.setItem) | ○ |
| C-05 | ストレージキー: monaco-parts-splash | E-03 (18行目: 'monaco-parts-splash') | ○ |
| C-06 | PartsSplash.ID = 'workbench.contrib.partsSplash' | E-02 (28行目: static readonly ID) | ○ |
| C-07 | WorkbenchPhase.BlockStartupで登録 | E-03 (26行目: WorkbenchPhase.BlockStartup) | ○ |
| C-08 | onDidLayoutMainContainerでスプラッシュ削除 | E-02 (45-48行目: Event.once) | ○ |
| C-09 | パフォーマンスマーク: code/didRemovePartsSplash | E-02 (47行目: perf.mark) | ○ |
| C-10 | initialShellColorsクラスのstyle要素を削除 | E-02 (119-120行目: getElementsByClassName, remove) | ○ |
| C-11 | LifecyclePhase.Restored後に保存処理開始 | E-02 (54-57行目: lifecycleService.when) | ○ |
| C-12 | フルスクリーン変更時に保存 | E-02 (55行目: onDidChangeFullscreen) | ○ |
| C-13 | エディタグループレイアウト変更時に保存 | E-02 (55行目: editorGroupsService.mainPart.onDidLayout) | ○ |
| C-14 | テーマカラー変更時に保存 | E-02 (55行目: _themeService.onDidColorThemeChange) | ○ |
| C-15 | タイトルバースタイル変更時に保存 | E-02 (59-64行目: affectsConfiguration TitleBarSetting) | ○ |
| C-16 | zoomLevelを保存 | E-02 (75行目: configService.getValue) | ○ |
| C-17 | baseThemeを保存 | E-02 (76行目: getThemeTypeSelector) | ○ |
| C-18 | colorInfoにforeground色を含む | E-02 (78行目: foreground) | ○ |
| C-19 | colorInfoにeditorBackground色を含む | E-02 (80行目: editorBackground) | ○ |
| C-20 | colorInfoにtitleBarBackground色を含む | E-02 (81行目: titleBarBackground) | ○ |
| C-21 | layoutInfoにsideBarSideを含む | E-02 (93行目: sideBarSide) | ○ |
| C-22 | layoutInfoにtitleBarHeightを含む | E-02 (95行目: titleBarHeight) | ○ |
| C-23 | layoutInfoにactivityBarWidthを含む | E-02 (96行目: activityBarWidth) | ○ |
| C-24 | layoutInfoにsideBarWidthを含む | E-02 (97行目: sideBarWidth) | ○ |
| C-25 | layoutInfoにstatusBarHeightを含む | E-02 (99行目: statusBarHeight) | ○ |
| C-26 | フルスクリーン時はlayoutInfoを保存しない | E-02 (106-108行目: !isFullscreen) | ○ |
| C-27 | 拡張機能開発モード時はlayoutInfoを保存しない | E-02 (107行目: !isExtensionDevelopment) | ○ |
| C-28 | タイトルバースタイル変更後はlayoutInfoを保存しない | E-02 (107行目: !_didChangeTitleBarStyle) | ○ |
| C-29 | 補助サイドバー最大化時はNumber.MAX_SAFE_INTEGER | E-02 (98行目: Number.MAX_SAFE_INTEGER) | ○ |
| C-30 | index.html/bootstrapでスプラッシュDOM生成 | **根拠なし** - partsSplash.tsは削除処理のみ、生成処理は別ファイル | △ |

## 4) 不足情報（Unknown / Missing）
- **スプラッシュDOM生成のコード**：partsSplash.tsではスプラッシュの削除処理（_removePartsSplash）のみが実装されており、初期DOM生成はブートストラップ処理またはindex.htmlで行われている
  - 候補：`src/vs/code/browser/workbench/workbench.html` / ブートストラップスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スプラッシュデータの保存処理は明確に確認済み
- 0: 低リスク - 削除タイミングとパフォーマンスマークは確認済み
- 0: 低リスク - 各種カラー情報とレイアウト情報の保存項目は網羅的に確認
- 1: 中リスク - スプラッシュDOM生成のコードは追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [x] PartsSplash.IDが正しいか
- [x] WorkbenchPhase.BlockStartupで登録されていることを確認
- [x] localStorageキー 'monaco-parts-splash' が正しいか
- [x] DOM要素ID 'monaco-parts-splash' が正しいか
- [x] パフォーマンスマーク 'code/didRemovePartsSplash' が正しいか
- [x] colorInfoの全カラーキーを確認
- [x] layoutInfoの全項目を確認
- [ ] ブートストラップでのスプラッシュDOM生成コードを確認
- [ ] 実際の起動時のスプラッシュ表示を確認
