---
generated_at: 2026-01-27 10:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 6-ステータスバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **拡張API例の詳細**：APIバージョン確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/statusbar/statusbarPart.ts`
- E-02: `src/vs/workbench/services/statusbar/browser/statusbar.ts`
- E-03: `src/vs/platform/statusbar/common/statusbar.ts`
- E-04: `src/vs/workbench/browser/layout.ts`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ステータスバーは最下部に配置 | E-01, E-05 | ○ |
| C-02 | StatusbarPartクラスが実装 | E-01 | ○ |
| C-03 | Partクラスを継承 | E-01 | ○ |
| C-04 | IStatusbarServiceを実装 | E-01, E-02 | ○ |
| C-05 | minimumHeight: 22 | E-01 | ○ |
| C-06 | maximumHeight: 22 | E-01 | ○ |
| C-07 | leftItemsContainerとrightItemsContainerに分割 | E-01 | ○ |
| C-08 | StatusbarEntryItemで項目管理 | E-01 | ○ |
| C-09 | createEntryで項目作成 | E-02 | ○ |
| C-10 | updateEntryで項目更新 | E-02 | ○ |
| C-11 | StatusbarAlignmentでLEFT/RIGHT指定 | E-03 | ○ |
| C-12 | priorityで表示順序制御 | E-03 | ○ |
| C-13 | workbench.statusBar.visible設定 | E-04 | ○ |
| C-14 | statusBar.backgroundテーマカラー | E-01 | ○ |
| C-15 | statusBar.debuggingBackgroundテーマカラー | E-01 | ○ |
| C-16 | statusBar.noFolderBackgroundテーマカラー | E-01 | ○ |
| C-17 | statusBarItem.errorBackgroundテーマカラー | E-01 | ○ |
| C-18 | IStatusbarEntryインターフェース定義 | E-03 | ○ |
| C-19 | text, tooltip, command等のプロパティ | E-03 | ○ |
| C-20 | showBeakでビーク表示 | E-03 | ○ |
| C-21 | onDidChangeEntryVisibilityイベント | E-02 | ○ |
| C-22 | Parts.STATUSBAR_PARTで識別 | E-01 | ○ |
| C-23 | コンテキストメニューで項目表示切り替え | E-01 | ○ |
| C-24 | 拡張API vscode.window.createStatusBarItem | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 拡張API例の詳細
  - 候補：vscode.d.ts内のStatusBarItem定義 / 拡張機能APIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - テーマカラーの記述は正確
- 0: 低リスク - インターフェース定義は正確

## 6) レビュアーチェックリスト（最小）
- [ ] ステータスバー項目IDが最新と一致するか確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] 拡張API例が最新バージョンと一致するか確認
- [ ] 高さ固定値(22)が最新と一致するか確認
