---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート: 7-アクティビティバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **拡張ポイントのJSON形式**：最新仕様の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/activitybar/activitybarPart.ts`（行1-619）
- E-02: `src/vs/workbench/browser/parts/paneCompositeBar.ts`
- E-03: `src/vs/workbench/browser/parts/globalCompositeBar.ts`
- E-04: `src/vs/workbench/services/layout/browser/layoutService.ts`
- E-05: `src/vs/workbench/common/theme.ts`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクティビティバーはビューコンテナ切り替え用 | E-01, E-06 | ○ |
| C-02 | ActivitybarPartクラスが実装 | E-01 行42 | ○ |
| C-03 | Partクラスを継承 | E-01 行42 | ○ |
| C-04 | ACTION_HEIGHT: 48 | E-01 行44 | ○ |
| C-05 | minimumWidth: 48 | E-01 行52 | ○ |
| C-06 | maximumWidth: 48 | E-01 行53 | ○ |
| C-07 | pinnedViewContainersKeyで状態保存 | E-01 行46 | ○ |
| C-08 | ActivityBarCompositeBarでアイコン管理 | E-01 行193 | ○ |
| C-09 | GlobalCompositeBarで設定/アカウント管理 | E-01 行200, E-03 | ○ |
| C-10 | CustomMenubarControlでコンパクトメニュー | E-01 行20, 277-291 | ○ |
| C-11 | ActionsOrientation.VERTICALで縦配置 | E-01 行78 | ○ |
| C-12 | iconSize: 24 | E-01 行80 | ○ |
| C-13 | compositeSize: 52 | E-01 行87 | ○ |
| C-14 | workbench.activityBar.location設定 | E-01 行396, E-04 | ○ |
| C-15 | ActivityBarPosition.DEFAULT位置 | E-01 行396 | ○ |
| C-16 | ActivityBarPosition.TOP位置 | E-01 行422 | ○ |
| C-17 | ActivityBarPosition.BOTTOM位置 | E-01 行448 | ○ |
| C-18 | ActivityBarPosition.HIDDEN位置 | E-01 行474 | ○ |
| C-19 | activityBar.backgroundテーマカラー | E-01 行16, E-05 | ○ |
| C-20 | activityBar.foregroundテーマカラー | E-01 行16, E-05 | ○ |
| C-21 | activityBar.activeBorderテーマカラー | E-01 行16, E-05 | ○ |
| C-22 | activityBarBadge.backgroundテーマカラー | E-01 行16, E-05 | ○ |
| C-23 | Parts.ACTIVITYBAR_PARTで識別 | E-01 行69 | ○ |
| C-24 | getPinnedPaneCompositeIdsメソッド | E-01 行113 | ○ |
| C-25 | getVisiblePaneCompositeIdsメソッド | E-01 行117 | ○ |
| C-26 | workbench.action.focusActivityBarコマンド | E-01 行530 | ○ |
| C-27 | HoverPositionでツールチップ位置制御 | E-01 行82-84 | ○ |
| C-28 | 拡張ポイントのJSON形式詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 拡張ポイントの最新JSON形式
  - 候補：vscode-extension-schema.json / contributionPoints.ts

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - テーマカラーの記述は正確
- 0: 低リスク - 位置設定の記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] アクティビティバー位置設定の動作確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] 拡張ポイントのJSON形式が最新と一致するか確認
- [ ] グローバルアクション（設定/アカウント）の動作確認
