---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート: 8-バナー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **使用例の詳細確認**：実際のバナーIDの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/banner/bannerPart.ts`
- E-02: `src/vs/workbench/services/banner/browser/bannerService.ts`
- E-03: `src/vs/platform/banner/common/banner.ts`
- E-04: `src/vs/workbench/browser/layout.ts`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バナーはタイトルバー直下に配置 | E-01, E-04, E-05 | ○ |
| C-02 | BannerPartクラスが実装 | E-01 | ○ |
| C-03 | Partクラスを継承 | E-01 | ○ |
| C-04 | IBannerServiceを実装 | E-01, E-02 | ○ |
| C-05 | 表示時の高さ: 26px | E-01 | ○ |
| C-06 | 非表示時の高さ: 0px | E-01 | ○ |
| C-07 | Parts.BANNER_PARTで識別 | E-01 | ○ |
| C-08 | show()メソッドでバナー表示 | E-02 | ○ |
| C-09 | hide()メソッドでバナー非表示 | E-02 | ○ |
| C-10 | IBannerItemインターフェースで内容定義 | E-03 | ○ |
| C-11 | id, icon, message, actionsプロパティ | E-03 | ○ |
| C-12 | onCloseコールバック | E-03 | ○ |
| C-13 | banner.backgroundテーマカラー | E-01 | ○ |
| C-14 | banner.foregroundテーマカラー | E-01 | ○ |
| C-15 | banner.iconForegroundテーマカラー | E-01 | ○ |
| C-16 | ActionBarでクローズボタン実装 | E-01 | ○ |
| C-17 | _onDidChangeSizeイベント発火 | E-01 | ○ |
| C-18 | 同一IDのバナーは再表示しない | E-01 | ○ |
| C-19 | ariaLabelでアクセシビリティ対応 | E-03 | ○ |
| C-20 | 使用例（制限モード/更新通知）のバナーID | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 使用例のバナーIDの正確性
  - 候補：workspaceTrust.ts / updateService.ts内のバナー呼び出し確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - インターフェース定義は正確
- 0: 低リスク - テーマカラーの記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] バナーの高さ（26px）が最新と一致するか確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] 使用例のバナーIDが実際のコードと一致するか確認
- [ ] IBannerItemインターフェースが最新と一致するか確認
