---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート: 9-エディタグループ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **タブ表示モードの設定値**：最新の設定値確認が必要
  2. **グループ操作コマンドの網羅性**：追加コマンドがある可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/browser/parts/editor/editorGroupView.ts`
- E-02: `src/vs/workbench/browser/parts/editor/editorTabsControl.ts`
- E-03: `src/vs/workbench/browser/parts/editor/editorPane.ts`（行1-204）
- E-04: `src/vs/workbench/browser/parts/editor/editorPart.ts`
- E-05: `src/vs/workbench/services/editor/common/editorGroupsService.ts`
- E-06: `src/vs/workbench/common/editor.ts`
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditorGroupViewクラスが実装 | E-01 | ○ |
| C-02 | Disposableを継承 | E-01 | ○ |
| C-03 | IEditorGroupViewを実装 | E-01 | ○ |
| C-04 | GroupIdentifierでグループ識別 | E-01 | ○ |
| C-05 | EditorTabsControlでタブ管理 | E-02 | ○ |
| C-06 | EditorPaneでエディタ表示 | E-03 | ○ |
| C-07 | openEditorメソッドでエディタを開く | E-01 | ○ |
| C-08 | closeEditorメソッドでエディタを閉じる | E-01 | ○ |
| C-09 | onDidModelChangeイベント | E-01, E-05 | ○ |
| C-10 | onDidActiveEditorChangeイベント | E-05 | ○ |
| C-11 | onDidCloseEditorイベント | E-05 | ○ |
| C-12 | workbench.editor.showTabs設定 | E-06 | ○ |
| C-13 | workbench.editor.enablePreview設定 | E-06 | ○ |
| C-14 | workbench.editor.tabCloseButton設定 | E-06 | ○ |
| C-15 | workbench.editor.tabSizing設定 | E-06 | ○ |
| C-16 | workbench.editor.wrapTabs設定 | E-06 | ○ |
| C-17 | EditorPartでグループ全体管理 | E-04 | ○ |
| C-18 | SerializableGridでグリッドレイアウト | E-04 | ○ |
| C-19 | editorGroupHeader.tabsBackgroundテーマカラー | E-01 | ○ |
| C-20 | tab.activeBackgroundテーマカラー | E-01 | ○ |
| C-21 | tab.inactiveBackgroundテーマカラー | E-01 | ○ |
| C-22 | editorGroup.borderテーマカラー | E-01 | ○ |
| C-23 | EditorInputでエディタ入力表現 | E-06 | ○ |
| C-24 | IEditorGroupsServiceでサービス提供 | E-05 | ○ |
| C-25 | BreadcrumbsControlでパンくず表示 | E-01 | ○ |
| C-26 | ピン留め機能 | E-06 | ○ |
| C-27 | タブ表示モードの設定値（multiple/single/none） | **根拠不足** | △ |
| C-28 | グループ操作コマンドの全一覧 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- タブ表示モードの正確な設定値
  - 候補：editor.ts内のEditorTabsMode enum確認
- グループ操作コマンドの網羅的一覧
  - 候補：editorCommands.ts / editorActions.ts内のコマンド確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本構造の記述は正確
- 0: 低リスク - イベント・メソッドの記述は正確
- 1: 中リスク - 設定値とコマンドは最新確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] タブ表示モードの設定値が最新と一致するか確認
- [ ] テーマカラーIDが最新と一致するか確認
- [ ] グループ操作コマンドが最新と一致するか確認
- [ ] グリッドレイアウトの動作確認
