---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 39
  claims_with_evidence: 39
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：39 / 39、根拠なし：0
- 優先レビュー（高）
  1. **IT-034 ブラウザ統合テスト**：テスト実装はあるが、実際のテスト環境構築手順は確認が必要
  2. **IT-035 MCP連携テスト**：MCPプロトコルの仕様理解が必要
  3. **IT-028 ローカライズテスト**：外部言語パック依存のため実行環境の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/smoke/src/areas/extensions/extensions.test.ts`
- E-02: `test/smoke/src/areas/workbench/data-loss.test.ts`
- E-03: `test/smoke/src/areas/terminal/terminal.test.ts`
- E-04: `test/smoke/src/areas/terminal/terminal-editors.test.ts`
- E-05: `test/smoke/src/areas/terminal/terminal-persistence.test.ts`
- E-06: `test/smoke/src/areas/terminal/terminal-input.test.ts`
- E-07: `test/smoke/src/areas/preferences/preferences.test.ts`
- E-08: `test/smoke/src/areas/search/search.test.ts`
- E-09: `test/smoke/src/areas/languages/languages.test.ts`
- E-10: `test/smoke/src/areas/chat/chat.test.ts`
- E-11: `test/smoke/src/areas/multiroot/multiroot.test.ts`
- E-12: `test/smoke/src/areas/workbench/localization.test.ts`
- E-13: `test/smoke/src/areas/accessibility/accessibility.test.ts`
- E-14: `test/integration/browser/src/index.ts`
- E-15: `test/mcp/src/stdio.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: 拡張機能のインストールと有効化テスト | E-01 | ○ |
| C-02 | IT-002: 開いたエディタの復元検証テスト | E-02 | ○ |
| C-03 | IT-003: エディタの保存と復元テスト | E-02 | ○ |
| C-04 | IT-004: Hot Exit機能（遅延なし）テスト | E-02 | ○ |
| C-05 | IT-005: Hot Exit機能（遅延あり）テスト | E-02 | ○ |
| C-06 | IT-006: シャットダウン時の自動保存テスト | E-02 | ○ |
| C-07 | IT-007: Stableバージョンからのエディタ復元テスト | E-02 | ○ |
| C-08 | IT-008: ターミナルエディタの色変更テスト | E-04 | ○ |
| C-09 | IT-009: ターミナルタブの名前変更テスト | E-04 | ○ |
| C-10 | IT-010: ターミナルをパネルに移動テスト | E-04 | ○ |
| C-11 | IT-011: ターミナルの横分割テスト | E-04 | ○ |
| C-12 | IT-012: ターミナルセッションのデタッチ/アタッチテスト | E-05 | ○ |
| C-13 | IT-013: ターミナル自動応答テスト | E-06 | ○ |
| C-14 | IT-014: 行番号設定のライブ反映テスト | E-07 | ○ |
| C-15 | IT-015: 設定変更インジケーター表示テスト | E-07 | ○ |
| C-16 | IT-016: ワークスペース内検索テスト | E-08 | ○ |
| C-17 | IT-017: ファイルタイプフィルター検索テスト | E-08 | ○ |
| C-18 | IT-018: 検索結果の除外テスト | E-08 | ○ |
| C-19 | IT-019: Quick Openでのファイル検索テスト | E-08 | ○ |
| C-20 | IT-020: ファジーマッチでのファイル検索テスト | E-08 | ○ |
| C-21 | IT-021: JavaScriptクイックアウトラインテスト | E-09 | ○ |
| C-22 | IT-022: CSSクイックアウトラインテスト | E-09 | ○ |
| C-23 | IT-023: CSS問題ビュー表示テスト | E-09 | ○ |
| C-24 | IT-024: CSS lint設定の反映テスト | E-09 | ○ |
| C-25 | IT-025: AI機能の無効化テスト | E-10 | ○ |
| C-26 | IT-026: マルチルートワークスペースでの検索テスト | E-11 | ○ |
| C-27 | IT-027: ワークスペース名のタイトル表示テスト | E-11 | ○ |
| C-28 | IT-028: ドイツ語ローカライズの検証テスト | E-12 | ○ |
| C-29 | IT-029: ワークベンチアクセシビリティ違反チェックテスト | E-13 | ○ |
| C-30 | IT-030: Activity Barアクセシビリティ検証テスト | E-13 | ○ |
| C-31 | IT-031: サイドバーアクセシビリティ検証テスト | E-13 | ○ |
| C-32 | IT-032: ステータスバーアクセシビリティ検証テスト | E-13 | ○ |
| C-33 | IT-033: チャットパネルアクセシビリティ検証テスト | E-13 | ○ |
| C-34 | IT-034: ブラウザでの拡張機能テストテスト | E-14 | ○ |
| C-35 | IT-035: MCPサーバー接続テスト | E-15 | ○ |
| C-36 | IT-036: ターミナルデフォルト位置の設定テスト | E-04 | ○ |
| C-37 | IT-037: ターミナルの複数作成テスト | E-04 | ○ |
| C-38 | IT-038: プラスボタンでのターミナル作成テスト | E-04 | ○ |
| C-39 | IT-039: 分割ボタンでのターミナル作成テスト | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- すべてのテストケースにソースコードの根拠が存在
- 一部のテストケースは `it.skip` でスキップされているが、テストケースとしては定義されている
  - Notebook関連テスト（kernel未対応）
  - Terminal一部テスト（Linux環境でのptyホスト問題）
  - Accessibility一部テスト（Web環境制約）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて抽出されている
- **1: 中リスク** - 一部のテストがプラットフォーム依存でスキップされる可能性あり
  - Linux環境でのターミナルテスト
  - Web環境でのアクセシビリティテスト
- **0: 低リスク** - テストケースの網羅性は既存のスモークテストスイートに依存

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースのテスト種別分類が適切か確認
- [ ] 優先度の設定が業務要件と整合しているか確認
- [ ] 前提条件とテスト手順が実行可能な形式で記述されているか確認
- [ ] 期待結果が検証可能な形式で記述されているか確認
- [ ] スキップされているテスト（it.skip）の扱いについて検討
- [ ] プラットフォーム固有の制約事項が明確に記載されているか確認
