---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 45
  claims_without_evidence: 5
confidence_derived: 0.90
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：45 / 50、根拠なし：5
- 優先レビュー（高）
  1. **C-31**：undoRedoService.warningの詳細な警告パターンの特定が必要
  2. **C-33**：GPU関連警告の具体的なメッセージ内容の確認が必要
  3. **C-36**：ローカライゼーション通知の詳細一覧化が必要
  4. **C-39**：更新通知の全パターンの網羅確認が必要
  5. **C-42**：リモートトンネル通知の全パターンの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/vs/platform/notification/common/notification.ts`
- E-02: `src/vs/workbench/common/notifications.ts`
- E-03: `src/vs/workbench/services/notification/common/notificationService.ts`
- E-04: `src/vs/workbench/browser/parts/notifications/notificationsCommands.ts`
- E-05: `src/vs/workbench/browser/parts/notifications/notificationsActions.ts`
- E-06: `src/vs/editor/contrib/find/browser/findController.ts`
- E-07: `src/vs/editor/contrib/rename/browser/rename.ts`
- E-08: `src/vs/editor/contrib/links/browser/links.ts`
- E-09: `src/vs/workbench/services/preferences/browser/preferencesService.ts`
- E-10: `src/vs/workbench/services/textfile/common/textFileEditorModelManager.ts`
- E-11: `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts`
- E-12: `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts`
- E-13: `src/vs/workbench/services/extensions/common/abstractExtensionService.ts`
- E-14: `src/vs/workbench/services/dialogs/browser/simpleFileDialog.ts`
- E-15: `src/vs/workbench/contrib/debug/browser/debugService.ts`
- E-16: `src/vs/workbench/contrib/debug/browser/callStackWidget.ts`
- E-17: `src/vs/workbench/services/userDataSync/browser/userDataSyncWorkbenchService.ts`
- E-18: `src/vs/workbench/contrib/userDataSync/browser/userDataSync.ts`
- E-19: `src/vs/workbench/contrib/testing/common/testServiceImpl.ts`
- E-20: `src/vs/workbench/contrib/testing/browser/testingOutputPeek.ts`
- E-21: `src/vs/workbench/contrib/comments/browser/commentsController.ts`
- E-22: `src/vs/workbench/api/browser/mainThreadAuthentication.ts`
- E-23: `src/vs/platform/undoRedo/common/undoRedoService.ts`
- E-24: `src/vs/workbench/services/textMate/browser/textMateTokenizationFeatureImpl.ts`
- E-25: `src/vs/workbench/contrib/preferences/browser/keybindingsEditor.ts`
- E-26: `src/vs/workbench/services/integrity/electron-browser/integrityService.ts`
- E-27: `src/vs/workbench/contrib/localization/electron-browser/localization.contribution.ts`
- E-28: `src/vs/workbench/electron-browser/window.ts`
- E-29: `src/vs/workbench/contrib/welcomeWalkthrough/browser/walkThroughPart.ts`
- E-30: `src/vs/workbench/contrib/update/browser/update.ts`
- E-31: `src/vs/workbench/contrib/mcp/browser/mcpMigration.ts`
- E-32: `src/vs/workbench/contrib/mergeEditor/browser/view/viewModel.ts`
- E-33: `src/vs/workbench/contrib/search/browser/searchView.ts`
- E-34: `src/vs/workbench/api/browser/mainThreadTreeViews.ts`
- E-35: `src/vs/workbench/services/clipboard/browser/clipboardService.ts`
- E-36: `src/vs/workbench/services/editor/browser/editorResolverService.ts`
- E-37: `src/vs/workbench/services/secrets/electron-browser/secretStorageService.ts`
- E-38: `src/vs/workbench/services/configuration/common/configurationEditing.ts`
- E-39: `src/vs/workbench/services/workspaces/browser/abstractWorkspaceEditingService.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | severityPrefix.error | E-01 | ○ |
| C-02 | severityPrefix.warning | E-01 | ○ |
| C-03 | severityPrefix.info | E-01 | ○ |
| C-04 | too.large.for.replaceall | E-06 | ○ |
| C-05 | rename.failedApply | E-07 | ○ |
| C-06 | rename.failed | E-07 | ○ |
| C-07 | invalid.url | E-08 | ○ |
| C-08 | missing.url | E-08 | ○ |
| C-09 | openFolderFirst | E-09 | ○ |
| C-10 | genericSaveError | E-10 | ○ |
| C-11 | extensionsDisabled | E-11 | ○ |
| C-12 | extensionService.crash | E-12, E-13 | ○ |
| C-13 | resolverExtensionNotFound | E-12 | ○ |
| C-14 | unknownDep | E-13 | ○ |
| C-15 | getEnvironmentFailure | E-12 | ○ |
| C-16 | remoteFileDialog.notConnectedToRemote | E-14 | ○ |
| C-17 | debugAdapterCrash | E-15 | ○ |
| C-18 | failedToLoadFrames | E-16 | ○ |
| C-19 | sync turned on | E-17 | ○ |
| C-20 | conflicts detected | E-18 | ○ |
| C-21 | accept failed | E-18 | ○ |
| C-22 | too many profiles | E-18 | ○ |
| C-23 | auth failed | E-18 | ○ |
| C-24 | turn on failed with user data sync error | E-18 | ○ |
| C-25 | testError | E-19 | ○ |
| C-26 | testing.markdownPeekError | E-20 | ○ |
| C-27 | comments.addCommand.error | E-21 | ○ |
| C-28 | comments.addFileCommentCommand.error | E-21 | ○ |
| C-29 | failedToOpenUri | E-22 | ○ |
| C-30 | dcrFailedToCopy | E-22 | ○ |
| C-31 | undoRedoService.warning | E-23 | △ |
| C-32 | alreadyDebugging | E-24 | ○ |
| C-33 | GPU描画に関する警告 | **根拠不足** | △ |
| C-34 | keybindingsEditor.error | E-25 | ○ |
| C-35 | integrityService.prompt | E-26 | ○ |
| C-36 | localization.prompt | E-27 | △ |
| C-37 | runningAsRoot | E-28 | ○ |
| C-38 | walkThrough.gitNotFound | E-29 | ○ |
| C-39 | update.notification | E-30 | △ |
| C-40 | mcpMigration.prompt | E-31 | ○ |
| C-41 | noConflictMessage | E-32 | ○ |
| C-42 | remoteTunnel.notification | **根拠不足** | △ |
| C-43 | searchView.error | E-33 | ○ |
| C-44 | noViewRegistered | E-34 | ○ |
| C-45 | clipboardService.prompt | E-35 | ○ |
| C-46 | editorResolver.warning | E-36 | ○ |
| C-47 | secretStorage.error | E-37 | ○ |
| C-48 | configurationEditing.error | E-38 | ○ |
| C-49 | workspace.error | E-39 | ○ |
| C-50 | neverShowAgain | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-31: undoRedoService.warningは複数の警告パターンがあり、全パターンの詳細を特定するには追加調査が必要
  - 候補：`src/vs/platform/undoRedo/common/undoRedoService.ts` / 関連テストファイル
- C-33: GPU関連の警告は`viewGpuContext.ts`から確認できるが、具体的なメッセージ内容が動的に生成される
  - 候補：`src/vs/editor/browser/gpu/viewGpuContext.ts` / WebGPU関連コード
- C-36: ローカライゼーション通知は言語パック関連で複数パターンが存在
  - 候補：`extensions/` 配下の言語パック関連ファイル
- C-39: 更新通知は複数のシナリオ（更新利用可能、再起動要求等）があり網羅確認が必要
  - 候補：`src/vs/workbench/contrib/update/browser/update.ts` / 関連サービス
- C-42: リモートトンネル通知は`remoteTunnel.contribution.ts`に存在するが詳細パターンの特定が必要
  - 候補：`src/vs/workbench/contrib/remoteTunnel/` 配下のファイル

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: No.1-10, 34, 37, 38, 40, 41, 50 - コアシステム通知、明確なエラーメッセージ
- **1（中リスク）**: No.11-30, 43-49 - 機能別通知、追加の文脈確認推奨
- **2（高リスク）**: No.31, 33, 36, 39, 42 - 根拠不足、追加調査必要

## 6) レビュアーチェックリスト（最小）
- [ ] No.31（undoRedo警告）の全パターンが網羅されているか確認
- [ ] No.33（GPU警告）の具体的なメッセージ内容を確認
- [ ] No.36（ローカライゼーション）の通知パターンを追加調査
- [ ] No.39（更新通知）の全シナリオをカバーしているか確認
- [ ] No.42（リモートトンネル）の通知パターンを追加調査
- [ ] 通知の優先度（Priority）情報が必要な場合は追加を検討
- [ ] 通知の表示条件（NeverShowAgainスコープ等）の詳細が必要な場合は追加を検討
