# 通知設計書 11-extensionsDisabled

## 概要

本ドキュメントは、VS Code において全てのインストール済み拡張機能が一時的に無効化された際に表示される `extensionsDisabled` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、VS Code が拡張機能を無効化した状態で起動された場合にユーザーに情報を提供し、拡張機能を再度有効化するためのアクションを提示する。

**業務上の目的・背景**：VS Code の起動オプション `--disable-extensions` やトラブルシューティング機能により、すべての拡張機能が無効化された状態で起動されることがある。この場合、ユーザーは拡張機能が動作しない理由を理解し、必要に応じて拡張機能を再度有効化できる必要がある。拡張機能の競合や問題の切り分けを行う際に特に重要な機能である。

**通知の送信タイミング**：VS Code の起動時、ワークベンチが完全に復元されたフェーズ（`LifecyclePhase.Eventually`）で、`environmentService.disableExtensions` が `true` の場合に通知が表示される。

**通知の受信者**：VS Code を起動したユーザー本人。拡張機能が無効化された状態で VS Code を起動したすべてのユーザーが対象。

**通知内容の概要**：「All installed extensions are temporarily disabled.」というメッセージと、「Reload and Enable Extensions」ボタンが表示される。

**期待されるアクション**：ユーザーは「Reload and Enable Extensions」ボタンをクリックして、拡張機能を有効化した状態で VS Code を再読み込みする。または、問題の調査を続ける場合は通知を閉じて作業を継続する。

## 通知種別

アプリ内通知（Info レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（URGENT） |
| リトライ | 無し |

### 送信先決定ロジック

VS Code を起動したユーザーに対してのみ通知が表示される。特定のロール判定は行わない。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Info |
| スティッキー | Yes |
| 優先度 | URGENT |

### 本文テンプレート

```
All installed extensions are temporarily disabled.
```

### アクションボタン

| ボタン名 | 動作 |
|---------|------|
| Reload and Enable Extensions | `hostService.reload({ disableExtensions: false })` を呼び出し |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知には動的変数は含まれない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| アプリケーション起動 | LifecyclePhase.Eventually | `environmentService.disableExtensions === true` | ワークベンチ復元後に通知表示 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| `allUserExtensionsDisabled === false` | 拡張機能が無効化されていない場合は通知しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[VS Code 起動] --> B{disableExtensions?}
    B -->|true| C[LifecyclePhase.Eventually 待機]
    B -->|false| D[通知なし]
    C --> E[notificationService.prompt 呼び出し]
    E --> F[Info レベル通知表示]
    F --> G{ユーザーアクション}
    G -->|Reload and Enable Extensions| H[hostService.reload]
    G -->|通知を閉じる| I[作業継続]
    H --> J[拡張機能有効で再起動]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | - |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| なし | 通知表示自体はエラーが発生しにくい | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限なし | 起動時に1回のみ表示 |

### 配信時間帯

制限なし（VS Code 起動時に表示）

## セキュリティ考慮事項

本通知には個人情報や機密情報は含まれない。

## 備考

- トラブルシューティング機能（Issue Bisect）からも拡張機能を無効化できる
- `--disable-extensions` コマンドラインオプションで起動した場合にも表示される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、拡張機能の有効化状態を管理するサービスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | extensionEnablementService.ts | `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` | `allUserExtensionsDisabled` プロパティと `environmentService.disableExtensions` の関係 |

**読解のコツ**: TypeScript の getter プロパティ（`get allUserExtensionsDisabled()`）に注目し、条件判定ロジックを追跡する。

#### Step 2: エントリーポイントを理解する

通知が発行される起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | extensionEnablementService.ts | `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` | コンストラクタ内の通知ロジック |

**主要処理フロー**:
1. **行125**: `if (this.allUserExtensionsDisabled)` - 拡張機能無効化状態のチェック
2. **行126**: `this.lifecycleService.when(LifecyclePhase.Eventually).then(...)` - ライフサイクル待機
3. **行127-134**: `this.notificationService.prompt(...)` - 通知の発行

#### Step 3: 通知サービスを理解する

VS Code の通知システムの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | notification.ts | `src/vs/platform/notification/common/notification.ts` | `INotificationService` インターフェースと `Severity` 列挙型 |

**主要処理フロー**:
- **Severity.Info**: 情報レベルの通知
- **sticky: true**: 自動で消えない通知
- **priority: NotificationPriority.URGENT**: 緊急度の高い通知

### プログラム呼び出し階層図

```
VS Code 起動
    │
    ├─ ExtensionEnablementService (コンストラクタ)
    │      │
    │      ├─ allUserExtensionsDisabled チェック
    │      │
    │      └─ lifecycleService.when(LifecyclePhase.Eventually)
    │             │
    │             └─ notificationService.prompt()
    │                    │
    │                    └─ アクション: hostService.reload()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

environmentService   ───▶ ExtensionEnablementService ───▶ Notification
.disableExtensions         (条件チェック)                   (Info レベル)
      │
      └─ true/false

[ユーザーアクション]     [処理]                         [結果]

"Reload and Enable    ───▶ hostService.reload()     ───▶ VS Code 再起動
 Extensions" クリック       ({ disableExtensions:         (拡張機能有効)
                             false })
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| extensionEnablementService.ts | `src/vs/workbench/services/extensionManagement/browser/extensionEnablementService.ts` | ソース | 通知発行元 |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| lifecycle.ts | `src/vs/workbench/services/lifecycle/common/lifecycle.ts` | ソース | ライフサイクル管理 |
| host.ts | `src/vs/workbench/services/host/browser/host.ts` | ソース | ホストサービス（reload 機能） |
