# 通知設計書 12-extensionService.crash

## 概要

本ドキュメントは、VS Code の拡張機能ホストが5分以内に3回予期せず終了した場合に表示される `extensionService.crash` 通知の設計仕様を記述する。

### 本通知の処理概要

この通知は、拡張機能ホストプロセスの繰り返しクラッシュを検出し、ユーザーに問題の存在を通知するとともに、問題解決のためのアクションを提示する。

**業務上の目的・背景**：拡張機能ホストは VS Code の拡張機能を実行するための独立プロセスであり、拡張機能のバグや互換性の問題によりクラッシュすることがある。短時間に繰り返しクラッシュが発生した場合、単なる一時的な問題ではなく、特定の拡張機能に起因する根本的な問題がある可能性が高い。ユーザーが問題を認識し、適切な対処（拡張機能の二分探索、再起動など）を行えるようにすることが重要である。

**通知の送信タイミング**：拡張機能ホストが5分以内に3回予期せず終了した場合に通知が表示される。自動再起動の閾値を超えた時点で発行される。

**通知の受信者**：VS Code を使用しているユーザー本人。拡張機能ホストのクラッシュが発生した環境のユーザーが対象。

**通知内容の概要**：ローカル拡張機能ホストの場合は「Extension host terminated unexpectedly 3 times within the last 5 minutes.」、リモート拡張機能ホストの場合は「Remote Extension host terminated unexpectedly 3 times within the last 5 minutes.」というメッセージが表示される。

**期待されるアクション**：ユーザーは提示されたアクションボタン（Extension Bisect の開始、拡張機能ホストの再起動、詳細情報の確認）から適切な対処を選択する。問題の原因となっている拡張機能を特定し、無効化または更新することが期待される。

## 通知種別

アプリ内通知（Error レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

拡張機能ホストのクラッシュが発生した VS Code インスタンスのユーザーに対して通知が表示される。

## 通知テンプレート

### アプリ内通知

| 項目 | 内容 |
|-----|------|
| 深刻度 | Error |
| スティッキー | デフォルト（明示的な設定なし） |

### 本文テンプレート（ローカル）

```
Extension host terminated unexpectedly 3 times within the last 5 minutes.
```

### 本文テンプレート（リモート）

```
Remote Extension host terminated unexpectedly 3 times within the last 5 minutes.
```

### アクションボタン（ローカル・製品版）

| ボタン名 | 動作 |
|---------|------|
| Start Extension Bisect | `extension.bisect.start` コマンドを実行 |
| Restart Extension Host | `startExtensionHosts()` を呼び出し |
| Learn More | `https://aka.ms/vscode-extension-bisect` を開く |

### アクションボタン（ローカル・開発版）

| ボタン名 | 動作 |
|---------|------|
| Open Developer Tools | `nativeHostService.openDevTools()` を呼び出し |
| Restart Extension Host | `startExtensionHosts()` を呼び出し |

### アクションボタン（リモート）

| ボタン名 | 動作 |
|---------|------|
| Restart Remote Extension Host | `_startExtensionHostsIfNecessary()` を呼び出し |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| なし | 本通知には動的変数は含まれない | - | - |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| システムイベント | 拡張機能ホストクラッシュ | `crashTracker.shouldAutomaticallyRestart() === false` | 5分以内に3回クラッシュした場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 自動再起動が可能な場合 | クラッシュ回数が閾値未満の場合はステータスバー通知のみ |
| バージョンミスマッチの場合 | 別の通知（versionMismatchCrash）が表示される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[拡張機能ホストクラッシュ] --> B{終了コード確認}
    B -->|VersionMismatch| C[versionMismatchCrash 通知]
    B -->|その他| D[クラッシュ登録]
    D --> E{自動再起動可能?}
    E -->|Yes| F[ステータスバー通知]
    F --> G[拡張機能ホスト再起動]
    E -->|No| H[extensionService.crash 通知]
    H --> I{ユーザーアクション}
    I -->|Start Extension Bisect| J[二分探索開始]
    I -->|Restart Extension Host| G
    I -->|Learn More| K[ドキュメント表示]
    I -->|Open Developer Tools| L[DevTools 表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | 本通知ではデータベースは使用しない | クラッシュ追跡はメモリ内で行われる |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リモート接続断 | リモート拡張機能ホストのクラッシュが永続的な切断の場合 | try-catch で無視される |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 制限 | クラッシュトラッカーにより5分以内に3回以上で発動 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- テレメトリデータとして拡張機能ID、終了コード、シグナルが送信される
- 個人情報は含まれない

## 備考

- 自動再起動中は「The extension host terminated unexpectedly. Restarting...」というステータスメッセージが5秒間表示される
- Extension Bisect 機能により、問題の原因となっている拡張機能を二分探索で特定できる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

クラッシュ追跡の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | nativeExtensionService.ts | `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` | `_localCrashTracker` の役割 |
| 1-2 | abstractExtensionService.ts | `src/vs/workbench/services/extensions/common/abstractExtensionService.ts` | `_remoteCrashTracker` の役割 |

**読解のコツ**: CrashTracker クラスの `registerCrash()` と `shouldAutomaticallyRestart()` メソッドに注目し、クラッシュ回数のカウントロジックを追跡する。

#### Step 2: エントリーポイントを理解する

クラッシュ検出の起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | nativeExtensionService.ts | `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` | `_onExtensionHostCrashed` メソッド |

**主要処理フロー**:
1. **行160**: `super._onExtensionHostCrashed()` - 基底クラスのクラッシュ処理呼び出し
2. **行162-163**: 終了コードの確認（VersionMismatch の判定）
3. **行183**: `_localCrashTracker.registerCrash()` - クラッシュ登録
4. **行185**: `shouldAutomaticallyRestart()` - 自動再起動判定
5. **行225**: `notificationService.prompt()` - 通知発行

#### Step 3: リモート拡張機能ホストの処理を理解する

リモート環境での処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | abstractExtensionService.ts | `src/vs/workbench/services/extensions/common/abstractExtensionService.ts` | `_onRemoteExtensionHostCrashed` メソッド |

**主要処理フロー**:
- **行919**: `_remoteCrashTracker.registerCrash()` - リモートクラッシュ登録
- **行921**: `shouldAutomaticallyRestart()` - 自動再起動判定
- **行926**: `notificationService.prompt()` - 通知発行

### プログラム呼び出し階層図

```
ExtensionHost プロセス終了
    │
    ├─ NativeExtensionService._onExtensionHostCrashed()
    │      │
    │      ├─ 終了コード判定
    │      │      └─ VersionMismatch → 別通知
    │      │
    │      ├─ _localCrashTracker.registerCrash()
    │      │
    │      └─ shouldAutomaticallyRestart() 判定
    │             │
    │             ├─ true → ステータス通知 + 自動再起動
    │             │
    │             └─ false → notificationService.prompt()
    │                    │
    │                    ├─ Start Extension Bisect
    │                    ├─ Restart Extension Host
    │                    └─ Learn More
    │
    └─ AbstractExtensionService._onRemoteExtensionHostCrashed()
           │
           └─ （リモート版の同様の処理）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ExtensionHost        ───▶ CrashTracker            ───▶ Notification
クラッシュイベント           (クラッシュ回数追跡)              (Error レベル)
      │                          │
      ├─ exitCode                ├─ registerCrash()
      └─ signal                  └─ shouldAutomaticallyRestart()

[テレメトリ]

クラッシュ情報        ───▶ TelemetryService       ───▶ テレメトリ送信
  │                       (publicLog2)
  ├─ code
  ├─ signal
  └─ extensionIds
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| nativeExtensionService.ts | `src/vs/workbench/services/extensions/electron-browser/nativeExtensionService.ts` | ソース | ローカル拡張機能ホスト管理 |
| abstractExtensionService.ts | `src/vs/workbench/services/extensions/common/abstractExtensionService.ts` | ソース | 拡張機能サービス基底クラス |
| notification.ts | `src/vs/platform/notification/common/notification.ts` | ソース | 通知サービスインターフェース |
| extensionHostExitCode.ts | `src/vs/workbench/services/extensions/common/extensionHostExitCode.ts` | ソース | 終了コード定義 |
